/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManager;

public final class SizeUtility {
    public static final int REFERENCE_SIZE = 8;
    private static Map<Class<?>, int[]> SIZE_ESTIMATES = new HashMap(128);
    private static Set<Class<?>> VARIABLE_SIZE_TYPES = new HashSet();
    private long bigIntegerEstimate;
    private long bigDecimalEstimate;
    private Class<?>[] types;

    public SizeUtility(Class<?>[] types) {
        boolean isValueCacheEnabled = DataTypeManager.isValueCacheEnabled();
        this.bigIntegerEstimate = SizeUtility.getSize(isValueCacheEnabled, DataTypeManager.DefaultDataClasses.BIG_INTEGER);
        this.bigDecimalEstimate = SizeUtility.getSize(isValueCacheEnabled, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        this.types = types;
    }

    public long getBatchSize(boolean accountForValueCache, List<? extends List<?>> data) {
        int colLength = this.types.length;
        int rowLength = data.size();
        long size = 16L + SizeUtility.alignMemory(rowLength * 8);
        size += (long)rowLength * (48L + SizeUtility.alignMemory(colLength * 8));
        for (int col = 0; col < colLength; ++col) {
            Class<?> type = this.types[col];
            int rowsSampled = 0;
            int estimatedSize = 0;
            if (VARIABLE_SIZE_TYPES.contains(type)) {
                int row = 0;
                while (row < rowLength) {
                    ++rowsSampled;
                    estimatedSize = (int)((long)estimatedSize + this.getSize(data.get(row).get(col), this.types[col], true, accountForValueCache));
                    row = row * 2 + 1;
                }
                size = (long)((float)size + (float)estimatedSize / (float)rowsSampled * (float)rowLength);
                continue;
            }
            size += (long)(SizeUtility.getSize(accountForValueCache, type) * rowLength);
        }
        return size;
    }

    static int getSize(boolean isValueCacheEnabled, Class<?> type) {
        int[] vals = SIZE_ESTIMATES.get(type);
        if (vals == null) {
            return 512;
        }
        return vals[isValueCacheEnabled ? 0 : 1];
    }

    protected long getSize(Object obj, Class<?> type, boolean updateEstimate, boolean accountForValueCache) {
        if (obj == null) {
            return 0L;
        }
        if (type == DataTypeManager.DefaultDataClasses.STRING) {
            int length = ((String)obj).length();
            if (length > 0) {
                return SizeUtility.alignMemory(40 + 2 * length);
            }
            return 40L;
        }
        if (type == DataTypeManager.DefaultDataClasses.VARBINARY) {
            int length = ((BinaryType)obj).getLength();
            if (length > 0) {
                return SizeUtility.alignMemory(16 + length);
            }
            return 16L;
        }
        if (type == DataTypeManager.DefaultDataClasses.BIG_DECIMAL) {
            if (!updateEstimate) {
                return this.bigDecimalEstimate;
            }
            int bitLength = ((BigDecimal)obj).unscaledValue().bitLength();
            long result = 88L + SizeUtility.alignMemory(4 + (bitLength >> 3));
            if (updateEstimate) {
                this.bigDecimalEstimate = (this.bigDecimalEstimate + result) / 2L;
            }
            return result;
        }
        if (type == DataTypeManager.DefaultDataClasses.BIG_INTEGER) {
            if (!updateEstimate) {
                return this.bigIntegerEstimate;
            }
            int bitLength = ((BigInteger)obj).bitLength();
            long result = 40L + SizeUtility.alignMemory(4 + (bitLength >> 3));
            if (updateEstimate) {
                this.bigIntegerEstimate = (this.bigIntegerEstimate + result) / 2L;
            }
            return result;
        }
        if (obj instanceof Iterable) {
            Iterable i = (Iterable)obj;
            long total = 16L;
            for (Object object : i) {
                total += this.getSize(object, DataTypeManager.determineDataTypeClass(object), true, false) + 8L;
            }
            return total;
        }
        if (obj.getClass().isArray()) {
            Class<?> componentType = obj.getClass().getComponentType();
            if (!componentType.isPrimitive()) {
                Object[] rows = (Object[])obj;
                long total = 16L + SizeUtility.alignMemory(rows.length * 8);
                for (int i = 0; i < rows.length; ++i) {
                    total += this.getSize(rows[i], DataTypeManager.determineDataTypeClass((Object)rows[i]), true, false);
                }
                return total;
            }
            int length = Array.getLength(obj);
            int primitiveSize = 8;
            if (componentType == Boolean.TYPE) {
                primitiveSize = 4;
            } else if (componentType == Byte.TYPE) {
                primitiveSize = 1;
            } else if (componentType == Short.TYPE) {
                primitiveSize = 2;
            } else if (componentType == Integer.TYPE || componentType == Float.TYPE) {
                primitiveSize = 4;
            }
            return SizeUtility.alignMemory(length * primitiveSize) + 16L;
        }
        return SizeUtility.getSize(accountForValueCache, type);
    }

    private static long alignMemory(long numBytes) {
        long remainder = numBytes % 8L;
        if (remainder != 0L) {
            numBytes += 8L - remainder;
        }
        return numBytes;
    }

    static {
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.STRING, new int[]{100, Math.max(100, DataTypeManager.nextPowOf2((int)(DataTypeManager.MAX_STRING_LENGTH / 16)))});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.VARBINARY, new int[]{100, Math.max(100, DataTypeManager.MAX_LOB_MEMORY_BYTES / 32)});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.DATE, new int[]{20, 28});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.TIME, new int[]{20, 28});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.TIMESTAMP, new int[]{20, 28});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.LONG, new int[]{12, 16});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.DOUBLE, new int[]{12, 16});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.INTEGER, new int[]{6, 12});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.FLOAT, new int[]{6, 12});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.CHAR, new int[]{4, 10});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.SHORT, new int[]{4, 10});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.OBJECT, new int[]{1024, 1024});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.NULL, new int[]{0, 0});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.BYTE, new int[]{1, 1});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.BOOLEAN, new int[]{1, 1});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.BIG_INTEGER, new int[]{75, 100});
        SIZE_ESTIMATES.put(DataTypeManager.DefaultDataClasses.BIG_DECIMAL, new int[]{150, 200});
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.STRING);
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.VARBINARY);
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.OBJECT);
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.BIG_INTEGER);
        VARIABLE_SIZE_TYPES.add(DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
    }
}

