/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.spi.work.Work;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.NamedThreadFactory;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.TeiidExecutor;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;

public class ThreadReuseExecutor
implements TeiidExecutor {
    private final ThreadPoolExecutor tpe;
    private volatile int activeCount;
    private volatile int highestActiveCount;
    private volatile int highestQueueSize;
    private volatile boolean terminated;
    private volatile int submittedCount;
    private volatile int completedCount;
    private Object poolLock = new Object();
    private AtomicInteger threadCounter = new AtomicInteger();
    private Set<Thread> threads = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private String poolName;
    private int maximumPoolSize;
    private Queue<PrioritizedRunnable> queue = new PriorityQueue<PrioritizedRunnable>(11, new Comparator<PrioritizedRunnable>(){

        @Override
        public int compare(PrioritizedRunnable pr1, PrioritizedRunnable pr2) {
            int result = pr1.getPriority() - pr2.getPriority();
            if (result == 0) {
                return Long.signum(pr1.getCreationTime() - pr2.getCreationTime());
            }
            return result;
        }
    });
    private long warnWaitTime = 500L;

    public ThreadReuseExecutor(String name, int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
        this.poolName = name;
        this.tpe = new ThreadPoolExecutor(0, maximumPoolSize, 2L, TimeUnit.MINUTES, new SynchronousQueue(), (ThreadFactory)new NamedThreadFactory("Worker")){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                if (t != null) {
                    LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)t, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30021, new Object[0]));
                }
            }
        };
    }

    @Override
    public void execute(Runnable command) {
        this.executeDirect(new RunnableWrapper(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDirect(final PrioritizedRunnable command) {
        boolean atMaxThreads = false;
        Object object = this.poolLock;
        synchronized (object) {
            this.checkForTermination();
            ++this.submittedCount;
            boolean bl = atMaxThreads = this.activeCount == this.maximumPoolSize;
            if (atMaxThreads) {
                this.queue.add(command);
                int queueSize = this.queue.size();
                if (queueSize > this.highestQueueSize) {
                    this.highestQueueSize = queueSize;
                }
            } else {
                ++this.activeCount;
                this.highestActiveCount = Math.max(this.activeCount, this.highestActiveCount);
            }
        }
        if (atMaxThreads) {
            return;
        }
        this.tpe.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread t = Thread.currentThread();
                ThreadReuseExecutor.this.threads.add(t);
                String name = t.getName();
                t.setName(name + "_" + ThreadReuseExecutor.this.poolName + ThreadReuseExecutor.this.threadCounter.getAndIncrement());
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.RUNTIME", (int)6)) {
                    LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Beginning work with virtual worker", t.getName()});
                }
                PrioritizedRunnable r = command;
                while (r != null) {
                    boolean success = false;
                    try {
                        r.run();
                        success = true;
                    }
                    catch (Throwable throwable) {
                        Object object = ThreadReuseExecutor.this.poolLock;
                        synchronized (object) {
                            if (success) {
                                ThreadReuseExecutor.this.completedCount++;
                                r = (PrioritizedRunnable)ThreadReuseExecutor.this.queue.poll();
                            }
                            if (!success || r == null) {
                                ThreadReuseExecutor.this.threads.remove(t);
                                ThreadReuseExecutor.this.activeCount--;
                                if (ThreadReuseExecutor.this.activeCount == 0 && ThreadReuseExecutor.this.terminated) {
                                    ThreadReuseExecutor.this.poolLock.notifyAll();
                                }
                            }
                        }
                        if (success) {
                            long warnTime = ThreadReuseExecutor.this.warnWaitTime;
                            if (r != null && System.currentTimeMillis() - r.getCreationTime() > warnTime) {
                                LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30009, new Object[]{ThreadReuseExecutor.this.maximumPoolSize, ThreadReuseExecutor.this.poolName, ThreadReuseExecutor.this.highestQueueSize, warnTime}));
                                ThreadReuseExecutor.this.warnWaitTime *= 2L;
                            }
                        }
                        t.setName(name);
                        throw throwable;
                    }
                    Object object = ThreadReuseExecutor.this.poolLock;
                    synchronized (object) {
                        if (success) {
                            ThreadReuseExecutor.this.completedCount++;
                            r = (PrioritizedRunnable)ThreadReuseExecutor.this.queue.poll();
                        }
                        if (!success || r == null) {
                            ThreadReuseExecutor.this.threads.remove(t);
                            ThreadReuseExecutor.this.activeCount--;
                            if (ThreadReuseExecutor.this.activeCount == 0 && ThreadReuseExecutor.this.terminated) {
                                ThreadReuseExecutor.this.poolLock.notifyAll();
                            }
                        }
                    }
                    if (success) {
                        long warnTime = ThreadReuseExecutor.this.warnWaitTime;
                        if (r != null && System.currentTimeMillis() - r.getCreationTime() > warnTime) {
                            LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30009, new Object[]{ThreadReuseExecutor.this.maximumPoolSize, ThreadReuseExecutor.this.poolName, ThreadReuseExecutor.this.highestQueueSize, warnTime}));
                            ThreadReuseExecutor.this.warnWaitTime *= 2L;
                        }
                    }
                    t.setName(name);
                }
            }
        });
    }

    private void checkForTermination() {
        if (this.terminated) {
            throw new RejectedExecutionException();
        }
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public int getSubmittedCount() {
        return this.submittedCount;
    }

    public int getCompletedCount() {
        return this.completedCount;
    }

    public int getPoolSize() {
        return this.activeCount;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void shutdown() {
        this.terminated = true;
    }

    public int getLargestPoolSize() {
        return this.highestActiveCount;
    }

    @Override
    public WorkerPoolStatisticsMetadata getStats() {
        WorkerPoolStatisticsMetadata stats = new WorkerPoolStatisticsMetadata();
        stats.setName(this.poolName);
        stats.setQueued(this.queue.size());
        stats.setHighestQueued(this.highestQueueSize);
        stats.setActiveThreads(this.getActiveCount());
        stats.setMaxThreads(this.maximumPoolSize);
        stats.setTotalSubmitted((long)this.getSubmittedCount());
        stats.setHighestActiveThreads(this.getLargestPoolSize());
        stats.setTotalCompleted((long)this.getCompletedCount());
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWork() {
        Object object = this.poolLock;
        synchronized (object) {
            return this.getSubmittedCount() - this.getCompletedCount() > 0 && !this.isTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        Object object = this.poolLock;
        synchronized (object) {
            Set<Thread> set = this.threads;
            synchronized (set) {
                for (Thread t : this.threads) {
                    t.interrupt();
                }
            }
            ArrayList<Runnable> result = new ArrayList<Runnable>(this.queue);
            this.queue.clear();
            result.addAll(this.tpe.shutdownNow());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long timeoutMillis = unit.toMillis(timeout);
        long finalMillis = System.currentTimeMillis() + timeoutMillis;
        Object object = this.poolLock;
        synchronized (object) {
            while (this.activeCount > 0 || !this.terminated) {
                if (timeoutMillis < 1L) {
                    return false;
                }
                this.poolLock.wait(timeoutMillis);
                timeoutMillis = finalMillis - System.currentTimeMillis();
            }
        }
        return true;
    }

    public static class RunnableWrapper
    implements PrioritizedRunnable,
    Work {
        Runnable r;
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        long creationTime;
        int priority;

        public RunnableWrapper(Runnable r) {
            if (r instanceof PrioritizedRunnable) {
                PrioritizedRunnable pr = (PrioritizedRunnable)r;
                this.creationTime = pr.getCreationTime();
                this.priority = pr.getPriority();
                this.workContext = pr.getDqpWorkContext();
            } else {
                this.creationTime = System.currentTimeMillis();
                this.priority = Integer.MAX_VALUE;
            }
            this.r = r;
        }

        @Override
        public long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public void run() {
            if (this.workContext.getSecurityHelper() != null) {
                this.workContext.getSecurityHelper().clearSecurityContext();
            }
            this.workContext.runInContext(this.r);
        }

        @Override
        public DQPWorkContext getDqpWorkContext() {
            return this.workContext;
        }

        public void release() {
        }
    }

    public static interface PrioritizedRunnable
    extends Runnable {
        public static final int NO_WAIT_PRIORITY = 0;

        public int getPriority();

        public long getCreationTime();

        public DQPWorkContext getDqpWorkContext();
    }
}

