/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.LRUCache;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.processor.relational.TupleSourceValueIterator;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ContextReference;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.util.ValueIterator;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.util.CommandContext;

public class SubqueryAwareEvaluator
extends Evaluator {
    private BufferManager manager;
    private Map<String, SubqueryState> subqueries = new HashMap<String, SubqueryState>();
    private Map<Command, String> commands = new HashMap<Command, String>();
    private LRUCache<List<?>, TupleBuffer> smallCache = new LRUBufferCache(1024, null);
    private LRUCache<List<?>, TupleBuffer> cache = new LRUBufferCache(512, this.smallCache);
    private int maxTuples = 4096;
    private int currentTuples = 0;
    private Map<Function, ScalarSubquery> functionState;

    public SubqueryAwareEvaluator(Map elements, ProcessorDataManager dataMgr, CommandContext context, BufferManager manager) {
        super(elements, dataMgr, context);
        this.manager = manager;
        if (this.manager != null) {
            this.maxTuples = this.manager.getProcessorBatchSize() << 4;
        }
    }

    public void reset() {
        for (SubqueryState subQueryState : this.subqueries.values()) {
            subQueryState.plan.reset();
            subQueryState.close(true);
        }
        this.cache.clear();
        this.smallCache.clear();
        this.currentTuples = 0;
        if (this.functionState != null) {
            this.functionState.clear();
        }
    }

    public void close() {
        this.reset();
        this.commands.clear();
        this.subqueries.clear();
    }

    @Override
    protected ValueIterator evaluateSubquery(SubqueryContainer<?> container, List<?> tuple) throws TeiidProcessingException, BlockedException, TeiidComponentException {
        String otherKey;
        ContextReference ref = (ContextReference)((Object)container);
        String key = ref.getContextSymbol();
        SubqueryState state = this.subqueries.get(key);
        if (state == null && (otherKey = this.commands.get(container.getCommand())) != null && (state = this.subqueries.get(otherKey)) != null) {
            key = otherKey;
        }
        if (state == null) {
            state = new SubqueryState();
            state.plan = ((Command)container.getCommand()).getProcessorPlan().clone();
            if (((Command)container.getCommand()).getCorrelatedReferences() != null) {
                for (ElementSymbol es : ((Command)container.getCommand()).getCorrelatedReferences().getKeys()) {
                    if (!DataTypeManager.isNonComparable((String)DataTypeManager.getDataTypeName(es.getType()))) continue;
                    state.comparable = false;
                    break;
                }
            }
            this.subqueries.put(key, state);
            this.commands.put((Command)container.getCommand(), key);
        }
        SymbolMap correlatedRefs = ((Command)container.getCommand()).getCorrelatedReferences();
        VariableContext currentContext = null;
        boolean shouldClose = false;
        boolean deterministic = true;
        if (state.processor != null) {
            FunctionMethod.Determinism determinism = state.processor.getContext().getDeterminismLevel();
            boolean bl = deterministic = FunctionMethod.Determinism.COMMAND_DETERMINISTIC.compareTo((Enum)determinism) <= 0;
            if (!deterministic) {
                shouldClose = true;
            }
        }
        boolean removeBuffer = true;
        if (correlatedRefs != null) {
            currentContext = new VariableContext();
            for (Map.Entry<ElementSymbol, Expression> entry : ((Command)container.getCommand()).getCorrelatedReferences().asMap().entrySet()) {
                currentContext.setValue(entry.getKey(), this.evaluate(entry.getValue(), tuple));
            }
            List<Object> refValues = currentContext.getLocalValues();
            if (!refValues.equals(state.refValues)) {
                if (state.comparable && deterministic) {
                    if (state.processor != null) {
                        TupleBuffer tb = state.collector.collectTuples();
                        FunctionMethod.Determinism determinism = state.processor.getContext().getDeterminismLevel();
                        boolean bl = deterministic = FunctionMethod.Determinism.COMMAND_DETERMINISTIC.compareTo((Enum)determinism) <= 0;
                        if (deterministic) {
                            this.maxTuples = Math.max(tb.getRowCount() << 2, this.maxTuples);
                            ArrayList<Object> cacheKey = new ArrayList<Object>(state.refValues);
                            cacheKey.add(key);
                            tb.saveBatch();
                            this.cache.put(cacheKey, (Object)tb);
                            removeBuffer = false;
                            this.currentTuples += tb.getRowCount();
                            while (this.currentTuples > this.maxTuples && !this.cache.isEmpty()) {
                                Iterator i = this.cache.values().iterator();
                                TupleBuffer buffer = (TupleBuffer)i.next();
                                if (buffer.getRowCount() <= 2) {
                                    this.smallCache.put(cacheKey, (Object)buffer);
                                } else {
                                    buffer.remove();
                                }
                                this.currentTuples -= buffer.getRowCount();
                                i.remove();
                            }
                        }
                    }
                    ArrayList<Object> cacheKey = new ArrayList<Object>(refValues);
                    cacheKey.add(key);
                    TupleBuffer cachedResult = (TupleBuffer)this.cache.get(cacheKey);
                    if (cachedResult == null) {
                        cachedResult = (TupleBuffer)this.smallCache.get(cacheKey);
                    }
                    if (cachedResult != null) {
                        state.close(false);
                        return new TupleSourceValueIterator(cachedResult.createIndexedTupleSource(), 0);
                    }
                }
                state.refValues = refValues;
                shouldClose = true;
            }
        }
        if (shouldClose) {
            state.close(removeBuffer);
        }
        if (state.processor == null) {
            CommandContext subContext = this.context.clone();
            state.plan.reset();
            state.processor = new QueryProcessor(state.plan, subContext, this.manager, this.dataMgr);
            if (currentContext != null) {
                state.processor.getContext().pushVariableContext(currentContext);
            }
            state.collector = state.processor.createBatchCollector();
        }
        return new TupleSourceValueIterator(state.collector.collectTuples().createIndexedTupleSource(), 0);
    }

    @Override
    protected Object evaluatePushdown(Function function, List<?> tuple, Object[] values) throws TeiidComponentException, TeiidProcessingException {
        FunctionDescriptor fd = function.getFunctionDescriptor();
        if (fd.getMethod() == null || !CapabilitiesUtil.supports(SourceCapabilities.Capability.SELECT_WITHOUT_FROM, fd.getMethod().getParent(), this.context.getMetadata(), this.context.getQueryProcessorFactory().getCapabiltiesFinder())) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30341, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30341, new Object[]{function.getFunctionDescriptor().getFullName()}));
        }
        ScalarSubquery ss = null;
        if (this.functionState != null) {
            ss = this.functionState.get(function);
        }
        Expression[] functionArgs = new Expression[values.length];
        for (int i = 0; i < values.length; ++i) {
            functionArgs[i] = new Constant(values[i]);
        }
        if (ss == null) {
            Query command = new Query();
            Select select = new Select();
            command.setSelect(select);
            Function f = new Function(function.getName(), functionArgs);
            f.setType(function.getType());
            f.setFunctionDescriptor(function.getFunctionDescriptor());
            select.addSymbol(f);
            ss = new ScalarSubquery(command);
            SymbolMap correlatedReferences = new SymbolMap();
            Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)function, true);
            if (!elements.isEmpty()) {
                for (ElementSymbol es : elements) {
                    correlatedReferences.addMapping(es, es);
                }
                command.setCorrelatedReferences(correlatedReferences);
            }
            command.setProcessorPlan(new SimpleProcessorPlan(command, fd, Arrays.asList(new Constant(null, fd.getReturnType()))));
        } else {
            ((Function)((ExpressionSymbol)ss.getCommand().getProjectedSymbols().get(0)).getExpression()).setArgs(functionArgs);
        }
        if (this.functionState == null) {
            this.functionState = new HashMap<Function, ScalarSubquery>(2);
        }
        this.functionState.put(function, ss);
        return this.internalEvaluate(ss, tuple);
    }

    public static class SubqueryState {
        QueryProcessor processor;
        BatchCollector collector;
        ProcessorPlan plan;
        List<Object> refValues;
        boolean comparable = true;

        void close(boolean removeBuffer) {
            if (this.processor == null) {
                return;
            }
            this.processor.closeProcessing();
            if (removeBuffer) {
                this.collector.getTupleBuffer().remove();
            }
            this.processor = null;
        }
    }

    private final class LRUBufferCache
    extends LRUCache<List<?>, TupleBuffer> {
        private LRUCache<List<?>, TupleBuffer> spillOver;

        private LRUBufferCache(int maxSize, LRUCache<List<?>, TupleBuffer> spillOver) {
            super(maxSize);
            this.spillOver = spillOver;
        }

        protected boolean removeEldestEntry(Map.Entry<List<?>, TupleBuffer> eldest) {
            if (super.removeEldestEntry(eldest)) {
                if (this.spillOver != null && eldest.getValue().getRowCount() <= 2) {
                    this.spillOver.put(eldest.getKey(), (Object)eldest.getValue());
                } else {
                    eldest.getValue().remove();
                }
                return true;
            }
            return false;
        }

        public void clear() {
            if (!this.isEmpty()) {
                for (TupleBuffer buffer : this.values()) {
                    buffer.remove();
                }
                super.clear();
            }
        }
    }

    private static final class SimpleProcessorPlan
    extends ProcessorPlan {
        private final Query command;
        private final FunctionDescriptor fd;
        private ProcessorDataManager dataMgr;
        TupleSource ts;
        private List<? extends Expression> output;

        private SimpleProcessorPlan(Query command, FunctionDescriptor fd, List<? extends Expression> output) {
            this.command = command;
            this.fd = fd;
            this.output = output;
        }

        @Override
        public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
            super.initialize(context, dataMgr, bufferMgr);
            this.dataMgr = dataMgr;
        }

        @Override
        public void open() throws TeiidComponentException, TeiidProcessingException {
            RegisterRequestParameter parameterObject = new RegisterRequestParameter();
            this.ts = this.dataMgr.registerRequest(this.getContext(), this.command, this.fd.getSchema(), parameterObject);
        }

        @Override
        public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
            ArrayList result = new ArrayList(2);
            List<?> list = this.ts.nextTuple();
            if (list != null) {
                result.add(list);
                list = this.ts.nextTuple();
                if (list != null) {
                    result.add(list);
                }
            }
            this.ts.closeSource();
            TupleBatch tb = new TupleBatch(1, result);
            tb.setTerminationFlag(true);
            return tb;
        }

        @Override
        public List getOutputElements() {
            return this.output;
        }

        @Override
        public void close() throws TeiidComponentException {
            if (this.ts != null) {
                this.ts.closeSource();
            }
            this.ts = null;
        }

        @Override
        public void reset() {
            this.ts = null;
        }

        @Override
        public ProcessorPlan clone() {
            return new SimpleProcessorPlan(this.command, this.fd, this.output);
        }
    }
}

