/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.activation.DataSource;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.ResizingArrayList;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.StandardXMLTranslator;
import org.teiid.core.types.Streamable;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.datamgr.ExecutionContextImpl;
import org.teiid.dqp.internal.datamgr.LanguageBridgeFactory;
import org.teiid.dqp.internal.datamgr.ProcedureBatchHandler;
import org.teiid.dqp.internal.datamgr.RuntimeMetadataImpl;
import org.teiid.dqp.internal.process.SaveOnReadInputStream;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.language.Call;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.resource.spi.WrappedConnection;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.ReusableExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.util.XMLInputStream;

public class ConnectorWorkItem
implements ConnectorWork {
    private AtomicRequestID id;
    private ConnectorManager manager;
    private AtomicRequestMessage requestMsg;
    private ExecutionFactory<Object, Object> connector;
    private RuntimeMetadataImpl queryMetadata;
    private Object connection;
    private Object connectionFactory;
    private ExecutionContextImpl securityContext;
    private volatile ResultSetExecution execution;
    private ProcedureBatchHandler procedureBatchHandler;
    private int expectedColumns;
    private boolean lastBatch;
    private int rowCount;
    private boolean error;
    private AtomicBoolean isCancelled = new AtomicBoolean();
    private org.teiid.language.Command translatedCommand;
    private DataNotAvailableException dnae;
    private FileStore lobStore;
    private byte[] lobBuffer;
    private boolean[] convertToRuntimeType;
    private boolean[] convertToDesiredRuntimeType;
    private boolean[] isLob;
    private Class<?>[] schema;
    private boolean explicitClose;
    private boolean copyLobs;
    private boolean areLobsUsableAfterClose;
    private TeiidException conversionError;

    ConnectorWorkItem(AtomicRequestMessage message, ConnectorManager manager) throws TeiidComponentException {
        this.id = message.getAtomicRequestID();
        this.requestMsg = message;
        this.manager = manager;
        AtomicRequestID requestID = this.requestMsg.getAtomicRequestID();
        this.securityContext = new ExecutionContextImpl(message.getCommandContext(), this.requestMsg.getConnectorName(), Integer.toString(requestID.getNodeID()), Integer.toString(requestID.getExecutionId()));
        SourceHint hint = message.getCommand().getSourceHint();
        if (hint != null) {
            this.securityContext.setGeneralHints(hint.getGeneralHints());
            this.securityContext.setHints(hint.getSpecificHint(message.getConnectorName()).getHints());
        }
        this.securityContext.setBatchSize(this.requestMsg.getFetchSize());
        this.securityContext.setSession(this.requestMsg.getWorkContext().getSession());
        this.connector = manager.getExecutionFactory();
        VDBMetaData vdb = this.requestMsg.getWorkContext().getVDB();
        QueryMetadataInterface qmi = vdb.getAttachment(QueryMetadataInterface.class);
        qmi = new TempMetadataAdapter(qmi, new TempMetadataStore());
        this.queryMetadata = new RuntimeMetadataImpl(qmi);
        this.securityContext.setRuntimeMetadata(this.queryMetadata);
        this.securityContext.setTransactional(this.requestMsg.isTransactional());
        LanguageBridgeFactory factory = new LanguageBridgeFactory(this.queryMetadata);
        factory.setConvertIn(!this.connector.supportsInCriteria());
        try {
            factory.setSupportsConcat2(manager.getCapabilities().supportsFunction("concat2"));
        }
        catch (TranslatorException e) {
            throw new TeiidComponentException(e);
        }
        this.translatedCommand = factory.translate(message.getCommand());
        List<Expression> symbols = this.requestMsg.getCommand().getProjectedSymbols();
        this.schema = new Class[symbols.size()];
        this.convertToDesiredRuntimeType = new boolean[symbols.size()];
        this.convertToRuntimeType = new boolean[symbols.size()];
        this.isLob = new boolean[symbols.size()];
        for (int i = 0; i < symbols.size(); ++i) {
            Expression symbol = symbols.get(i);
            this.schema[i] = symbol.getType();
            this.convertToDesiredRuntimeType[i] = true;
            this.convertToRuntimeType[i] = true;
            this.isLob[i] = DataTypeManager.isLOB(this.schema[i]);
        }
        this.areLobsUsableAfterClose = this.connector.areLobsUsableAfterClose();
        this.copyLobs = this.connector.isCopyLobs();
    }

    public AtomicRequestID getId() {
        return this.id;
    }

    @Override
    public void cancel() {
        try {
            LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.id, "Processing CANCEL request"});
            if (this.isCancelled.compareAndSet(false, true)) {
                this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.CANCEL, -1);
                if (this.execution != null) {
                    this.execution.cancel();
                }
                LogManager.logDetail("org.teiid.CONNECTOR", (Object)QueryPlugin.Util.getString("DQPCore.The_atomic_request_has_been_cancelled", this.id));
            }
        }
        catch (TranslatorException e) {
            LogManager.logWarning("org.teiid.CONNECTOR", e, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30024, this.id));
        }
    }

    @Override
    public synchronized AtomicResultsMessage more() throws TranslatorException {
        if (this.dnae != null) {
            DataNotAvailableException e = this.dnae;
            this.dnae = null;
            throw e;
        }
        if (this.conversionError != null) {
            throw this.handleError(this.conversionError);
        }
        LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.id, "Processing MORE request"});
        try {
            return this.handleBatch();
        }
        catch (Throwable t) {
            throw this.handleError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized void close() {
        block15: {
            this.lobBuffer = null;
            this.lobStore = null;
            if (!this.manager.removeState(this.id)) {
                return;
            }
            LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.id, "Processing Close :", this.requestMsg.getCommand()});
            if (!this.error) {
                this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.END, this.rowCount);
            }
            if (this.execution != null) {
                this.execution.close();
                LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.id, "Closed execution"});
                if (this.execution instanceof ReusableExecution) {
                    this.requestMsg.getCommandContext().putReusableExecution(this.manager.getId(), (ReusableExecution)((Object)this.execution));
                }
            }
            if (this.connection == null) break block15;
            try {
                this.connector.closeConnection(this.connection, this.connectionFactory);
            }
            catch (Throwable e) {
                LogManager.logError("org.teiid.CONNECTOR", e, e.getMessage());
            }
            LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.id, "Closed connection"});
            break block15;
            catch (Throwable e) {
                try {
                    LogManager.logError("org.teiid.CONNECTOR", e, e.getMessage());
                    if (this.connection == null) break block15;
                }
                catch (Throwable throwable) {
                    if (this.connection != null) {
                        try {
                            this.connector.closeConnection(this.connection, this.connectionFactory);
                        }
                        catch (Throwable e2) {
                            LogManager.logError("org.teiid.CONNECTOR", e2, e2.getMessage());
                        }
                        LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.id, "Closed connection"});
                    }
                    throw throwable;
                }
                try {
                    this.connector.closeConnection(this.connection, this.connectionFactory);
                }
                catch (Throwable e3) {
                    LogManager.logError("org.teiid.CONNECTOR", e3, e3.getMessage());
                }
                LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.id, "Closed connection"});
            }
        }
    }

    private TranslatorException handleError(Throwable t) {
        if (t instanceof DataNotAvailableException) {
            throw (DataNotAvailableException)t;
        }
        this.error = true;
        if (t instanceof RuntimeException && t.getCause() != null) {
            t = t.getCause();
        }
        this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.ERROR, null);
        String msg = QueryPlugin.Util.getString("ConnectorWorker.process_failed", this.id);
        if (this.isCancelled.get()) {
            LogManager.logDetail("org.teiid.CONNECTOR", (Object)msg);
        } else if (t instanceof TranslatorException || t instanceof TeiidProcessingException) {
            LogManager.logWarning("org.teiid.CONNECTOR", t, msg);
        } else {
            LogManager.logError("org.teiid.CONNECTOR", t, msg);
        }
        if (t instanceof TranslatorException) {
            return (TranslatorException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        return new TranslatorException(t);
    }

    @Override
    public synchronized void execute() throws TranslatorException {
        if (this.isCancelled()) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30476, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30476, new Object[0]));
        }
        try {
            if (this.execution == null) {
                Execution exec;
                if (this.connection == null) {
                    block15: {
                        LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.requestMsg.getAtomicRequestID(), "Processing NEW request:", this.requestMsg.getCommand()});
                        try {
                            this.connectionFactory = this.manager.getConnectionFactory();
                        }
                        catch (TranslatorException e) {
                            if (!this.connector.isSourceRequired()) break block15;
                            throw e;
                        }
                    }
                    if (this.connectionFactory != null) {
                        this.connection = this.connector.getConnection(this.connectionFactory, this.securityContext);
                    }
                    if (this.connection == null && this.connector.isSourceRequired()) {
                        throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID31108, QueryPlugin.Util.getString("datasource_not_found", this.manager.getConnectionName()));
                    }
                }
                Connection unwrapped = null;
                if (this.connection instanceof WrappedConnection) {
                    try {
                        unwrapped = ((WrappedConnection)this.connection).unwrap();
                    }
                    catch (ResourceException e) {
                        throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30477, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30477, new Object[0]));
                    }
                }
                Command command = this.requestMsg.getCommand();
                this.expectedColumns = command.getProjectedSymbols().size();
                if (command instanceof StoredProcedure) {
                    this.expectedColumns = ((StoredProcedure)command).getResultSetColumns().size();
                }
                if ((exec = this.requestMsg.getCommandContext().getReusableExecution(this.manager.getId())) != null) {
                    exec.reset(this.translatedCommand, this.securityContext, this.connection);
                } else {
                    exec = this.connector.createExecution(this.translatedCommand, this.securityContext, this.queryMetadata, unwrapped == null ? this.connection : unwrapped);
                }
                this.setExecution(command, this.translatedCommand, exec);
                LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.requestMsg.getAtomicRequestID(), "Obtained execution"});
                this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.NEW, null);
            }
            this.execution.execute();
            LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.id, "Executed command"});
        }
        catch (Throwable t) {
            throw this.handleError(t);
        }
    }

    private void setExecution(Command command, org.teiid.language.Command translatedCommand, final Execution exec) {
        if (translatedCommand instanceof Call) {
            this.execution = Assertion.isInstanceOf(exec, ProcedureExecution.class, "Call Executions are expected to be ProcedureExecutions");
            StoredProcedure proc = (StoredProcedure)command;
            if (proc.returnParameters()) {
                this.procedureBatchHandler = new ProcedureBatchHandler((Call)translatedCommand, (ProcedureExecution)exec);
            }
        } else if (command instanceof QueryCommand) {
            this.execution = Assertion.isInstanceOf(exec, ResultSetExecution.class, "QueryExpression Executions are expected to be ResultSetExecutions");
        } else {
            Assertion.isInstanceOf(exec, UpdateExecution.class, "Update Executions are expected to be UpdateExecutions");
            this.execution = new ResultSetExecution(){
                private int[] results;
                private int index;

                @Override
                public void cancel() throws TranslatorException {
                    exec.cancel();
                }

                @Override
                public void close() {
                    exec.close();
                }

                @Override
                public void execute() throws TranslatorException {
                    exec.execute();
                }

                @Override
                public List<?> next() throws TranslatorException, DataNotAvailableException {
                    if (this.results == null) {
                        this.results = ((UpdateExecution)exec).getUpdateCounts();
                    }
                    if (this.index < this.results.length) {
                        return Arrays.asList(this.results[this.index++]);
                    }
                    return null;
                }
            };
        }
    }

    protected AtomicResultsMessage handleBatch() throws TranslatorException {
        List<?> row;
        ResizingArrayList<List> rows;
        block17: {
            int batchSize;
            Assertion.assertTrue(!this.lastBatch);
            LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.id, "Getting results from connector"});
            rows = new ResizingArrayList<List>(batchSize / 4);
            try {
                for (batchSize = 0; batchSize < this.requestMsg.getFetchSize(); ++batchSize) {
                    row = this.execution.next();
                    if (row == null) {
                        this.lastBatch = true;
                        break;
                    }
                    if (row.size() != this.expectedColumns) {
                        throw new AssertionError((Object)("Inproper results returned.  Expected " + this.expectedColumns + " columns, but was " + row.size()));
                    }
                    try {
                        this.correctTypes(row);
                    }
                    catch (TeiidException e) {
                        this.conversionError = e;
                        break;
                    }
                    if (this.procedureBatchHandler != null) {
                        row = this.procedureBatchHandler.padRow(row);
                    }
                    ++this.rowCount;
                    rows.add(row);
                    if (this.requestMsg.getMaxResultRows() <= -1 || this.rowCount < this.requestMsg.getMaxResultRows()) continue;
                    if (this.rowCount != this.requestMsg.getMaxResultRows() || this.requestMsg.isExceptionOnMaxRows()) continue;
                    LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.id, "Exceeded max, returning", this.requestMsg.getMaxResultRows()});
                    this.lastBatch = true;
                    break;
                }
            }
            catch (DataNotAvailableException e) {
                if (rows.size() == 0) {
                    throw e;
                }
                if (e.getWaitUntil() == null) break block17;
                this.dnae = e;
            }
        }
        if (this.lastBatch) {
            if (this.procedureBatchHandler != null && (row = this.procedureBatchHandler.getParameterRow()) != null) {
                try {
                    this.correctTypes(row);
                    rows.add(row);
                }
                catch (TeiidException e) {
                    this.lastBatch = false;
                    this.conversionError = e;
                }
            }
            LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.id, "Obtained last batch, total row count:", this.rowCount});
        } else {
            LogManager.logDetail("org.teiid.CONNECTOR", new Object[]{this.id, "Obtained results from connector, current row count:", this.rowCount});
        }
        int currentRowCount = rows.size();
        if (!this.lastBatch && currentRowCount == 0) {
            LogManager.logWarning("org.teiid.CONNECTOR", QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30004, this.requestMsg.getConnectorName()));
        }
        AtomicResultsMessage response = ConnectorWorkItem.createResultsMessage(rows.toArray((T[])new List[currentRowCount]));
        response.setSupportsImplicitClose(!this.securityContext.keepExecutionAlive() && !this.explicitClose);
        response.setWarnings(this.securityContext.getWarnings());
        if (this.securityContext.getCacheDirective() != null) {
            response.setScope(this.securityContext.getCacheDirective().getScope());
        }
        if (this.lastBatch) {
            response.setFinalRow(this.rowCount);
        }
        return response;
    }

    public static AtomicResultsMessage createResultsMessage(List<?>[] batch) {
        return new AtomicResultsMessage(batch);
    }

    boolean isCancelled() {
        return this.isCancelled.get();
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public boolean isDataAvailable() {
        return this.securityContext.isDataAvailable();
    }

    @Override
    public CacheDirective getCacheDirective() throws TranslatorException {
        CacheDirective cd = this.connector.getCacheDirective(this.translatedCommand, this.securityContext, this.queryMetadata);
        this.securityContext.setCacheDirective(cd);
        return cd;
    }

    @Override
    public boolean isForkable() {
        return this.connector.isForkable();
    }

    @Override
    public boolean isThreadBound() {
        return this.connector.isThreadBound();
    }

    private List<?> correctTypes(List row) throws TransformationException, TeiidComponentException {
        for (int i = 0; i < row.size(); ++i) {
            Streamable<?> result;
            Object value = row.get(i);
            if (value == null) continue;
            if (this.convertToRuntimeType[i]) {
                result = ConnectorWorkItem.convertToRuntimeType(this.requestMsg.getBufferManager(), value, this.schema[i]);
                if (value == result && !DataTypeManager.DefaultDataClasses.OBJECT.equals(this.schema[i])) {
                    this.convertToRuntimeType[i] = false;
                } else {
                    if (!this.explicitClose && this.isLob[i] && !this.copyLobs && !this.areLobsUsableAfterClose && DataTypeManager.isLOB(result.getClass()) && DataTypeManager.isLOB(DataTypeManager.convertToRuntimeType(value, false).getClass())) {
                        this.explicitClose = true;
                    }
                    row.set(i, result);
                    value = result;
                }
            }
            if (this.convertToDesiredRuntimeType[i]) {
                if (value == null) continue;
                result = DataTypeManager.transformValue(value, value.getClass(), this.schema[i]);
                if (this.isLob[i] && this.copyLobs) {
                    if (this.lobStore == null) {
                        this.lobStore = this.requestMsg.getBufferManager().createFileStore("lobs");
                        this.lobBuffer = new byte[16384];
                    }
                    result = this.requestMsg.getBufferManager().persistLob(result, this.lobStore, this.lobBuffer);
                } else if (value == result) {
                    this.convertToDesiredRuntimeType[i] = false;
                    continue;
                }
                row.set(i, result);
                continue;
            }
            if (!DataTypeManager.isValueCacheEnabled()) continue;
            row.set(i, DataTypeManager.getCanonicalValue(value));
        }
        return row;
    }

    static Object convertToRuntimeType(BufferManager bm, Object value, Class<?> desiredType) throws TransformationException {
        if (desiredType != DataTypeManager.DefaultDataClasses.XML || !(value instanceof Source)) {
            if (value instanceof InputStreamFactory) {
                return new BlobType(new BlobImpl((InputStreamFactory)value));
            }
            if (value instanceof DataSource) {
                FileStore fs = bm.createFileStore("bytes");
                FileStoreInputStreamFactory fsisf = new FileStoreInputStreamFactory(fs, "UTF-8");
                try {
                    SaveOnReadInputStream is = new SaveOnReadInputStream(((DataSource)value).getInputStream(), fsisf);
                    return new BlobType(new BlobImpl(is.getInputStreamFactory()));
                }
                catch (IOException e) {
                    throw new TransformationException(QueryPlugin.Event.TEIID30500, e, e.getMessage());
                }
            }
        }
        if (value instanceof Source) {
            if (!(value instanceof InputStreamFactory)) {
                if (value instanceof StreamSource) {
                    StreamSource ss = (StreamSource)value;
                    InputStream is = ss.getInputStream();
                    Reader r = ss.getReader();
                    if (is == null && r != null) {
                        is = new ReaderInputStream(r, Streamable.CHARSET);
                    }
                    FileStore fs = bm.createFileStore("xml");
                    FileStoreInputStreamFactory fsisf = new FileStoreInputStreamFactory(fs, "UTF-8");
                    value = new SaveOnReadInputStream(is, fsisf).getInputStreamFactory();
                } else {
                    SQLXMLImpl sqlxml;
                    if (value instanceof StAXSource) {
                        StAXSource ss = (StAXSource)value;
                        try {
                            FileStore fs = bm.createFileStore("xml");
                            FileStoreInputStreamFactory fsisf = new FileStoreInputStreamFactory(fs, "UTF-8");
                            value = new SaveOnReadInputStream(new XMLInputStream(ss, XMLSystemFunctions.getOutputFactory()), fsisf).getInputStreamFactory();
                        }
                        catch (XMLStreamException e) {
                            throw new TransformationException(e);
                        }
                    }
                    StandardXMLTranslator sxt = new StandardXMLTranslator((Source)value);
                    try {
                        sqlxml = XMLSystemFunctions.saveToBufferManager(bm, sxt);
                    }
                    catch (TeiidComponentException e) {
                        throw new TransformationException(e);
                    }
                    catch (TeiidProcessingException e) {
                        throw new TransformationException(e);
                    }
                    return new XMLType(sqlxml);
                }
            }
            return new XMLType(new SQLXMLImpl((InputStreamFactory)value));
        }
        return DataTypeManager.convertToRuntimeType(value, desiredType != DataTypeManager.DefaultDataClasses.OBJECT);
    }
}

