/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.Serializable;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.cache.Cachable;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.process.AccessInfo;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;

public class CachedResults
implements Serializable,
Cachable {
    private static final long serialVersionUID = -5603182134635082207L;
    private transient Command command;
    private transient TupleBuffer results;
    private String uuid;
    private boolean hasLobs;
    private int rowLimit;
    private AccessInfo accessInfo = new AccessInfo();

    public String getId() {
        return this.uuid;
    }

    public TupleBuffer getResults() {
        return this.results;
    }

    public void setResults(TupleBuffer results, ProcessorPlan plan) {
        this.results = results;
        this.uuid = results.getId();
        this.hasLobs = results.isLobs();
        if (plan != null) {
            this.accessInfo.populate(plan.getContext(), true);
        }
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public synchronized Command getCommand(String sql, QueryMetadataInterface metadata, ParseInfo info) throws QueryParserException, QueryResolverException, TeiidComponentException {
        if (this.command == null) {
            this.command = QueryParser.getQueryParser().parseCommand(sql, info);
        }
        QueryResolver.resolveCommand(this.command, metadata);
        return this.command;
    }

    @Override
    public boolean prepare(TupleBufferCache bufferManager) {
        Assertion.assertTrue(!this.results.isForwardOnly());
        bufferManager.distributeTupleBuffer(this.results.getId(), this.results);
        return true;
    }

    @Override
    public synchronized boolean restore(TupleBufferCache bufferManager) {
        if (this.results == null) {
            if (this.hasLobs) {
                return false;
            }
            TupleBuffer buffer = bufferManager.getTupleBuffer(this.uuid);
            if (buffer != null) {
                this.results = buffer;
            }
            try {
                this.accessInfo.restore();
            }
            catch (TeiidException e) {
                LogManager.logWarning("org.teiid.PROCESSOR", e, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30025, new Object[0]));
                return false;
            }
        }
        return this.results != null;
    }

    @Override
    public AccessInfo getAccessInfo() {
        return this.accessInfo;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }
}

