/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.util.CommandContext;

public class RulePushLimit
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        List<PlanNode> limitNodes = NodeEditor.findAllNodes(plan, 1024);
        boolean pushRaiseNull = false;
        while (!limitNodes.isEmpty()) {
            PlanNode childProject;
            PlanNode limitNode = limitNodes.get(0);
            Expression limit = (Expression)limitNode.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
            if (limit instanceof Constant && new Integer(0).equals(((Constant)limit).getValue()) && (childProject = NodeEditor.findNodePreOrder(limitNode, 8)) != null && childProject.getProperty(NodeConstants.Info.INTO_GROUP) == null) {
                FrameUtil.replaceWithNullNode(limitNode.getFirstChild());
                PlanNode projectNode = NodeFactory.getNewNode(8);
                projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, childProject.getProperty(NodeConstants.Info.PROJECT_COLS));
                limitNode.getFirstChild().addAsParent(projectNode);
                pushRaiseNull = true;
                limitNodes.remove(limitNode);
                continue;
            }
            if (NodeEditor.findAllNodes(limitNode, 1).isEmpty()) {
                limitNodes.remove(limitNode);
                continue;
            }
            while (this.canPushLimit(plan, limitNode, limitNodes, metadata, capabilitiesFinder, analysisRecord)) {
                plan = RuleRaiseAccess.performRaise(plan, limitNode.getFirstChild(), limitNode);
                limitNode.setProperty(NodeConstants.Info.OUTPUT_COLS, limitNode.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS));
            }
            limitNodes.remove(limitNode);
            if (!limitNode.hasBooleanProperty(NodeConstants.Info.IS_COPIED)) continue;
            limitNode.getParent().replaceChild(limitNode, limitNode.getFirstChild());
        }
        if (pushRaiseNull) {
            rules.push(RuleConstants.RAISE_NULL);
        }
        return plan;
    }

    boolean canPushLimit(PlanNode rootNode, PlanNode limitNode, List<PlanNode> limitNodes, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord record) throws QueryMetadataException, TeiidComponentException {
        PlanNode child = limitNode.getFirstChild();
        if (child == null || child.getChildCount() == 0) {
            return false;
        }
        Expression parentLimit = (Expression)limitNode.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
        Expression parentOffset = (Expression)limitNode.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT);
        switch (child.getType()) {
            case 1024: {
                Expression childLimit = (Expression)child.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
                Expression childOffset = (Expression)child.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT);
                RulePushLimit.combineLimits(limitNode, metadata, parentLimit, parentOffset, childLimit, childOffset);
                if (child.hasBooleanProperty(NodeConstants.Info.IS_NON_STRICT)) {
                    limitNode.setProperty(NodeConstants.Info.IS_NON_STRICT, true);
                }
                NodeEditor.removeChildNode(limitNode, child);
                limitNodes.remove(child);
                return this.canPushLimit(rootNode, limitNode, limitNodes, metadata, capFinder, record);
            }
            case 256: {
                if (!SetQuery.Operation.UNION.equals(child.getProperty(NodeConstants.Info.SET_OPERATION))) {
                    return false;
                }
                if (!child.hasBooleanProperty(NodeConstants.Info.USE_ALL) && !limitNode.hasBooleanProperty(NodeConstants.Info.IS_NON_STRICT)) {
                    return false;
                }
                LinkedList<PlanNode> grandChildren = new LinkedList<PlanNode>(child.getChildren());
                for (PlanNode grandChild : grandChildren) {
                    PlanNode newLimit = RulePushLimit.newLimit(limitNode);
                    newLimit.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, RulePushLimit.op("+", parentLimit, parentOffset, metadata.getFunctionLibrary()));
                    grandChild.addAsParent(newLimit);
                    limitNodes.add(newLimit);
                    if (grandChild.getType() != 256) continue;
                    newLimit.setProperty(NodeConstants.Info.IS_COPIED, true);
                }
                return false;
            }
            case 4: {
                PlanNode newLimit;
                JoinType joinType = (JoinType)child.getProperty(NodeConstants.Info.JOIN_TYPE);
                boolean pushLeft = false;
                boolean pushRight = false;
                if (joinType == JoinType.JOIN_CROSS) {
                    pushLeft = true;
                    pushRight = true;
                } else if (joinType == JoinType.JOIN_LEFT_OUTER || joinType == JoinType.JOIN_FULL_OUTER) {
                    pushLeft = true;
                }
                if (pushLeft) {
                    newLimit = RulePushLimit.newLimit(limitNode);
                    newLimit.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, RulePushLimit.op("+", parentLimit, parentOffset, metadata.getFunctionLibrary()));
                    child.getFirstChild().addAsParent(newLimit);
                    limitNodes.add(newLimit);
                }
                if (pushRight) {
                    newLimit = RulePushLimit.newLimit(limitNode);
                    newLimit.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, RulePushLimit.op("+", parentLimit, parentOffset, metadata.getFunctionLibrary()));
                    child.getLastChild().addAsParent(newLimit);
                    limitNodes.add(newLimit);
                }
                return false;
            }
            case 1: {
                RulePushLimit.raiseAccessOverLimit(rootNode, child, metadata, capFinder, limitNode, record);
                return false;
            }
            case 8: {
                return child.getProperty(NodeConstants.Info.INTO_GROUP) == null && !child.hasProperty(NodeConstants.Info.HAS_WINDOW_FUNCTIONS);
            }
            case 64: {
                GroupSymbol virtualGroup = child.getGroups().iterator().next();
                if (virtualGroup.isProcedure()) {
                    return false;
                }
                return !FrameUtil.isProcedure(child.getFirstChild());
            }
            case 2: 
            case 16: {
                return limitNode.hasBooleanProperty(NodeConstants.Info.IS_NON_STRICT);
            }
        }
        return false;
    }

    private static PlanNode newLimit(PlanNode limitNode) {
        PlanNode newLimit = NodeFactory.getNewNode(1024);
        if (limitNode.hasBooleanProperty(NodeConstants.Info.IS_NON_STRICT)) {
            newLimit.setProperty(NodeConstants.Info.IS_NON_STRICT, Boolean.TRUE);
        }
        return newLimit;
    }

    static void combineLimits(PlanNode limitNode, QueryMetadataInterface metadata, Expression parentLimit, Expression parentOffset, Expression childLimit, Expression childOffset) {
        Expression minLimit = null;
        Expression offSet = null;
        if (childLimit == null) {
            minLimit = parentLimit;
            offSet = RulePushLimit.op("+", childOffset, parentOffset, metadata.getFunctionLibrary());
        } else {
            minLimit = RulePushLimit.getMinValue(parentLimit, RulePushLimit.op("-", childLimit, parentOffset, metadata.getFunctionLibrary()));
            offSet = childOffset;
            if (offSet == null) {
                offSet = parentOffset;
            }
        }
        limitNode.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, minLimit);
        limitNode.setProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT, offSet);
    }

    static PlanNode raiseAccessOverLimit(PlanNode rootNode, PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode parentNode, AnalysisRecord analysisRecord) throws QueryMetadataException, TeiidComponentException {
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
        if (modelID == null) {
            return null;
        }
        Expression limit = (Expression)parentNode.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
        if (limit != null && !CapabilitiesUtil.supportsRowLimit(modelID, metadata, capFinder)) {
            parentNode.recordDebugAnnotation("limit not supported by source", modelID, "limit node not pushed", analysisRecord, metadata);
            return null;
        }
        boolean multiSource = accessNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE);
        Expression offset = (Expression)parentNode.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT);
        if (multiSource || offset != null && !CapabilitiesUtil.supportsRowOffset(modelID, metadata, capFinder)) {
            if (limit != null) {
                if (!multiSource) {
                    parentNode.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, null);
                }
                PlanNode pushedLimit = RulePushLimit.newLimit(parentNode);
                pushedLimit.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, RulePushLimit.op("+", limit, offset, metadata.getFunctionLibrary()));
                if (accessNode.getChildCount() == 0) {
                    accessNode.addFirstChild(pushedLimit);
                } else {
                    accessNode.getFirstChild().addAsParent(pushedLimit);
                }
            }
            return null;
        }
        return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
    }

    static Expression op(String op, Expression expr1, Expression expr2, FunctionLibrary functionLibrary) {
        if (expr1 == null) {
            return expr2;
        }
        if (expr2 == null) {
            return expr1;
        }
        Function newExpr = new Function(op, new Expression[]{expr1, expr2});
        newExpr.setFunctionDescriptor(functionLibrary.findFunction(op, new Class[]{DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.INTEGER}));
        newExpr.setType(newExpr.getFunctionDescriptor().getReturnType());
        return RulePushLimit.evaluateIfPossible(newExpr);
    }

    private static Expression evaluateIfPossible(Expression newExpr) {
        if (EvaluatableVisitor.isFullyEvaluatable(newExpr, true)) {
            try {
                return new Constant(Evaluator.evaluate(newExpr), newExpr.getType());
            }
            catch (TeiidException e) {
                throw new TeiidRuntimeException(QueryPlugin.Event.TEIID30269, e, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30269, new Object[0]));
            }
        }
        return newExpr;
    }

    static Expression getMinValue(Expression expr1, Expression expr2) {
        if (expr1 == null) {
            return expr2;
        }
        if (expr2 == null) {
            return expr1;
        }
        CompareCriteria crit = new CompareCriteria(expr1, 3, expr2);
        SearchedCaseExpression sce = new SearchedCaseExpression(Arrays.asList(crit), Arrays.asList(expr1));
        sce.setElseExpression(expr2);
        sce.setType(expr1.getType());
        return RulePushLimit.evaluateIfPossible(sce);
    }

    public String toString() {
        return "PushLimit";
    }
}

