/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Alter;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.Command;

public class AlterResolver
implements CommandResolver {
    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Alter alter = (Alter)command;
        ResolverUtil.resolveGroup(alter.getTarget(), metadata);
        int type = 1;
        boolean viewTarget = true;
        if (alter instanceof AlterTrigger) {
            Table.TriggerEvent event = ((AlterTrigger)alter).getEvent();
            switch (event) {
                case DELETE: {
                    type = 4;
                    break;
                }
                case INSERT: {
                    type = 2;
                    break;
                }
                case UPDATE: {
                    type = 3;
                }
            }
        } else if (alter instanceof AlterProcedure) {
            type = 6;
            viewTarget = false;
        }
        if (viewTarget && !QueryResolver.isView(alter.getTarget(), metadata)) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30116, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30116, alter.getTarget()));
        }
        if (alter.getDefinition() != null) {
            QueryResolver.resolveCommand(alter.getDefinition(), alter.getTarget(), type, metadata.getDesignTimeMetadata(), false);
        }
    }
}

