/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public class TestBetweenCriteria
extends TestCase {
    public TestBetweenCriteria(String name) {
        super(name);
    }

    public static BetweenCriteria example(String element, int lower, int upper, boolean negated) {
        BetweenCriteria criteria = new BetweenCriteria((Expression)new ElementSymbol(element), (Expression)new Constant((Object)new Integer(lower)), (Expression)new Constant((Object)new Integer(upper)));
        criteria.setNegated(negated);
        return criteria;
    }

    public void testEquals1() {
        BetweenCriteria c1 = TestBetweenCriteria.example("x", 1, 20, false);
        BetweenCriteria c2 = TestBetweenCriteria.example("x", 1, 20, false);
        TestBetweenCriteria.assertTrue((String)("Equivalent between criteria don't compare as equal: " + c1 + ", " + c2), (boolean)c1.equals((Object)c2));
    }

    public void testEquals2() {
        BetweenCriteria c1 = TestBetweenCriteria.example("x", 1, 20, true);
        BetweenCriteria c2 = (BetweenCriteria)c1.clone();
        TestBetweenCriteria.assertTrue((String)("Equivalent between criteria don't compare as equal: " + c1 + ", " + c2), (boolean)c1.equals((Object)c2));
    }

    public void testEquals3() {
        BetweenCriteria c1 = TestBetweenCriteria.example("x", 1, 20, true);
        BetweenCriteria c2 = (BetweenCriteria)c1.clone();
        c2.setNegated(false);
        TestBetweenCriteria.assertFalse((String)("Criteria should not be equal: " + c1 + ", " + c2), (boolean)c1.equals((Object)c2));
    }

    public void testSelfEquivalence() {
        BetweenCriteria c1 = TestBetweenCriteria.example("x", 1, 20, false);
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c1);
    }

    public void testEquivalence() {
        BetweenCriteria c1 = TestBetweenCriteria.example("x", 1, 20, false);
        BetweenCriteria c2 = TestBetweenCriteria.example("x", 1, 20, false);
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }

    public void testCloneEquivalence() {
        BetweenCriteria c1 = TestBetweenCriteria.example("x", 1, 20, true);
        BetweenCriteria c2 = (BetweenCriteria)c1.clone();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }

    public void testNonEquivalence1() {
        BetweenCriteria c1 = TestBetweenCriteria.example("xyz", 1, 20, false);
        BetweenCriteria c2 = TestBetweenCriteria.example("abc", 1, 20, false);
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }

    public void testNonEquivalence2() {
        BetweenCriteria c1 = TestBetweenCriteria.example("x", 1, 20, true);
        BetweenCriteria c2 = TestBetweenCriteria.example("x", 1, 20, false);
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }
}

