/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.util.CommandContext;

public abstract class ProcessorPlan
implements Cloneable,
BatchCollector.BatchProducer {
    private CommandContext context;

    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.context = context;
    }

    public void addWarning(TeiidException warning) {
        if (this.context != null) {
            this.context.addWarning(warning);
        }
    }

    public void reset() {
    }

    @Override
    public abstract List getOutputElements();

    public CommandContext getContext() {
        return this.context;
    }

    public void setContext(CommandContext context) {
        this.context = context;
    }

    public abstract void open() throws TeiidComponentException, TeiidProcessingException;

    @Override
    public abstract TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException;

    @Override
    public abstract void close() throws TeiidComponentException;

    public abstract ProcessorPlan clone();

    public boolean requiresTransaction(boolean transactionalReads) {
        return transactionalReads;
    }

    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode(this.getClass().getSimpleName());
        props.addProperty("Output Columns", AnalysisRecord.getOutputColumnProperties(this.getOutputElements()));
        return props;
    }

    @Override
    public TupleBuffer getBuffer(int maxRows) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        return null;
    }

    @Override
    public boolean hasBuffer(boolean requireFinal) {
        return false;
    }
}

