/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import org.teiid.client.plan.PlanNode;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.proc.Program;
import org.teiid.query.processor.proc.ProgramInstruction;
import org.teiid.query.processor.proc.RepeatedInstruction;
import org.teiid.query.sql.proc.BranchingStatement;

public class BranchingInstruction
extends ProgramInstruction {
    private BranchingStatement bs;

    public BranchingInstruction(BranchingStatement bs) {
        this.bs = bs;
    }

    public String toString() {
        return this.bs.toString();
    }

    @Override
    public void process(ProcedurePlan env) throws TeiidComponentException {
        Program parentProgram = env.peek();
        while (true) {
            if (this.bs.getMode() == BranchingStatement.BranchingMode.LEAVE && this.bs.getLabel().equalsIgnoreCase(parentProgram.getLabel())) {
                env.pop(true);
                break;
            }
            if (parentProgram.getCurrentInstruction() instanceof RepeatedInstruction) {
                if (this.bs.getLabel() == null) break;
                RepeatedInstruction ri = (RepeatedInstruction)((Object)parentProgram.getCurrentInstruction());
                if (this.bs.getLabel().equalsIgnoreCase(ri.getLabel())) break;
            }
            env.pop(true);
            parentProgram = env.peek();
        }
        if (this.bs.getMode() != BranchingStatement.BranchingMode.CONTINUE) {
            env.incrementProgramCounter();
        }
    }

    @Override
    public PlanNode getDescriptionProperties() {
        return new PlanNode(this.bs.toString());
    }
}

