/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.StringUtil;

public class SourceHint {
    private boolean useAliases;
    private LinkedHashSet<String> generalHint;
    private Map<String, SpecificHint> sourceHints;

    public String getGeneralHint() {
        if (this.generalHint == null) {
            return null;
        }
        return StringUtil.join(this.generalHint, " ");
    }

    public void setGeneralHint(String generalHint) {
        if (this.generalHint == null) {
            this.generalHint = new LinkedHashSet();
        }
        this.generalHint.add(generalHint);
    }

    public void setSourceHint(String sourceName, String hint, boolean useAliases) {
        SpecificHint sh;
        if (this.sourceHints == null) {
            this.sourceHints = new TreeMap<String, SpecificHint>(String.CASE_INSENSITIVE_ORDER);
        }
        if ((sh = this.sourceHints.get(sourceName)) == null) {
            this.sourceHints.put(sourceName, new SpecificHint(hint, useAliases));
        } else {
            sh.useAliases |= useAliases;
            sh.hints.add(hint);
        }
    }

    public SpecificHint getSpecificHint(String sourceName) {
        if (this.sourceHints == null) {
            return null;
        }
        return this.sourceHints.get(sourceName);
    }

    public String getSourceHint(String sourceName) {
        SpecificHint sp = this.getSpecificHint(sourceName);
        if (sp != null) {
            return sp.getHint();
        }
        return null;
    }

    public Map<String, SpecificHint> getSpecificHints() {
        return this.sourceHints;
    }

    public boolean isUseAliases() {
        return this.useAliases;
    }

    public void setUseAliases(boolean useAliases) {
        this.useAliases |= useAliases;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SourceHint)) {
            return false;
        }
        SourceHint other = (SourceHint)obj;
        return EquivalenceUtil.areEqual(this.generalHint, other.generalHint) && EquivalenceUtil.areEqual(this.sourceHints, other.sourceHints);
    }

    public static SourceHint combine(SourceHint sourceHint, SourceHint sourceHint2) {
        if (sourceHint == null) {
            if (sourceHint2 == null) {
                return null;
            }
            return sourceHint2;
        }
        if (sourceHint2 == null) {
            return sourceHint;
        }
        SourceHint newHint = new SourceHint();
        SourceHint.addHints(sourceHint, newHint);
        SourceHint.addHints(sourceHint2, newHint);
        return newHint;
    }

    private static void addHints(SourceHint sourceHint, SourceHint newHint) {
        if (sourceHint.sourceHints != null) {
            for (Map.Entry<String, SpecificHint> entry : sourceHint.sourceHints.entrySet()) {
                for (String hint : entry.getValue().hints) {
                    newHint.setSourceHint(entry.getKey(), hint, entry.getValue().useAliases);
                }
            }
        }
        newHint.setUseAliases(sourceHint.isUseAliases());
        if (sourceHint.generalHint != null) {
            if (newHint.generalHint == null) {
                newHint.generalHint = new LinkedHashSet();
            }
            newHint.generalHint.addAll(sourceHint.generalHint);
        }
    }

    public Collection<String> getGeneralHints() {
        return this.generalHint;
    }

    public static class SpecificHint {
        LinkedHashSet<String> hints = new LinkedHashSet();
        boolean useAliases;

        public SpecificHint(String hint, boolean useAliases) {
            this.hints.add(hint);
            this.useAliases = useAliases;
        }

        public String getHint() {
            return StringUtil.join(this.hints, " ");
        }

        public boolean isUseAliases() {
            return this.useAliases;
        }

        public Collection<String> getHints() {
            return this.hints;
        }
    }
}

