/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.aggregate;

import java.math.BigDecimal;
import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.function.aggregate.Sum;
import org.teiid.query.util.CommandContext;

public class Avg
extends Sum {
    private int count = 0;

    @Override
    public void initialize(Class<?> dataType, Class<?> inputType) {
        this.accumulatorType = dataType.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL) ? 3 : 1;
    }

    @Override
    public void reset() {
        super.reset();
        this.count = 0;
    }

    @Override
    public void addInputDirect(Object input, List<?> tuple, CommandContext commandContext) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException {
        super.addInputDirect(input, tuple, commandContext);
        ++this.count;
    }

    @Override
    public Object getResult(CommandContext commandContext) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException {
        Object sum = super.getResult(commandContext);
        if (this.count == 0 || sum == null) {
            return null;
        }
        switch (this.getAccumulatorType()) {
            case 1: {
                return new Double((Double)sum / (double)this.count);
            }
            case 3: {
                try {
                    return FunctionMethods.divide((BigDecimal)sum, new BigDecimal(this.count));
                }
                catch (ArithmeticException e) {
                    throw new FunctionExecutionException(QueryPlugin.Event.TEIID30424, e, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30424, sum, this.count));
                }
            }
        }
        throw new AssertionError((Object)"unknown accumulator type");
    }
}

