/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.sql.Clob;
import java.util.Arrays;
import java.util.List;
import javax.sql.rowset.serial.SerialClob;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.sql.symbol.ElementSymbol;

public class TestTupleBuffer {
    @Test
    public void testForwardOnly() throws Exception {
        ElementSymbol x = new ElementSymbol("x");
        x.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        List<ElementSymbol> schema = Arrays.asList(x);
        TupleBuffer tb = BufferManagerFactory.getStandaloneBufferManager().createTupleBuffer(schema, "x", BufferManager.TupleSourceType.PROCESSOR);
        tb.setForwardOnly(true);
        tb.addTuple(Arrays.asList(1));
        TupleBatch batch = tb.getBatch(1);
        Assert.assertTrue((!batch.getTerminationFlag() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)batch.getBeginRow());
        try {
            tb.getBatch(1);
            Assert.fail((String)"expected exception");
        }
        catch (AssertionError e) {
            // empty catch block
        }
        tb.addTuple(Arrays.asList(1));
        tb.close();
        batch = tb.getBatch(2);
        Assert.assertTrue((boolean)batch.getTerminationFlag());
        Assert.assertEquals((long)2L, (long)batch.getBeginRow());
    }

    @Test
    public void testReverseIteration() throws Exception {
        ElementSymbol x = new ElementSymbol("x");
        x.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        List<ElementSymbol> schema = Arrays.asList(x);
        TupleBuffer tb = BufferManagerFactory.getStandaloneBufferManager().createTupleBuffer(schema, "x", BufferManager.TupleSourceType.PROCESSOR);
        tb.addTuple(Arrays.asList(1));
        tb.addTuple(Arrays.asList(2));
        TupleBuffer.TupleBufferTupleSource tbts = tb.createIndexedTupleSource();
        tbts.setReverse(true);
        Assert.assertTrue((boolean)tbts.hasNext());
        Assert.assertEquals((Object)2, tbts.nextTuple().get(0));
        Assert.assertEquals((Object)1, tbts.nextTuple().get(0));
        Assert.assertFalse((boolean)tbts.hasNext());
    }

    @Test
    public void testTruncate() throws Exception {
        ElementSymbol x = new ElementSymbol("x");
        x.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        List<ElementSymbol> schema = Arrays.asList(x);
        TupleBuffer tb = BufferManagerFactory.getStandaloneBufferManager().createTupleBuffer(schema, "x", BufferManager.TupleSourceType.PROCESSOR);
        tb.setBatchSize(2);
        for (int i = 0; i < 5; ++i) {
            tb.addTuple(Arrays.asList(1));
        }
        TupleBatch batch = tb.getBatch(1);
        Assert.assertTrue((!batch.getTerminationFlag() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)batch.getEndRow());
        tb.close();
        Assert.assertEquals((long)5L, (long)tb.getManagedRowCount());
        tb.truncateTo(3);
        Assert.assertEquals((long)3L, (long)tb.getManagedRowCount());
        Assert.assertEquals((long)3L, (long)tb.getRowCount());
        batch = tb.getBatch(3);
        Assert.assertTrue((boolean)batch.getTerminationFlag());
        tb.truncateTo(2);
        Assert.assertEquals((long)2L, (long)tb.getManagedRowCount());
        Assert.assertEquals((long)2L, (long)tb.getRowCount());
        batch = tb.getBatch(2);
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testLobHandling() throws Exception {
        ElementSymbol x = new ElementSymbol("x");
        x.setType(DataTypeManager.DefaultDataClasses.CLOB);
        List<ElementSymbol> schema = Arrays.asList(x);
        TupleBuffer tb = BufferManagerFactory.getStandaloneBufferManager().createTupleBuffer(schema, "x", BufferManager.TupleSourceType.PROCESSOR);
        tb.setInlineLobs(false);
        ClobType c = new ClobType((Clob)new SerialClob(new char[0]));
        TupleBatch batch = new TupleBatch(1, new List[]{Arrays.asList(c)});
        tb.addTupleBatch(batch, false);
        Assert.assertNotNull((Object)tb.getLobReference(c.getReferenceStreamId()));
    }
}

