/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process.multisource;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.id.IDGenerator;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.dqp.internal.process.multisource.MultiSourceMetadataWrapper;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempCapabilitiesFinder;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;
import org.teiid.query.util.Options;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorReport;

public class TestMultiSourcePlanToProcessConverter {
    private static final boolean DEBUG = false;

    public ProcessorPlan helpTestMultiSourcePlan(QueryMetadataInterface metadata, String userSql, String multiModel, int sourceCount, ProcessorDataManager dataMgr, List<?>[] expectedResults, VDBMetaData vdb) throws Exception {
        return this.helpTestMultiSourcePlan(metadata, userSql, multiModel, sourceCount, dataMgr, expectedResults, vdb, null, null);
    }

    public ProcessorPlan helpTestMultiSourcePlan(QueryMetadataInterface metadata, String userSql, String multiModel, int sourceCount, ProcessorDataManager dataMgr, List<?>[] expectedResults, VDBMetaData vdb, List<?> params, Options options) throws Exception {
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, true);
        bsc.setFunctionSupport("concat", true);
        return this.helpTestMultiSourcePlan(metadata, userSql, multiModel, sourceCount, dataMgr, expectedResults, vdb, params, options, (SourceCapabilities)bsc);
    }

    public ProcessorPlan helpTestMultiSourcePlan(QueryMetadataInterface metadata, String userSql, String multiModel, int sourceCount, ProcessorDataManager dataMgr, List<?>[] expectedResults, VDBMetaData vdb, List<?> params, Options options, SourceCapabilities bsc) throws Exception {
        Map multiSourceModels = MultiSourceMetadataWrapper.getMultiSourceModels((VDBMetaData)vdb);
        for (String model : multiSourceModels.keySet()) {
            int x;
            char sourceID = 'a';
            ModelMetaData m = vdb.getModel(model);
            int i = x = m.getSourceNames().size();
            while (i < sourceCount) {
                m.addSourceMapping("" + sourceID, "translator", null);
                ++i;
                sourceID = (char)(sourceID + '\u0001');
            }
        }
        MultiSourceMetadataWrapper wrapper = new MultiSourceMetadataWrapper(metadata, multiSourceModels);
        wrapper = new TempMetadataAdapter((QueryMetadataInterface)wrapper, new TempMetadataStore());
        DQPWorkContext workContext = RealMetadataFactory.buildWorkContext((QueryMetadataInterface)wrapper, vdb);
        AnalysisRecord analysis = new AnalysisRecord(false, false);
        Command command = TestResolver.helpResolve(userSql, (QueryMetadataInterface)wrapper);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        if (report.hasItems()) {
            Assert.fail((String)report.toString());
        }
        command = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)wrapper, null);
        FakeCapabilitiesFinder fakeFinder = new FakeCapabilitiesFinder();
        fakeFinder.addCapabilities(multiModel, bsc);
        TempCapabilitiesFinder finder = new TempCapabilitiesFinder((CapabilitiesFinder)fakeFinder);
        IDGenerator idGenerator = new IDGenerator();
        CommandContext context = new CommandContext("test", "user", null, vdb.getName(), vdb.getVersion(), false);
        context.setDQPWorkContext(workContext);
        context.setOptions(options);
        ProcessorPlan plan = QueryOptimizer.optimizePlan((Command)command, (QueryMetadataInterface)wrapper, (IDGenerator)idGenerator, (CapabilitiesFinder)finder, (AnalysisRecord)analysis, (CommandContext)context);
        if (params != null) {
            TestProcessor.setParameterValues(params, command, context);
        }
        TestProcessor.helpProcess(plan, context, dataMgr, expectedResults);
        return plan;
    }

    @Test
    public void testNoReplacement() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT * FROM MultiModel.Phys WHERE SOURCE_NAME = 'bogus'";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT * FROM MultiModel.Phys WHERE SOURCE_NAME = 'bogus'", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testSingleReplacement() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT * FROM MultiModel.Phys WHERE SOURCE_NAME = 'a'";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList(null, null)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(false);
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT * FROM MultiModel.Phys WHERE SOURCE_NAME = 'a'", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testSingleReplacementAltName() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT * FROM MultiModel.Phys WHERE foo = 'a'";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList(null, null)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(false);
        VDBMetaData vdb = RealMetadataFactory.exampleMultiBindingVDB();
        vdb.getModel("MultiModel").addProperty("multisource.columnName", "foo");
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT * FROM MultiModel.Phys WHERE foo = 'a'", "MultiModel", 2, dataMgr, expected, vdb);
    }

    @Test
    public void testPreparedReplacement() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT * FROM MultiModel.Phys WHERE SOURCE_NAME = ?";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList(null, null)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(false);
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT * FROM MultiModel.Phys WHERE SOURCE_NAME = ?", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB(), Arrays.asList("a"), null);
    }

    @Test
    public void testMultiReplacement() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT * FROM MultiModel.Phys";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT * FROM MultiModel.Phys", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testMultiReplacementWithOrderBy() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT a, b, source_name || a FROM MultiModel.Phys order by a";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("e", "z", "be"), Arrays.asList("f", "z", "bf"), Arrays.asList("x", "z", "ax"), Arrays.asList("y", "z", "ay")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT g_0.a, g_0.b, concat('a', g_0.a) FROM MultiModel.Phys AS g_0", Arrays.asList("y", "z", "ay"), Arrays.asList("x", "z", "ax"));
        dataMgr.addData("SELECT g_0.a, g_0.b, concat('b', g_0.a) FROM MultiModel.Phys AS g_0", Arrays.asList("e", "z", "be"), Arrays.asList("f", "z", "bf"));
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT a, b, source_name || a FROM MultiModel.Phys order by a", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testMultiJoinImplicit() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT phys.a FROM MultiModel.Phys, MultiModel.phys1 where phys.a = phys1.b";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT g_0.a FROM MultiModel.Phys AS g_0, MultiModel.Phys1 AS g_1 WHERE g_0.a = g_1.b", Arrays.asList("a"));
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT phys.a FROM MultiModel.Phys, MultiModel.phys1 where phys.a = phys1.b", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testMultiJoinNotImplicit() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT phys.a FROM MultiModel.Phys, MultiModel.phys1 where phys.a = phys1.b";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT g_0.a FROM MultiModel.Phys AS g_0", Arrays.asList("a"));
        dataMgr.addData("SELECT g_0.b FROM MultiModel.Phys1 AS g_0", Arrays.asList("a"));
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT phys.a FROM MultiModel.Phys, MultiModel.phys1 where phys.a = phys1.b", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB(), null, new Options().implicitMultiSourceJoin(false));
    }

    @Test
    public void testMultiJoinPartitionedExplicit() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT phys.a FROM MultiModel.Phys, MultiModel.phys1 where phys.a = phys1.b and Phys.source_name = phys1.source_name";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT g_0.a FROM MultiModel.Phys AS g_0, MultiModel.Phys1 AS g_1 WHERE g_0.a = g_1.b", Arrays.asList("a"));
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT phys.a FROM MultiModel.Phys, MultiModel.phys1 where phys.a = phys1.b and Phys.source_name = phys1.source_name", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB(), null, new Options().implicitMultiSourceJoin(false));
    }

    @Test
    public void testAggParitioned() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT max(phys.a), source_name FROM MultiModel.Phys group by Phys.source_name";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("y", "a"), Arrays.asList("y", "b")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT MAX(g_0.a) FROM MultiModel.Phys AS g_0 HAVING MAX(g_0.a) IS NOT NULL", Arrays.asList("y"));
        ProcessorPlan plan = this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT max(phys.a), source_name FROM MultiModel.Phys group by Phys.source_name", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
        TestOptimizer.checkNodeTypes(plan, new int[]{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testAggNotParitioned() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT max(phys.a) FROM MultiModel.Phys";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("y")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT MAX(g_0.a) FROM MultiModel.Phys AS g_0 HAVING MAX(g_0.a) IS NOT NULL", Arrays.asList("y"));
        ProcessorPlan plan = this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT max(phys.a) FROM MultiModel.Phys", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
        TestOptimizer.checkNodeTypes(plan, new int[]{3, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1});
    }

    @Test
    public void testMultiReplacementWithLimit() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT distinct a, b, source_name || a FROM MultiModel.Phys order by a limit 1";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("e", "z", "be")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT g_0.a, g_0.b, concat('a', g_0.a) FROM MultiModel.Phys AS g_0", Arrays.asList("y", "z", "ay"), Arrays.asList("x", "z", "ax"));
        dataMgr.addData("SELECT g_0.a, g_0.b, concat('b', g_0.a) FROM MultiModel.Phys AS g_0", Arrays.asList("e", "z", "be"), Arrays.asList("f", "z", "bf"));
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT distinct a, b, source_name || a FROM MultiModel.Phys order by a limit 1", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testMultiReplacementWithLimit1() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT a, b FROM MultiModel.Phys limit 1, 1";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("x", "z")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT g_0.a AS c_0, g_0.b AS c_1 FROM MultiModel.Phys AS g_0 LIMIT 2", Arrays.asList("y", "z"), Arrays.asList("x", "z"));
        RelationalPlan plan = (RelationalPlan)this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT a, b FROM MultiModel.Phys limit 1, 1", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
        Assert.assertTrue((boolean)(plan.getRootNode() instanceof LimitNode));
    }

    @Test
    public void testMultiReplacementWithProjectConstant() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT a, b, source_name || a, '1' FROM MultiModel.Phys";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("x", "z", "ax", "1")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT g_0.a, g_0.b, concat('a', g_0.a) FROM MultiModel.Phys AS g_0", Arrays.asList("x", "z", "ax"));
        dataMgr.addData("SELECT g_0.a, g_0.b, concat('b', g_0.a) FROM MultiModel.Phys AS g_0", new List[0]);
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT a, b, source_name || a, '1' FROM MultiModel.Phys", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testMultiDependentJoin() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT a.a FROM MultiModel.Phys a inner join MultiModel.Phys b makedep on (a.a = b.a) order by a";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("x"), Arrays.asList("x"), Arrays.asList("x"), Arrays.asList("x"), Arrays.asList("y"), Arrays.asList("y"), Arrays.asList("y"), Arrays.asList("y")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT g_0.a FROM MultiModel.Phys AS g_0", Arrays.asList("x"), Arrays.asList("y"));
        dataMgr.addData("SELECT g_0.a FROM MultiModel.Phys AS g_0 WHERE g_0.a IN ('x', 'y')", Arrays.asList("x"), Arrays.asList("y"));
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT a.a FROM MultiModel.Phys a inner join MultiModel.Phys b makedep on (a.a = b.a) order by a", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testSingleReplacementInDynamicCommand() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "exec Virt.sq1('a')";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(null, null)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "exec Virt.sq1('a')", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testSingleReplacementInDynamicCommandNullValue() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "exec Virt.sq1(null)";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "exec Virt.sq1(null)", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testMultiUpdateAll() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "update MultiModel.Phys set a = '1' where b = 'z'";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(3)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(true);
        dataMgr.addData("UPDATE MultiModel.Phys SET a = '1' WHERE b = 'z'", Arrays.asList(1));
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "update MultiModel.Phys set a = '1' where b = 'z'", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testInsertMatching() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "INSERT INTO MultiModel.Phys(a, SOURCE_NAME) VALUES ('a', 'a')";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(1)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(true);
        dataMgr.addData("INSERT INTO MultiModel.Phys (a) VALUES ('a')", Arrays.asList(1));
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "INSERT INTO MultiModel.Phys(a, SOURCE_NAME) VALUES ('a', 'a')", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testInsertNotMatching() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "INSERT INTO MultiModel.Phys(a, SOURCE_NAME) VALUES ('a', 'x')";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(0)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(true);
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "INSERT INTO MultiModel.Phys(a, SOURCE_NAME) VALUES ('a', 'x')", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testProcedure() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "exec MultiModel.proc('b', 'a')";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(1)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(true);
        dataMgr.addData("EXEC MultiModel.proc('b')", Arrays.asList(1));
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "exec MultiModel.proc('b', 'a')", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testProcedureAll() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "exec MultiModel.proc(\"in\"=>'b')";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(1), Arrays.asList(1), Arrays.asList(1)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(true);
        dataMgr.addData("EXEC MultiModel.proc('b')", Arrays.asList(1));
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "exec MultiModel.proc(\"in\"=>'b')", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testTempInsert() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "INSERT INTO #x select * from MultiModel.Phys";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(3)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(true);
        dataMgr.addData("SELECT g_0.a, g_0.b FROM MultiModel.Phys AS g_0", Arrays.asList("a", "b"));
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "INSERT INTO #x select * from MultiModel.Phys", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testUnsupportedPredicate() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT phys.a FROM MultiModel.Phys where Phys.source_name like 'a%'";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("a")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT MultiModel.Phys.a FROM MultiModel.Phys", Arrays.asList("a"));
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT phys.a FROM MultiModel.Phys where Phys.source_name like 'a%'", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB(), null, new Options().implicitMultiSourceJoin(false), (SourceCapabilities)new BasicSourceCapabilities());
        Assert.assertEquals((long)3L, (long)dataMgr.getCommandHistory().size());
    }

    private final class MultiSourceDataManager
    extends HardcodedDataManager {
        public MultiSourceDataManager() {
            this.setMustRegisterCommands(false);
        }

        @Override
        public TupleSource registerRequest(CommandContext context, Command command, String modelName, RegisterRequestParameter parameterObject) throws TeiidComponentException {
            Assert.assertNotNull((Object)parameterObject.connectorBindingId);
            Collection elements = ElementCollectorVisitor.getElements((LanguageObject)command, (boolean)true, (boolean)true);
            for (ElementSymbol symbol : elements) {
                if (!(symbol.getMetadataID() instanceof MultiSourceElement)) continue;
                Assert.fail((String)"Query Contains a MultiSourceElement -- MultiSource expansion did not happen");
            }
            return super.registerRequest(context, command, modelName, parameterObject);
        }
    }
}

