/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.service.FakeBufferService;
import org.teiid.metadata.Table;
import org.teiid.query.processor.FakeProcessorPlan;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestCachedResults {
    @Test
    public void testCaching() throws Exception {
        FakeBufferService fbs = new FakeBufferService(true);
        ElementSymbol x = new ElementSymbol("x");
        x.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        List<ElementSymbol> schema = Arrays.asList(x);
        TupleBuffer tb = BufferManagerFactory.getStandaloneBufferManager().createTupleBuffer(schema, "x", BufferManager.TupleSourceType.PROCESSOR);
        tb.setForwardOnly(false);
        tb.addTuple(Arrays.asList(1));
        tb.addTuple(Arrays.asList(2));
        tb.addTuple(Arrays.asList(3));
        tb.addTuple(Arrays.asList(4));
        tb.addTuple(Arrays.asList(5));
        tb.addTuple(Arrays.asList(6));
        tb.addTuple(Arrays.asList(7));
        tb.addTuple(Arrays.asList(8));
        tb.addTuple(Arrays.asList(9));
        tb.addTuple(Arrays.asList(10));
        tb.close();
        BufferManager bm = fbs.getBufferManager();
        CachedResults results = new CachedResults();
        FakeProcessorPlan plan = new FakeProcessorPlan(0);
        CommandContext cc = new CommandContext();
        Table t = RealMetadataFactory.exampleBQT().getGroupID("bqt1.smalla");
        cc.accessedDataObject((Object)t);
        plan.setContext(cc);
        results.setResults(tb, (ProcessorPlan)plan);
        results.setCommand((Command)new Query());
        long ts = results.getAccessInfo().getCreationTime();
        for (int row = 1; row <= tb.getRowCount(); row += 4) {
        }
        results.prepare((TupleBufferCache)bm);
        TupleBuffer distributedTb = bm.getTupleBuffer(results.getId());
        CachedResults cachedResults = (CachedResults)UnitTestUtil.helpSerialize((Serializable)results);
        RealMetadataFactory.buildWorkContext(RealMetadataFactory.exampleBQT());
        BufferManager bm2 = fbs.getBufferManager();
        bm2.distributeTupleBuffer(results.getId(), distributedTb);
        Assert.assertTrue((boolean)cachedResults.restore((TupleBufferCache)bm2));
        TupleBuffer cachedTb = cachedResults.getResults();
        Assert.assertTrue((boolean)cachedTb.isFinal());
        Assert.assertEquals((long)tb.getRowCount(), (long)cachedTb.getRowCount());
        Assert.assertEquals((long)tb.getBatchSize(), (long)cachedTb.getBatchSize());
        Assert.assertArrayEquals((Object[])tb.getBatch(1).getAllTuples(), (Object[])cachedTb.getBatch(1).getAllTuples());
        Assert.assertArrayEquals((Object[])tb.getBatch(9).getAllTuples(), (Object[])cachedTb.getBatch(9).getAllTuples());
        Assert.assertTrue((ts - cachedResults.getAccessInfo().getCreationTime() <= 5000L ? 1 : 0) != 0);
    }
}

