/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client;

import java.util.ArrayList;
import java.util.Collection;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.test.client.ExpectedResults;
import org.teiid.test.client.QueryReader;
import org.teiid.test.client.QueryScenario;
import org.teiid.test.client.ResultsGenerator;
import org.teiid.test.framework.ConfigPropertyLoader;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class ClassFactory {
    public static final String QUERY_SCENARIO_CLASSNAME = "query.scenario.classname";
    public static final String QUERY_SCENARIO_DEFAULT_CLASSNAME = "org.teiid.test.client.impl.QueryScenarioImpl";
    public static final String QUERY_READER_CLASSNAME = "query.reader.classname";
    public static final String QUERY_READER_DEFAULT_CLASSNAME = "org.teiid.test.client.ctc.XMLQueryReader";
    public static final String RESULTS_GENERATOR_CLASSNAME = "results.generator.classname";
    public static final String RESULTS_GENERATOR_DEFAULT_CLASSNAME = "org.teiid.test.client.impl.ResultsGeneratorImpl";
    public static final String EXPECTED_RESULTS_CLASSNAME = "expected.results.classname";
    public static final String EXPECTED_RESULTS_DEFAULT_CLASSNAME = "org.teiid.test.client.impl.ExpectedResultsImpl";

    public static QueryScenario createQueryScenario(String scenarioName) {
        QueryScenario scenario;
        String clzzname = ConfigPropertyLoader.getInstance().getProperty(QUERY_SCENARIO_CLASSNAME);
        if (clzzname == null || clzzname.startsWith("${")) {
            clzzname = QUERY_SCENARIO_DEFAULT_CLASSNAME;
        }
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(scenarioName);
        args.add(ConfigPropertyLoader.getInstance().getProperties());
        try {
            scenario = (QueryScenario)ReflectionHelper.create((String)clzzname, args, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransactionRuntimeException(e);
        }
        return scenario;
    }

    public static QueryReader createQueryReader(Collection<?> args) {
        QueryReader reader;
        String clzzname = ConfigPropertyLoader.getInstance().getProperty(QUERY_READER_CLASSNAME);
        if (clzzname == null) {
            clzzname = QUERY_READER_DEFAULT_CLASSNAME;
        }
        try {
            reader = (QueryReader)ReflectionHelper.create((String)clzzname, args, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransactionRuntimeException(e);
        }
        return reader;
    }

    public static ResultsGenerator createResultsGenerator(Collection<?> args) {
        ResultsGenerator resultsgen;
        String clzzname = ConfigPropertyLoader.getInstance().getProperty(RESULTS_GENERATOR_CLASSNAME);
        if (clzzname == null) {
            clzzname = RESULTS_GENERATOR_DEFAULT_CLASSNAME;
        }
        try {
            resultsgen = (ResultsGenerator)ReflectionHelper.create((String)clzzname, args, null);
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e.getMessage());
        }
        return resultsgen;
    }

    public static ExpectedResults createExpectedResults(Collection<?> args) {
        ExpectedResults expResults;
        String clzzname = ConfigPropertyLoader.getInstance().getProperty(EXPECTED_RESULTS_CLASSNAME);
        if (clzzname == null) {
            clzzname = EXPECTED_RESULTS_DEFAULT_CLASSNAME;
        }
        try {
            expResults = (ExpectedResults)ReflectionHelper.create((String)clzzname, args, null);
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e.getMessage());
        }
        return expResults;
    }
}

