/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.Namespace;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.xml.CriteriaPlanner;
import org.teiid.query.optimizer.xml.XMLPlanner;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.xml.BlockInstruction;
import org.teiid.query.processor.xml.EndBlockInstruction;
import org.teiid.query.processor.xml.ExecSqlInstruction;
import org.teiid.query.processor.xml.ExecStagingTableInstruction;
import org.teiid.query.processor.xml.MoveCursorInstruction;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.TestXMLProcessor;
import org.teiid.query.processor.xml.WhileInstruction;
import org.teiid.query.processor.xml.XMLPlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestXMLPlanner {
    private static final boolean DEBUG = false;

    public static XMLPlan helpPlan(String sql, QueryMetadataInterface md) throws Exception {
        Command command = TestXMLProcessor.helpGetCommand(sql, md);
        return TestXMLPlanner.preparePlan(command, md, TestOptimizer.getGenericFinder(), null);
    }

    private void helpPlanException(String sql, QueryMetadataInterface md) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        Command command = TestXMLProcessor.helpGetCommand(sql, md);
        try {
            TestXMLPlanner.preparePlan(command, md, TestOptimizer.getGenericFinder(), null);
            Assert.fail((String)("Expected exception for planning " + sql));
        }
        catch (QueryPlannerException e) {
            // empty catch block
        }
    }

    public static TransformationMetadata example1() {
        MetadataStore metadataStore = new MetadataStore();
        Schema pm1 = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        Schema vm1 = RealMetadataFactory.createVirtualModel("vm1", metadataStore);
        Table pm1g1 = RealMetadataFactory.createPhysicalGroup("g1", pm1);
        Table pm1g2 = RealMetadataFactory.createPhysicalGroup("g2", pm1);
        Table pm1g3 = RealMetadataFactory.createPhysicalGroup("g3", pm1);
        Table pm1g4 = RealMetadataFactory.createPhysicalGroup("g4", pm1);
        Table pm1g5 = RealMetadataFactory.createPhysicalGroup("g5", pm1);
        RealMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g4, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g5, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        QueryNode vm1g1n1 = new QueryNode("SELECT * FROM tm1.g1");
        Table vm1g1 = RealMetadataFactory.createVirtualGroup("g1", vm1, vm1g1n1);
        QueryNode vm1g2n1 = new QueryNode("SELECT * FROM pm1.g2 where pm1.g2.e1=?");
        vm1g2n1.addBinding("vm1.g1.e1");
        Table vm1g2 = RealMetadataFactory.createVirtualGroup("g2", vm1, vm1g2n1);
        QueryNode vm1g3n1 = new QueryNode("SELECT * FROM pm1.g3 where pm1.g3.e1=?");
        vm1g3n1.addBinding("vm1.g2.e1");
        Table vm1g3 = RealMetadataFactory.createVirtualGroup("g3", vm1, vm1g3n1);
        QueryNode vm1g4n1 = new QueryNode("SELECT * FROM pm1.g4");
        Table vm1g4 = RealMetadataFactory.createVirtualGroup("g4", vm1, vm1g4n1);
        QueryNode vm1g5n1 = new QueryNode("SELECT * FROM pm1.g5 where pm1.g5.e1=? AND pm1.g5.e2=?");
        vm1g5n1.addBinding("vm1.g4.e1");
        vm1g5n1.addBinding("vm1.g1.e1");
        Table vm1g5 = RealMetadataFactory.createVirtualGroup("g5", vm1, vm1g5n1);
        QueryNode tempGroup1 = new QueryNode("SELECT * FROM pm1.g1 where e2 < '5'");
        Table tm1g1 = RealMetadataFactory.createVirtualGroup("tm1.g1", vm1, tempGroup1);
        RealMetadataFactory.createElements(vm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g4, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g5, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(tm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createXmlDocument("doc1", vm1, TestXMLPlanner.doc1());
        RealMetadataFactory.createXmlDocument("doc2", vm1, TestXMLPlanner.doc2());
        RealMetadataFactory.createXmlDocument("doc3", vm1, TestXMLPlanner.doc3());
        RealMetadataFactory.createXmlDocument("doc4", vm1, TestXMLPlanner.doc4());
        RealMetadataFactory.createXmlDocument("doc5", vm1, TestXMLPlanner.doc5());
        RealMetadataFactory.createXmlDocument("doc6", vm1, TestXMLPlanner.doc6());
        RealMetadataFactory.createXmlDocument("vm1.docWithExcluded", vm1, TestXMLPlanner.docWithExcluded());
        RealMetadataFactory.createXmlDocument("vm1.docWithExcluded2", vm1, TestXMLPlanner.docWithExcluded2());
        RealMetadataFactory.createXmlDocument("vm1.docWithAttribute", vm1, TestXMLPlanner.docTestConvertCriteriaWithAttribute());
        RealMetadataFactory.createXmlDocument("vm1.docWithAttribute3", vm1, TestXMLPlanner.docTestCriteriaWithAttribute());
        RealMetadataFactory.createXmlDocument("vm1.docWithAttribute2", vm1, TestXMLPlanner.docTestConvertCriteriaWithAttribute2());
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "example1", new FunctionTree[0]);
    }

    private static MappingDocument doc1() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement node = doc.addChildElement(new MappingElement("a0"));
        MappingElement sourceNode = node.addChildElement(new MappingElement("a1"));
        sourceNode.setSource("vm1.g1");
        sourceNode.addStagingTable("tm1.g1");
        sourceNode.addChildElement(new MappingElement("a1", "vm1.g1.e1"));
        sourceNode.addChildElement(new MappingElement("b1", "vm1.g1.e2"));
        sourceNode.addChildElement(new MappingElement("c1", "vm1.g1.e3"));
        return doc;
    }

    private static MappingDocument doc2() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement A1 = doc.addChildElement(new MappingElement("a1", "vm1.g1.e1"));
        A1.setSource("vm1.g1");
        return doc;
    }

    private static MappingDocument docTestConvertCriteriaWithAttribute() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        root.setSource("vm1.g1");
        root.addChildElement(new MappingElement("myElement", "vm1.g1.e2"));
        root.addAttribute(new MappingAttribute("myAttribute", "vm1.g1.e1"));
        return doc;
    }

    private static MappingDocument docTestConvertCriteriaWithAttribute2() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        root.setSource("vm1.g1");
        root.addAttribute(new MappingAttribute("myAttribute", "vm1.g1.e1"));
        MappingSequenceNode seq = root.addSequenceNode(new MappingSequenceNode());
        seq.addChildElement(new MappingElement("myElement", "vm1.g1.e2"));
        return doc;
    }

    private static MappingDocument doc3() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement n1 = root.addChildElement(new MappingElement("n1"));
        n1.setSource("vm1.g1");
        MappingElement m1 = n1.addChildElement(new MappingElement("m1"));
        MappingElement n2 = m1.addChildElement(new MappingElement("n2"));
        n2.setSource("vm1.g2");
        n2.addStagingTable("tm1.g1");
        n2.addChildElement(new MappingElement("leaf1", "vm1.g1.e1"));
        return doc;
    }

    private static MappingDocument doc4() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement n4a = root.addChildElement(new MappingElement("n4a"));
        n4a.setMaxOccurrs(-1);
        n4a.setSource("vm1.g1");
        n4a.addStagingTable("tm1.g1");
        n4a.addChildElement(new MappingElement("n4b", "vm1.g1.e1"));
        MappingElement n4c = n4a.addChildElement(new MappingElement("n4c"));
        n4c.setMaxOccurrs(-1);
        n4c.setSource("vm1.g2");
        MappingElement fake = n4a.addChildElement(new MappingElement("fake"));
        fake.setSource("fakeResultSet");
        n4c.addChildElement(new MappingElement("n4d", "vm1.g2.e1"));
        MappingElement n4e = n4c.addChildElement(new MappingElement("n4e"));
        n4e.setSource("vm1.g3");
        n4e.setMaxOccurrs(-1);
        n4e.addChildElement(new MappingElement("n4f", "vm1.g3.e1"));
        return doc;
    }

    private static MappingDocument doc5() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement nodea = root.addChildElement(new MappingElement("nodea"));
        nodea.setSource("vm1.g1");
        nodea.addStagingTable("tm1.g1");
        nodea.setMaxOccurrs(-1);
        nodea.addChildElement(new MappingElement("nodeb", "vm1.g1.e1"));
        MappingElement nodec = nodea.addChildElement(new MappingElement("nodec"));
        nodec.setMaxOccurrs(-1);
        nodec.setSource("vm1.g2");
        nodec.addChildElement(new MappingElement("noded", "vm1.g2.e1"));
        MappingElement nodee = nodec.addChildElement(new MappingElement("nodee"));
        nodee.setSource("vm1.g3");
        nodee.setMaxOccurrs(-1);
        nodee.addChildElement(new MappingElement("nodef", "vm1.g3.e1"));
        MappingElement nodeg = nodee.addChildElement(new MappingElement("nodeg"));
        nodeg.setSource("vm1.g4");
        nodeg.setMaxOccurrs(-1);
        nodeg.addChildElement(new MappingElement("nodeh", "vm1.g4.e1"));
        MappingElement nodeI = nodeg.addChildElement(new MappingElement("nodeI"));
        nodeI.setMaxOccurrs(-1);
        nodeI.setSource("vm1.g5");
        nodeI.addChildElement(new MappingElement("nodeJ", "vm1.g5.e1"));
        return doc;
    }

    private static MappingDocument doc6() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement simpleRoot = doc.addChildElement(new MappingElement("tempGroupTest"));
        simpleRoot.setSource("vm1.g1");
        simpleRoot.addStagingTable("tm1.g1");
        return doc;
    }

    private static MappingDocument docWithExcluded() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement n1 = root.addChildElement(new MappingElement("n1"));
        n1.setSource("vm1.g1");
        MappingElement m1 = n1.addChildElement(new MappingElement("m1", "vm1.g1.e1"));
        MappingElement n2 = m1.addChildElement(new MappingElement("n2"));
        n2.setSource("vm1.g2");
        n2.setExclude(true);
        n2.addChildElement(new MappingElement("leaf1", "vm1.g2.e2"));
        return doc;
    }

    private static MappingDocument docWithExcluded2() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement n1 = root.addChildElement(new MappingElement("n1"));
        n1.setSource("vm1.g1");
        n1.addChildElement(new MappingElement("m1", "vm1.g1.e1"));
        MappingElement m2 = n1.addChildElement(new MappingElement("m2", "vm1.g1.e2"));
        m2.setExclude(true);
        n1.addChildElement(new MappingElement("m3", "vm1.g1.e3"));
        return doc;
    }

    private static MappingDocument docTestCriteriaWithAttribute() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        root.setSource("vm1.g1");
        root.addAttribute(new MappingAttribute("type", new Namespace("xsi", "")));
        root.addAttribute(new MappingAttribute("type", "vm1.g1.e1"));
        root.addChildElement(new MappingElement("myElement", "vm1.g1.e2"));
        return doc;
    }

    @Test
    public void test1() throws Exception {
        TestXMLPlanner.helpPlan("SELECT * FROM vm1.doc1", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    @Test
    public void test1_defect7341() throws Exception {
        this.helpPlanException("SELECT * FROM vm1.doc1 WHERE a0 = '3'", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    @Test
    public void test1_defect7341_a() throws Exception {
        this.helpPlanException("SELECT * FROM vm1.doc3 WHERE context(m1, m1) = '3'", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    @Test
    public void test2() throws Exception {
        TestXMLPlanner.helpPlan("SELECT * FROM vm1.doc2", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    @Test
    public void test3() throws Exception {
        TestXMLPlanner.helpPlan("SELECT * FROM vm1.doc1 where a0.a1.a1='x'", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    @Test
    public void test4() throws Exception {
        TestXMLPlanner.helpPlan("SELECT * FROM vm1.doc3", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    @Test
    public void testTempGroupPlan() throws Exception {
        TransformationMetadata qmi = TestXMLPlanner.example1();
        XMLPlan plan = TestXMLPlanner.helpPlan("SELECT * FROM vm1.doc6", (QueryMetadataInterface)qmi);
        Program program = plan.getOriginalProgram();
        int i = 0;
        Assert.assertTrue((boolean)(program.getInstructionAt(i++) instanceof ExecStagingTableInstruction));
        Assert.assertTrue((boolean)(program.getInstructionAt(i++) instanceof ExecSqlInstruction));
        Assert.assertTrue((boolean)(program.getInstructionAt(i++) instanceof BlockInstruction));
        Assert.assertTrue((boolean)(program.getInstructionAt(i++) instanceof MoveCursorInstruction));
        Assert.assertTrue((boolean)(program.getInstructionAt(i++) instanceof WhileInstruction));
        Assert.assertTrue((boolean)(program.getInstructionAt(i++) instanceof EndBlockInstruction));
        Assert.assertTrue((boolean)(program.getInstructionAt(i++) instanceof ExecStagingTableInstruction));
    }

    @Test
    public void testPreparePlan() throws Exception {
        TestXMLPlanner.helpPlan("SELECT * FROM vm1.doc1 ORDER BY vm1.doc1.a0.a1.c1", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    @Test
    public void testPreparePlan2() throws Exception {
        TestXMLPlanner.helpPlan("SELECT root.@myAttribute FROM vm1.docWithAttribute", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLPlan preparePlan(Command command, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        IDGenerator idGenerator = new IDGenerator();
        AnalysisRecord analysis = new AnalysisRecord(false, false);
        XMLPlan xMLPlan = XMLPlanner.preparePlan((Command)command, (QueryMetadataInterface)metadata, (AnalysisRecord)analysis, (XMLPlannerEnvironment)new XMLPlannerEnvironment(metadata), (IDGenerator)idGenerator, (CapabilitiesFinder)capFinder, (CommandContext)context);
        return xMLPlan;
    }

    @Test
    public void testDefect18227() throws Exception {
        TransformationMetadata metadata = TestXMLPlanner.example1();
        String sql = "select * from vm1.docWithAttribute3 where root.@type = '3'";
        Query query = (Query)TestXMLProcessor.helpGetCommand(sql, (QueryMetadataInterface)metadata);
        try {
            TestXMLPlanner.preparePlan((Command)query, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), new CommandContext());
            Assert.fail((String)"Expected to get error about criteria against unmapped type attribute");
        }
        catch (QueryPlannerException e) {
            // empty catch block
        }
    }

    @Test
    public void testDefect21983() throws Exception {
        TransformationMetadata metadata = TestXMLPlanner.example1();
        String sql = "select root.@type from vm1.docWithAttribute3";
        Query query = (Query)TestXMLProcessor.helpGetCommand(sql, (QueryMetadataInterface)metadata);
        TestXMLPlanner.preparePlan((Command)query, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), new CommandContext());
    }

    @Test
    public void testRootStagingTableCase4308() throws Exception {
        String sql = "select * from vm1.doc1 where stagingTable2.e1 IN ('a', 'b', 'c')";
        TransformationMetadata metadata = this.exampleCase4308();
        Query query = (Query)new QueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)query, (QueryMetadataInterface)metadata);
        String expectedStagingTableResultSet = "vm1.doc1.stagingTable2";
        String actualStagingTableResultSet = CriteriaPlanner.getStagingTableForConjunct((Criteria)query.getCriteria(), (QueryMetadataInterface)metadata);
        Assert.assertEquals((Object)expectedStagingTableResultSet, (Object)actualStagingTableResultSet);
    }

    private TransformationMetadata exampleCase4308() {
        MetadataStore metadataStore = new MetadataStore();
        Schema pm1 = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        Schema vm1 = RealMetadataFactory.createVirtualModel("vm1", metadataStore);
        Table pm1g1 = RealMetadataFactory.createPhysicalGroup("g1", pm1);
        RealMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        QueryNode stagingTableNode = new QueryNode("SELECT * FROM pm1.g1");
        Table stagingTable = RealMetadataFactory.createXmlStagingTable("doc1.stagingTable2", vm1, stagingTableNode);
        RealMetadataFactory.createElements(stagingTable, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        root.addStagingTable("vm1.doc1.stagingTable2");
        RealMetadataFactory.createXmlDocument("doc1", vm1, doc);
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "case4308", new FunctionTree[0]);
    }
}

