/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.dqp.message.RequestID;

public class AtomicRequestID
implements Externalizable {
    private static final String SEPARATOR = ".";
    private RequestID requestId;
    private int nodeId;
    private int executionId;

    public AtomicRequestID() {
    }

    public AtomicRequestID(RequestID requestId, int nodeId, int execId) {
        this.requestId = requestId;
        this.nodeId = nodeId;
        this.executionId = execId;
    }

    public RequestID getRequestID() {
        return this.requestId;
    }

    public int getNodeID() {
        return this.nodeId;
    }

    public int getExecutionId() {
        return this.executionId;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.requestId = (RequestID)in.readObject();
        this.nodeId = in.readInt();
        this.executionId = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.requestId);
        out.writeInt(this.nodeId);
        out.writeInt(this.executionId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AtomicRequestID)) {
            return false;
        }
        AtomicRequestID c = (AtomicRequestID)o;
        return c.requestId.equals(this.requestId) && c.nodeId == this.nodeId && c.executionId == this.executionId;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode(HashCodeUtil.hashCode(this.requestId.hashCode(), this.nodeId), this.executionId);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.requestId).append(SEPARATOR).append(this.nodeId).append(SEPARATOR).append(this.executionId);
        return sb.toString();
    }
}

