/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Schema;
import org.teiid.metadata.TableStats;

public class Table
extends ColumnSet<Schema>
implements AbstractMetadataRecord.Modifiable,
AbstractMetadataRecord.DataModifiable {
    public static final int UNKNOWN_CARDINALITY = -1;
    private static final long serialVersionUID = 4891356771125218672L;
    private volatile int cardinality = -1;
    private Type tableType;
    private boolean isVirtual;
    private boolean isSystem;
    private boolean isMaterialized;
    private boolean supportsUpdate;
    private List<ForeignKey> foriegnKeys = new ArrayList<ForeignKey>(2);
    private List<KeyRecord> indexes = new ArrayList<KeyRecord>(2);
    private List<KeyRecord> functionBasedIndexes = new ArrayList<KeyRecord>(2);
    private List<KeyRecord> uniqueKeys = new ArrayList<KeyRecord>(2);
    private List<KeyRecord> accessPatterns = new ArrayList<KeyRecord>(2);
    private KeyRecord primaryKey;
    private volatile String selectTransformation;
    private volatile String insertPlan;
    private volatile String updatePlan;
    private volatile String deletePlan;
    private volatile boolean insertPlanEnabled;
    private volatile boolean updatePlanEnabled;
    private volatile boolean deletePlanEnabled;
    private Table materializedStageTable;
    private Table materializedTable;
    private List<String> bindings;
    private List<String> schemaPaths;
    private String resourcePath;
    private volatile transient long lastModified;
    private volatile transient long lastDataModification;

    static final int asInt(long f) {
        if (f == -1L || f < 0L) {
            return -1;
        }
        if (f <= Integer.MAX_VALUE) {
            return (int)f;
        }
        return Float.floatToRawIntBits(f) | Integer.MIN_VALUE;
    }

    static final float asFloat(int i) {
        if (i >= -1) {
            return i;
        }
        return Float.intBitsToFloat(i & Integer.MAX_VALUE);
    }

    public List<String> getBindings() {
        return this.bindings;
    }

    public void setBindings(List<String> bindings) {
        this.bindings = bindings;
    }

    public List<String> getSchemaPaths() {
        return this.schemaPaths;
    }

    public void setSchemaPaths(List<String> schemaPaths) {
        this.schemaPaths = schemaPaths;
    }

    public int getCardinality() {
        if (this.cardinality >= -1) {
            return this.cardinality;
        }
        return Integer.MAX_VALUE;
    }

    public float getCardinalityAsFloat() {
        return Table.asFloat(this.cardinality);
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public boolean isMaterialized() {
        return this.isMaterialized;
    }

    public boolean isPhysical() {
        return !this.isVirtual();
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public Type getTableType() {
        if (this.tableType == null) {
            return Type.Table;
        }
        return this.tableType;
    }

    public boolean supportsUpdate() {
        return this.supportsUpdate;
    }

    public void setCardinality(int i) {
        this.cardinality = Table.asInt(i);
    }

    public void setCardinality(long f) {
        this.cardinality = Table.asInt(f);
    }

    public void setTableType(Type i) {
        this.tableType = i;
    }

    public void setSupportsUpdate(boolean b) {
        this.supportsUpdate = b;
    }

    public void setVirtual(boolean b) {
        this.isVirtual = b;
    }

    public void setMaterialized(boolean isMaterialized) {
        this.isMaterialized = isMaterialized;
    }

    public void setSystem(boolean b) {
        this.isSystem = b;
    }

    public String getInsertPlan() {
        return this.insertPlan;
    }

    public String getUpdatePlan() {
        return this.updatePlan;
    }

    public String getDeletePlan() {
        return this.deletePlan;
    }

    public void setInsertPlan(String insertPlan) {
        this.insertPlan = DataTypeManager.getCanonicalString(insertPlan);
        this.insertPlanEnabled = true;
    }

    public void setUpdatePlan(String updatePlan) {
        this.updatePlan = DataTypeManager.getCanonicalString(updatePlan);
        this.updatePlanEnabled = true;
    }

    public void setDeletePlan(String deletePlan) {
        this.deletePlan = DataTypeManager.getCanonicalString(deletePlan);
        this.deletePlanEnabled = true;
    }

    public List<ForeignKey> getForeignKeys() {
        return this.foriegnKeys;
    }

    public void setForiegnKeys(List<ForeignKey> foriegnKeys) {
        this.foriegnKeys = foriegnKeys;
    }

    public List<KeyRecord> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<KeyRecord> indexes) {
        this.indexes = indexes;
    }

    public List<KeyRecord> getFunctionBasedIndexes() {
        return this.functionBasedIndexes;
    }

    public void setFunctionBasedIndexes(List<KeyRecord> functionBasedIndexes) {
        this.functionBasedIndexes = functionBasedIndexes;
    }

    public List<KeyRecord> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public void setUniqueKeys(List<KeyRecord> uniqueKeys) {
        this.uniqueKeys = uniqueKeys;
    }

    public List<KeyRecord> getAccessPatterns() {
        return this.accessPatterns;
    }

    public void setAccessPatterns(List<KeyRecord> accessPatterns) {
        this.accessPatterns = accessPatterns;
    }

    public KeyRecord getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(KeyRecord primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getSelectTransformation() {
        return this.selectTransformation;
    }

    public void setSelectTransformation(String selectTransformation) {
        this.selectTransformation = DataTypeManager.getCanonicalString(selectTransformation);
    }

    public Table getMaterializedStageTable() {
        return this.materializedStageTable;
    }

    public Table getMaterializedTable() {
        return this.materializedTable;
    }

    public void setMaterializedStageTable(Table materializedStageTable) {
        this.materializedStageTable = materializedStageTable;
    }

    public void setMaterializedTable(Table materializedTable) {
        this.materializedTable = materializedTable;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = DataTypeManager.getCanonicalString(resourcePath);
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public Collection<KeyRecord> getAllKeys() {
        LinkedList<KeyRecord> keys = new LinkedList<KeyRecord>();
        if (this.getPrimaryKey() != null) {
            keys.add(this.getPrimaryKey());
        }
        keys.addAll(this.getForeignKeys());
        keys.addAll(this.getAccessPatterns());
        keys.addAll(this.getIndexes());
        keys.addAll(this.getUniqueKeys());
        return keys;
    }

    @Override
    public void addColumn(Column column) {
        super.addColumn(column);
        column.setParent(this);
    }

    @Override
    public long getLastDataModification() {
        return this.lastDataModification;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastDataModification(long lastDataModification) {
        this.lastDataModification = lastDataModification;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setTableStats(TableStats stats) {
        if (stats.getCardinality() != null) {
            this.setCardinality(stats.getCardinality().longValue());
        }
    }

    public boolean isDeletePlanEnabled() {
        return this.deletePlanEnabled;
    }

    public boolean isInsertPlanEnabled() {
        return this.insertPlanEnabled;
    }

    public boolean isUpdatePlanEnabled() {
        return this.updatePlanEnabled;
    }

    public void setInsertPlanEnabled(boolean insertPlanEnabled) {
        this.insertPlanEnabled = insertPlanEnabled;
    }

    public void setDeletePlanEnabled(boolean deletePlanEnabled) {
        this.deletePlanEnabled = deletePlanEnabled;
    }

    public void setUpdatePlanEnabled(boolean updatePlanEnabled) {
        this.updatePlanEnabled = updatePlanEnabled;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.functionBasedIndexes == null) {
            this.functionBasedIndexes = new ArrayList<KeyRecord>(2);
        }
    }

    @Override
    public String getFullName() {
        if (this.tableType == Type.TemporaryTable && !this.isVirtual) {
            return this.getName();
        }
        return super.getFullName();
    }

    public static enum TriggerEvent {
        INSERT,
        UPDATE,
        DELETE;

    }

    public static enum Type {
        Table,
        View,
        Document,
        XmlMappingClass,
        XmlStagingTable,
        MaterializedTable,
        TemporaryTable{

            public String toString() {
                return "TEMPORARY TABLE";
            }
        };

    }
}

