/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Table;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.validator.ValidatorReport;

public class SystemMetadata {
    private static SystemMetadata INSTANCE = new SystemMetadata();
    private List<Datatype> dataTypes = new ArrayList<Datatype>();
    private Map<String, Datatype> typeMap = new TreeMap<String, Datatype>(String.CASE_INSENSITIVE_ORDER);
    private MetadataStore systemStore;

    public static SystemMetadata getInstance() {
        return INSTANCE;
    }

    public SystemMetadata() {
        InputStream is = SystemMetadata.class.getClassLoader().getResourceAsStream("org/teiid/metadata/types.dat");
        try {
            InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-8"));
            BufferedReader br = new BufferedReader(isr);
            String s = br.readLine();
            String[] props = s.split("\\|");
            while ((s = br.readLine()) != null) {
                Datatype dt = new Datatype();
                String[] vals = s.split("\\|");
                Properties p = new Properties();
                for (int i = 0; i < props.length; ++i) {
                    if (vals[i].length() == 0) continue;
                    p.setProperty(props[i], new String(vals[i]));
                }
                PropertiesUtils.setBeanProperties(dt, p, null);
                if ("string".equals(dt.getName())) {
                    dt.setLength(DataTypeManager.MAX_STRING_LENGTH);
                } else if ("varbinary".equals(dt.getName())) {
                    dt.setLength(DataTypeManager.MAX_LOB_MEMORY_BYTES);
                }
                this.dataTypes.add(dt);
                if (!dt.isBuiltin()) continue;
                this.typeMap.put(dt.getRuntimeTypeName(), dt);
            }
            is.close();
        }
        catch (IOException e) {
            throw new TeiidRuntimeException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new TeiidRuntimeException(e);
            }
        }
        this.addAliasType("bigint");
        this.addAliasType("decimal");
        this.addAliasType("real");
        this.addAliasType("smallint");
        this.addAliasType("tinyint");
        this.addAliasType("varchar");
        for (String name : DataTypeManager.getAllDataTypeNames()) {
            if (name.equals("null")) continue;
            Assertion.isNotNull(this.typeMap.get(name), name);
        }
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("System");
        vdb.setVersion(1);
        Properties p = new Properties();
        QueryParser parser = new QueryParser();
        this.systemStore = this.loadSchema(vdb, p, "SYS", parser).asMetadataStore();
        this.systemStore.addDataTypes(this.dataTypes);
        this.loadSchema(vdb, p, "SYSADMIN", parser).mergeInto(this.systemStore);
        TransformationMetadata tm = new TransformationMetadata(vdb, new CompositeMetadataStore(this.systemStore), null, new SystemFunctionManager().getSystemFunctions(), null);
        vdb.addAttchment(QueryMetadataInterface.class, tm);
        MetadataValidator validator = new MetadataValidator(this.typeMap, parser);
        ValidatorReport report = validator.validate(vdb, this.systemStore);
        if (report.hasItems()) {
            throw new TeiidRuntimeException(report.getFailureMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataFactory loadSchema(VDBMetaData vdb, Properties p, String name, QueryParser parser) {
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName(name);
        vdb.addModel(mmd);
        InputStream is = SystemMetadata.class.getClassLoader().getResourceAsStream("org/teiid/metadata/" + name + ".sql");
        try {
            MetadataFactory factory = new MetadataFactory(vdb.getName(), vdb.getVersion(), name, this.typeMap, p, null);
            parser.parseDDL(factory, new InputStreamReader(is, Charset.forName("UTF-8")));
            for (Table t : factory.getSchema().getTables().values()) {
                t.setSystem(true);
            }
            MetadataFactory metadataFactory = factory;
            return metadataFactory;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new TeiidRuntimeException(e);
            }
        }
    }

    private void addAliasType(String alias) {
        Class<?> typeClass = DataTypeManager.getDataTypeClass(alias);
        String primaryType = DataTypeManager.getDataTypeName(typeClass);
        Datatype dt = this.typeMap.get(primaryType);
        Assertion.isNotNull(dt, alias);
        this.typeMap.put(alias, dt);
    }

    public List<Datatype> getDataTypes() {
        return this.dataTypes;
    }

    public Map<String, Datatype> getRuntimeTypeMap() {
        return this.typeMap;
    }

    public MetadataStore getSystemStore() {
        return this.systemStore;
    }
}

