/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.VariableResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.util.SymbolMap;

public class InsertResolver
extends ProcedureContainerResolver
implements VariableResolver {
    @Override
    public void resolveProceduralCommand(Command command, TempMetadataAdapter metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        boolean usingQuery;
        Insert insert = (Insert)command;
        if (insert.getValues() != null) {
            QueryResolver.resolveSubqueries(command, metadata, null);
            this.resolveList(insert.getValues(), metadata, insert.getExternalGroupContexts(), null);
        }
        if (insert.getQueryExpression() != null) {
            QueryResolver.setChildMetadata(insert.getQueryExpression(), command);
            QueryResolver.resolveCommand(insert.getQueryExpression(), metadata.getMetadata(), false);
        }
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(insert.getGroup());
        List<Expression> values = insert.getValues();
        boolean bl = usingQuery = insert.getQueryExpression() != null;
        if (usingQuery) {
            values = insert.getQueryExpression().getProjectedSymbols();
        }
        if (insert.getVariables().isEmpty()) {
            if (insert.getGroup().isResolved()) {
                List<ElementSymbol> variables = ResolverUtil.resolveElementsInGroup(insert.getGroup(), metadata);
                Iterator<ElementSymbol> i = variables.iterator();
                while (i.hasNext()) {
                    insert.addVariable(i.next().clone());
                }
            } else {
                for (int i = 0; i < values.size(); ++i) {
                    if (usingQuery) {
                        Expression ses = values.get(i);
                        ElementSymbol es = new ElementSymbol(Symbol.getShortName(ses));
                        es.setType(ses.getType());
                        insert.addVariable(es);
                        continue;
                    }
                    insert.addVariable(new ElementSymbol("expr" + i));
                }
            }
        } else if (insert.getGroup().isResolved()) {
            this.resolveVariables(metadata, insert, groups);
        }
        this.resolveTypes(insert, metadata, values, usingQuery);
        if (!insert.getGroup().isResolved()) {
            ResolverUtil.resolveImplicitTempGroup(metadata, insert.getGroup(), insert.getVariables());
            this.resolveVariables(metadata, insert, groups);
            this.resolveTypes(insert, metadata, values, usingQuery);
        }
        if (insert.getQueryExpression() != null && metadata.isVirtualGroup(insert.getGroup().getMetadataID())) {
            ArrayList<Reference> references = new ArrayList<Reference>(insert.getVariables().size());
            for (int i = 0; i < insert.getVariables().size(); ++i) {
                Reference ref = new Reference(i);
                ref.setType(insert.getVariables().get(i).getType());
                references.add(ref);
            }
            insert.setValues(references);
        }
    }

    private void resolveVariables(TempMetadataAdapter metadata, Insert insert, Set<GroupSymbol> groups) throws TeiidComponentException, QueryResolverException {
        try {
            this.resolveList(insert.getVariables(), metadata, null, groups);
        }
        catch (QueryResolverException e) {
            throw new QueryResolverException(QueryPlugin.Event.TEIID30126, e, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30126, insert.getGroup(), e.getUnresolvedSymbols()));
        }
    }

    private void resolveList(Collection elements, TempMetadataAdapter metadata, GroupContext externalGroups, Set<GroupSymbol> groups) throws TeiidComponentException, QueryResolverException {
        for (Expression expr : elements) {
            ResolverVisitor.resolveLanguageObject(expr, groups, externalGroups, metadata);
        }
    }

    public void resolveTypes(Insert insert, TempMetadataAdapter metadata, List values, boolean usingQuery) throws QueryResolverException {
        ArrayList<Expression> newValues = new ArrayList<Expression>(values.size());
        if (values.size() != insert.getVariables().size()) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30127, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30127, insert.getVariables().size(), values.size()));
        }
        Iterator valueIter = values.iterator();
        Iterator<ElementSymbol> varIter = insert.getVariables().iterator();
        while (valueIter.hasNext()) {
            Expression expression = (Expression)valueIter.next();
            ElementSymbol element = varIter.next();
            if (expression.getType() == null) {
                ResolverUtil.setDesiredType(SymbolMap.getExpression(expression), element.getType(), insert);
            }
            if (element.getType() != null && expression.getType() != null) {
                String elementTypeName = DataTypeManager.getDataTypeName(element.getType());
                if (!usingQuery) {
                    newValues.add(ResolverUtil.convertExpression(expression, elementTypeName, metadata));
                    continue;
                }
                if (element.getType() == expression.getType() || DataTypeManager.isImplicitConversion(DataTypeManager.getDataTypeName(expression.getType()), DataTypeManager.getDataTypeName(element.getType()))) continue;
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30128, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30128, expression, expression.getType().getName(), element, element.getType().getName()));
            }
            if (element.getType() == null && expression.getType() != null) {
                element.setType(expression.getType());
                newValues.add(expression);
                continue;
            }
            Assertion.failed("Cannot determine element or expression type");
        }
        if (!usingQuery) {
            insert.setValues(newValues);
        }
    }

    @Override
    protected String getPlan(QueryMetadataInterface metadata, GroupSymbol group) throws TeiidComponentException, QueryMetadataException {
        return metadata.getInsertPlan(group.getMetadataID());
    }

    @Override
    protected void resolveGroup(TempMetadataAdapter metadata, ProcedureContainer procCommand) throws TeiidComponentException, QueryResolverException {
        if (!procCommand.getGroup().isImplicitTempGroupSymbol() || metadata.getMetadataStore().getTempGroupID(procCommand.getGroup().getName()) != null) {
            super.resolveGroup(metadata, procCommand);
        }
    }

    @Override
    public Map<ElementSymbol, Expression> getVariableValues(Command command, boolean changingOnly, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Insert insert = (Insert)command;
        HashMap<ElementSymbol, Expression> result = new HashMap<ElementSymbol, Expression>();
        Iterator<ElementSymbol> varIter = insert.getVariables().iterator();
        Iterator<Object> valIter = null;
        valIter = insert.getQueryExpression() != null ? insert.getQueryExpression().getProjectedSymbols().iterator() : insert.getValues().iterator();
        while (varIter.hasNext()) {
            ElementSymbol next = varIter.next();
            ElementSymbol varSymbol = next.clone();
            varSymbol.getGroupSymbol().setName("CHANGING");
            varSymbol.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
            result.put(varSymbol, new Constant(Boolean.TRUE));
            if (changingOnly) continue;
            varSymbol = next.clone();
            varSymbol.getGroupSymbol().setName("NEW");
            result.put(varSymbol, (Expression)valIter.next());
        }
        List<ElementSymbol> insertElmnts = ResolverUtil.resolveElementsInGroup(insert.getGroup(), metadata);
        insertElmnts.removeAll(insert.getVariables());
        for (ElementSymbol next : insertElmnts) {
            ElementSymbol varSymbol = next.clone();
            varSymbol.getGroupSymbol().setName("CHANGING");
            varSymbol.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
            result.put(varSymbol, new Constant(Boolean.FALSE));
            if (changingOnly) continue;
            varSymbol = next.clone();
            Expression value = ResolverUtil.getDefault(varSymbol, metadata);
            varSymbol.getGroupSymbol().setName("NEW");
            result.put(varSymbol, value);
        }
        return result;
    }
}

