/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public class SPParameter
implements Cloneable {
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int INOUT = 3;
    public static final int RETURN_VALUE = 4;
    public static final int RESULT_SET = 5;
    private int parameterType = 1;
    private Expression expression;
    private int index;
    private List<ElementSymbol> resultSetColumns;
    private List<Object> resultSetIDs;
    private boolean usingDefault;
    private boolean varArg;
    private ElementSymbol parameterSymbol;

    public SPParameter(int index, Expression expression) {
        this.setIndex(index);
        this.setExpression(expression);
        this.parameterSymbol = new ElementSymbol("");
    }

    public SPParameter(int index, int parameterType, String name) {
        this.setIndex(index);
        this.setParameterType(parameterType);
        this.parameterSymbol = new ElementSymbol(name);
    }

    private SPParameter() {
    }

    public String getName() {
        return this.parameterSymbol.getName();
    }

    public void setName(String name) {
        ElementSymbol es = new ElementSymbol(name);
        es.setMetadataID(this.parameterSymbol.getMetadataID());
        es.setType(this.parameterSymbol.getType());
        this.parameterSymbol = es;
    }

    public void setParameterType(int parameterType) {
        if (parameterType < 1 || parameterType > 5) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0006", parameterType));
        }
        this.parameterType = parameterType;
    }

    public int getParameterType() {
        return this.parameterType;
    }

    public void setClassType(Class<?> classType) {
        this.parameterSymbol.setType(classType);
    }

    public Class<?> getClassType() {
        return this.parameterSymbol.getType();
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void addResultSetColumn(String colName, Class<?> type, Object id) {
        if (this.resultSetColumns == null) {
            this.resultSetColumns = new ArrayList<ElementSymbol>();
            this.resultSetIDs = new ArrayList<Object>();
        }
        ElementSymbol rsColumn = new ElementSymbol(colName);
        rsColumn.setType(type);
        rsColumn.setMetadataID(id);
        this.resultSetColumns.add(rsColumn);
        this.resultSetIDs.add(id);
    }

    public List<ElementSymbol> getResultSetColumns() {
        if (this.resultSetColumns == null) {
            return Collections.emptyList();
        }
        return this.resultSetColumns;
    }

    public List<Object> getResultSetIDs() {
        if (this.resultSetIDs == null) {
            return Collections.emptyList();
        }
        return this.resultSetIDs;
    }

    public ElementSymbol getResultSetColumn(int position) {
        if (this.resultSetColumns == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0009"));
        }
        if (--position >= 0 && position < this.resultSetColumns.size()) {
            return this.resultSetColumns.get(position);
        }
        throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0010", new Integer(position + 1)));
    }

    public Object getMetadataID() {
        return this.parameterSymbol.getMetadataID();
    }

    public void setMetadataID(Object metadataID) {
        this.parameterSymbol.setMetadataID(metadataID);
    }

    public ElementSymbol getParameterSymbol() {
        return this.parameterSymbol;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SPParameter)) {
            return false;
        }
        SPParameter other = (SPParameter)obj;
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        return EquivalenceUtil.areEqual(this.expression, other.expression);
    }

    public int hashCode() {
        return this.index;
    }

    public Object clone() {
        SPParameter copy = new SPParameter();
        copy.index = this.index;
        copy.parameterType = this.parameterType;
        copy.parameterSymbol = this.parameterSymbol.clone();
        if (this.expression != null) {
            copy.setExpression((Expression)this.expression.clone());
        }
        if (this.resultSetColumns != null) {
            Iterator<ElementSymbol> iter = this.resultSetColumns.iterator();
            Iterator<Object> idIter = this.resultSetIDs.iterator();
            while (iter.hasNext()) {
                ElementSymbol column = iter.next();
                copy.addResultSetColumn(column.getName(), column.getType(), idIter.next());
            }
        }
        copy.setUsingDefault(this.usingDefault);
        copy.varArg = this.varArg;
        return copy;
    }

    public String toString() {
        if (this.expression != null) {
            return this.expression.toString();
        }
        return "?";
    }

    public boolean isUsingDefault() {
        return this.usingDefault;
    }

    public void setUsingDefault(boolean usingDefault) {
        this.usingDefault = usingDefault;
    }

    public void setVarArg(boolean varArg) {
        this.varArg = varArg;
    }

    public boolean isVarArg() {
        return this.varArg;
    }
}

