/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TestPreparedStatement;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Parameter;
import org.teiid.language.visitor.CollectorVisitor;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.TestUpdateValidator;

public class TestPreparedStatementBatchedUpdate {
    @Test
    public void testBatchedUpdatePushdown() throws Exception {
        String preparedSql = "UPDATE pm1.g1 SET pm1.g1.e1=?, pm1.g1.e3=? WHERE pm1.g1.e2=?";
        SessionAwareCache prepPlanCache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("UPDATE pm1.g1 SET e1 = ?, e3 = ? WHERE pm1.g1.e2 = ?", Arrays.asList(4));
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.BULK_UPDATE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>(2);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList(null, Boolean.FALSE, new Integer(1))));
        List[] expected = new List[]{Arrays.asList(4)};
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, false, RealMetadataFactory.example1VDB());
        Update update = (Update)dataManager.getCommandHistory().iterator().next();
        Assert.assertTrue((boolean)((Constant)((SetClause)update.getChangeList().getClauses().get(0)).getValue()).isMultiValued());
    }

    @Test
    public void testBatchedUpdatePushdown1() throws Exception {
        TransformationMetadata metadata = TestUpdateValidator.example1();
        TestUpdateValidator.createView("select 1 as x, 2 as y", metadata, "GX");
        Table t = (Table)((Schema)metadata.getMetadataStore().getSchemas().get("VM1")).getTables().get("GX");
        t.setDeletePlan("");
        t.setUpdatePlan("");
        t.setInsertPlan("FOR EACH ROW BEGIN insert into pm1.g1 (e1) values (new.x); END");
        String preparedSql = "insert into gx (x, y) values (?,?)";
        SessionAwareCache prepPlanCache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)metadata);
        dataManager.addData("INSERT INTO g1 (e1) VALUES (convert(?, string))", Arrays.asList(2));
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.BULK_UPDATE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ArrayList<ArrayList<Integer>> values = new ArrayList<ArrayList<Integer>>(2);
        values.add(new ArrayList<Integer>(Arrays.asList(3, 4)));
        values.add(new ArrayList<Integer>(Arrays.asList(5, 6)));
        List[] expected = new List[]{Arrays.asList(2)};
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)metadata, (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, false, RealMetadataFactory.example1VDB());
        Insert insert = (Insert)dataManager.getPushdownCommands().iterator().next();
        Parameter p = (Parameter)CollectorVisitor.collectObjects(Parameter.class, (LanguageObject)insert).iterator().next();
        Assert.assertEquals((long)0L, (long)p.getValueIndex());
        Assert.assertEquals(Arrays.asList(3), insert.getParameterValues().next());
        Assert.assertTrue((boolean)insert.getParameterValues().hasNext());
    }

    @Test
    public void testBatchedUpdateNotPushdown() throws Exception {
        String preparedSql = "UPDATE pm1.g1 SET pm1.g1.e1=?, pm1.g1.e3=? WHERE pm1.g1.e2=?";
        SessionAwareCache prepPlanCache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("UPDATE pm1.g1 SET e1 = 'a', e3 = FALSE WHERE pm1.g1.e2 = 0", Arrays.asList(2));
        dataManager.addData("UPDATE pm1.g1 SET e1 = null, e3 = FALSE WHERE pm1.g1.e2 = 1", Arrays.asList(2));
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.BULK_UPDATE, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>(2);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList(null, Boolean.FALSE, new Integer(1))));
        List[] expected = new List[]{Arrays.asList(2), Arrays.asList(2)};
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, false, RealMetadataFactory.example1VDB());
    }

    @Test
    public void testBatchedMerge() throws Exception {
        String ddl = "CREATE foreign table x (y string primary key, z integer) options (updatable true)";
        TransformationMetadata metadata = RealMetadataFactory.fromDDL(ddl, "x", "phy");
        String preparedSql = "merge into x (y, z) values (?, ?)";
        SessionAwareCache prepPlanCache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT 1 FROM phy.x AS g_0 WHERE g_0.y = 'a'", Arrays.asList(1));
        dataManager.addData("UPDATE x SET z = 0 WHERE y = 'a'", Arrays.asList(1));
        dataManager.addData("INSERT INTO x (y, z) VALUES (null, 1)", Arrays.asList(1));
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        capFinder.addCapabilities("phy", (SourceCapabilities)caps);
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>(2);
        values.add(new ArrayList<Object>(Arrays.asList("a", new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList(null, new Integer(1))));
        List[] expected = new List[]{Arrays.asList(1), Arrays.asList(1)};
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)metadata, (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, false, RealMetadataFactory.example1VDB());
    }

    @Test
    public void testUpdateSameNumCmds() throws Exception {
        String preparedSql = "UPDATE pm1.g1 SET pm1.g1.e1=?, pm1.g1.e3=? WHERE pm1.g1.e2=?";
        SessionAwareCache prepPlanCache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.BATCHED_UPDATES, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ArrayList<String> finalQueryList = new ArrayList<String>(13);
        List[] expected = new List[]{Arrays.asList(new Integer(2)), Arrays.asList(new Integer(2))};
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>(2);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList(null, Boolean.FALSE, new Integer(1))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'a', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = null, e3 = FALSE WHERE pm1.g1.e2 = 1"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, false, RealMetadataFactory.example1VDB());
        expected = new List[]{Arrays.asList(new Integer(2)), Arrays.asList(new Integer(0))};
        values = new ArrayList(1);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList("b", Boolean.TRUE, new Integer(5))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'a', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'b', e3 = TRUE WHERE pm1.g1.e2 = 5"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, true, RealMetadataFactory.example1VDB());
        Assert.assertEquals((String)"Unexpected queries executed -", finalQueryList, dataManager.getQueries());
    }

    @Test
    public void testUpdateSameNumCmds_Virtual() throws Exception {
        String preparedSql = "UPDATE vm1.g1 SET vm1.g1.e2=? WHERE vm1.g1.e1=?";
        SessionAwareCache prepPlanCache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.BATCHED_UPDATES, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ArrayList<String> finalQueryList = new ArrayList<String>();
        List[] expected = new List[]{Arrays.asList(3), Arrays.asList(1)};
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>(2);
        values.add(new ArrayList<Object>(Arrays.asList(new Integer(0), "a")));
        values.add(new ArrayList<Object>(Arrays.asList(new Integer(1), "b")));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e2 = 0 WHERE pm1.g1.e1 = 'a'"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e2 = 1 WHERE pm1.g1.e1 = 'b'"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, false, RealMetadataFactory.example1VDB());
        expected = new List[]{Arrays.asList(1), Arrays.asList(0)};
        values = new ArrayList(1);
        values.add(new ArrayList<Object>(Arrays.asList(new Integer(2), "c")));
        values.add(new ArrayList<Object>(Arrays.asList(new Integer(3), "d")));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e2 = 2 WHERE pm1.g1.e1 = 'c'"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e2 = 3 WHERE pm1.g1.e1 = 'd'"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, true, RealMetadataFactory.example1VDB());
        Assert.assertEquals((String)"Unexpected queries executed -", finalQueryList, dataManager.getQueries());
    }

    @Test
    public void testUpdateVarNumCmds() throws Exception {
        String preparedSql = "UPDATE pm1.g1 SET pm1.g1.e1=?, pm1.g1.e3=? WHERE pm1.g1.e2=?";
        SessionAwareCache prepPlanCache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.BATCHED_UPDATES, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ArrayList<String> finalQueryList = new ArrayList<String>(13);
        List[] expected = new List[]{Arrays.asList(new Integer(2)), Arrays.asList(new Integer(2))};
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>(2);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList(null, Boolean.FALSE, new Integer(1))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'a', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = null, e3 = FALSE WHERE pm1.g1.e2 = 1"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, false, RealMetadataFactory.example1VDB());
        expected = new List[]{Arrays.asList(new Integer(2))};
        values = new ArrayList(1);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'a', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, true, RealMetadataFactory.example1VDB());
        expected = new List[]{Arrays.asList(new Integer(2)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(0)), Arrays.asList(new Integer(0))};
        values = new ArrayList(4);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList(null, Boolean.FALSE, new Integer(1))));
        values.add(new ArrayList<Object>(Arrays.asList("c", Boolean.TRUE, new Integer(4))));
        values.add(new ArrayList<Object>(Arrays.asList("b", Boolean.TRUE, new Integer(5))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'a', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = null, e3 = FALSE WHERE pm1.g1.e2 = 1"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'c', e3 = TRUE WHERE pm1.g1.e2 = 4"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'b', e3 = TRUE WHERE pm1.g1.e2 = 5"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, true, RealMetadataFactory.example1VDB());
        Assert.assertEquals((String)"Unexpected queries executed -", finalQueryList, dataManager.getQueries());
    }

    @Test
    public void testUpdateVarNumCmds_Virtual() throws Exception {
        String preparedSql = "UPDATE vm1.g1 SET vm1.g1.e1=?, vm1.g1.e3=? WHERE vm1.g1.e2=?";
        SessionAwareCache prepPlanCache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.BATCHED_UPDATES, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ArrayList<String> finalQueryList = new ArrayList<String>(13);
        List[] expected = new List[]{Arrays.asList(2), Arrays.asList(2)};
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>(2);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList("b", Boolean.TRUE, new Integer(1))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'a', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'b', e3 = TRUE WHERE pm1.g1.e2 = 1"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, false, RealMetadataFactory.example1VDB());
        expected = new List[]{Arrays.asList(new Integer(2))};
        values = new ArrayList(1);
        values.add(new ArrayList<Object>(Arrays.asList("c", Boolean.FALSE, new Integer(1))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'c', e3 = FALSE WHERE pm1.g1.e2 = 1"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, true, RealMetadataFactory.example1VDB());
        expected = new List[]{Arrays.asList(2), Arrays.asList(2), Arrays.asList(1), Arrays.asList(1)};
        values = new ArrayList(4);
        values.add(new ArrayList<Object>(Arrays.asList("d", Boolean.FALSE, new Integer(1))));
        values.add(new ArrayList<Object>(Arrays.asList("e", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList("f", Boolean.TRUE, new Integer(2))));
        values.add(new ArrayList<Object>(Arrays.asList("g", Boolean.TRUE, new Integer(3))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'd', e3 = FALSE WHERE pm1.g1.e2 = 1"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'e', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'f', e3 = TRUE WHERE pm1.g1.e2 = 2"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'g', e3 = TRUE WHERE pm1.g1.e2 = 3"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, true, RealMetadataFactory.example1VDB());
        Assert.assertEquals((String)"Unexpected queries executed -", finalQueryList, dataManager.getQueries());
    }
}

