/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.ArgCheck;
import org.teiid.metadata.Column;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.translator.TranslatorException;

public class RuntimeMetadataImpl
implements RuntimeMetadata {
    private QueryMetadataInterface metadata;

    public RuntimeMetadataImpl(QueryMetadataInterface metadata) {
        ArgCheck.isNotNull(metadata);
        this.metadata = metadata;
    }

    @Override
    public Column getColumn(String schema, String table, String name) throws TranslatorException {
        return this.getColumn(schema + '.' + table + '.' + name);
    }

    @Override
    public Procedure getProcedure(String schema, String name) throws TranslatorException {
        return this.getProcedure(schema + '.' + name);
    }

    @Override
    public Table getTable(String schema, String name) throws TranslatorException {
        return this.getTable(schema + '.' + name);
    }

    @Override
    public Column getColumn(String fullName) throws TranslatorException {
        try {
            Object metadataId = this.metadata.getElementID(fullName);
            return this.getElement(metadataId);
        }
        catch (QueryMetadataException e) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30464, (Throwable)e);
        }
        catch (TeiidComponentException e) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30465, (Throwable)e);
        }
    }

    public Column getElement(Object elementId) {
        if (elementId instanceof Column) {
            return (Column)elementId;
        }
        return null;
    }

    @Override
    public Table getTable(String fullName) throws TranslatorException {
        try {
            Object groupId = this.metadata.getGroupID(fullName);
            return this.getGroup(groupId);
        }
        catch (QueryMetadataException e) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30466, (Throwable)e);
        }
        catch (TeiidComponentException e) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30467, (Throwable)e);
        }
    }

    public Table getGroup(Object groupId) throws QueryMetadataException, TeiidComponentException {
        if ((groupId = TempMetadataAdapter.getActualMetadataId(groupId)) instanceof Table && !this.metadata.isVirtualGroup(groupId)) {
            return (Table)groupId;
        }
        return null;
    }

    @Override
    public Procedure getProcedure(String fullName) throws TranslatorException {
        try {
            StoredProcedureInfo sp = this.metadata.getStoredProcedureInfoForProcedure(fullName);
            return this.getProcedure(sp);
        }
        catch (QueryMetadataException e) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30468, (Throwable)e);
        }
        catch (TeiidComponentException e) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30469, (Throwable)e);
        }
    }

    public Procedure getProcedure(StoredProcedureInfo sp) {
        if (sp.getProcedureID() instanceof Procedure) {
            return (Procedure)sp.getProcedureID();
        }
        return null;
    }

    public ProcedureParameter getParameter(SPParameter param) {
        if (param.getMetadataID() instanceof ProcedureParameter) {
            return (ProcedureParameter)param.getMetadataID();
        }
        return null;
    }

    @Override
    public byte[] getBinaryVDBResource(String resourcePath) throws TranslatorException {
        try {
            return this.metadata.getBinaryVDBResource(resourcePath);
        }
        catch (QueryMetadataException e) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30470, (Throwable)e);
        }
        catch (TeiidComponentException e) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30471, (Throwable)e);
        }
    }

    @Override
    public String getCharacterVDBResource(String resourcePath) throws TranslatorException {
        try {
            return this.metadata.getCharacterVDBResource(resourcePath);
        }
        catch (QueryMetadataException e) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30472, (Throwable)e);
        }
        catch (TeiidComponentException e) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30473, (Throwable)e);
        }
    }

    @Override
    public String[] getVDBResourcePaths() throws TranslatorException {
        try {
            return this.metadata.getVDBResourcePaths();
        }
        catch (QueryMetadataException e) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30474, (Throwable)e);
        }
        catch (TeiidComponentException e) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30475, (Throwable)e);
        }
    }

    public QueryMetadataInterface getMetadata() {
        return this.metadata;
    }
}

