/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLWarning;
import java.util.List;
import org.teiid.client.SourceWarning;
import org.teiid.core.TeiidException;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.PartialResultsWarning;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.jdbc.TeiidSQLWarning;

class WarningUtil {
    private WarningUtil() {
    }

    static SQLWarning createWarning(Throwable ex) {
        String sourceName = null;
        String modelName = null;
        if (ex instanceof SourceWarning) {
            SourceWarning exception = (SourceWarning)ex;
            if (exception.isPartialResultsError()) {
                PartialResultsWarning warning = new PartialResultsWarning(JDBCPlugin.Util.getString("WarningUtil.Failures_occurred"));
                warning.addConnectorFailure(exception.getConnectorBindingName(), TeiidSQLException.create(exception));
                return warning;
            }
            ex = exception.getCause();
            sourceName = exception.getConnectorBindingName();
            modelName = exception.getModelName();
        }
        String code = null;
        if (ex instanceof TeiidException) {
            code = ((TeiidException)ex).getCode();
        }
        return new TeiidSQLWarning(ex.getMessage(), code, ex, sourceName, modelName);
    }

    static SQLWarning convertWarnings(List<Throwable> exceptions) {
        SQLWarning root;
        if (exceptions == null || exceptions.size() == 0) {
            return null;
        }
        SQLWarning current = root = WarningUtil.createWarning(exceptions.get(0));
        for (int i = 1; i < exceptions.size(); ++i) {
            SQLWarning newWarning = WarningUtil.createWarning(exceptions.get(i));
            current.setNextWarning(newWarning);
            current = newWarning;
        }
        return root;
    }
}

