/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.client.xa.XATransactionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.net.CommunicationException;
import org.teiid.net.ServerConnection;
import org.teiid.net.socket.SingleInstanceCommunicationException;

public class XAConnectionImpl
implements XAConnection,
XAResource {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    private int timeOut;
    private Set<ConnectionEventListener> listeners;
    private ConnectionImpl connection;
    private CloseInterceptor handler;
    private boolean isClosed;

    public XAConnectionImpl(ConnectionImpl conn) {
        this.connection = conn;
    }

    @Override
    public Connection getConnection() throws SQLException {
        ConnectionImpl conn = this.getConnectionImpl();
        if (this.handler != null) {
            this.handler.close();
        }
        this.handler = new CloseInterceptor(conn);
        Connection result = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)this.handler);
        return result;
    }

    ConnectionImpl getConnectionImpl() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(JDBCPlugin.Util.getString("MMXAConnection.connection_is_closed"));
        }
        return this.connection;
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.listeners == null) {
            this.listeners = Collections.newSetFromMap(new IdentityHashMap());
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.isClosed = true;
    }

    protected synchronized void notifyListener(SQLException e) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ConnectionEventListener listener : this.listeners) {
                if (e == null) {
                    listener.connectionClosed(new ConnectionEvent(this));
                    continue;
                }
                listener.connectionErrorOccurred(new ConnectionEvent(this, e));
            }
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener arg0) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener arg0) {
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        XidImpl mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().commitTransaction(mmXid, onePhase);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedCommitTXN", xid, onePhase ? "true" : "false");
            throw this.handleError(e, logMsg);
        }
    }

    private XAException handleError(Exception e, String logMsg) {
        logger.log(Level.SEVERE, logMsg, e);
        if (e instanceof TeiidSQLException) {
            Throwable ex = ((TeiidSQLException)e).getCause();
            if (ex instanceof XAException) {
                return (XAException)ex;
            }
            if (ex instanceof XATransactionException) {
                return ((XATransactionException)ex).getXAException();
            }
        }
        return new XAException(-3);
    }

    @Override
    public void end(Xid xid, int flag) throws XAException {
        XidImpl mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().endTransaction(mmXid, flag);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedEndTXN", xid, new Integer(flag));
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        XidImpl mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().forgetTransaction(mmXid);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedForgetTXN", xid);
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeOut;
    }

    @Override
    public boolean isSameRM(XAResource arg0) throws XAException {
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof XAConnectionImpl)) {
            return false;
        }
        XAConnectionImpl other = (XAConnectionImpl)arg0;
        try {
            return this.getMMConnection().isSameProcess(other.getMMConnection());
        }
        catch (CommunicationException e) {
            throw this.handleError(e, JDBCPlugin.Util.getString("MMXAResource.FailedISSameRM"));
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        XidImpl mmXid = this.getMMXid(xid);
        try {
            return this.getMMConnection().prepareTransaction(mmXid);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedPrepareTXN", xid);
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        try {
            return this.getMMConnection().recoverTransaction(flag);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedRecoverTXN", flag);
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        XidImpl mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().rollbackTransaction(mmXid);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedRollbackTXN", xid);
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.timeOut = seconds;
        return true;
    }

    @Override
    public void start(Xid xid, int flag) throws XAException {
        XidImpl mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().startTransaction(mmXid, flag, this.timeOut);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedStartTXN", xid, new Integer(flag));
            this.handleError(e, logMsg);
        }
    }

    private ConnectionImpl getMMConnection() throws XAException {
        try {
            return this.getConnectionImpl();
        }
        catch (SQLException e) {
            throw new XAException(-7);
        }
    }

    private XidImpl getMMXid(Xid originalXid) {
        return new XidImpl(originalXid);
    }

    private final class CloseInterceptor
    implements InvocationHandler {
        private ConnectionImpl proxiedConnection;

        CloseInterceptor(ConnectionImpl connection) {
            this.proxiedConnection = connection;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("close".equals(method.getName())) {
                this.close();
                return null;
            }
            try {
                return method.invoke((Object)this.proxiedConnection, args);
            }
            catch (InvocationTargetException e) {
                ServerConnection sc;
                Exception ex = ExceptionUtil.getExceptionOfType(e, InvalidSessionException.class);
                if (ex == null && (ex = (Exception)ExceptionUtil.getExceptionOfType(e, CommunicationException.class)) instanceof SingleInstanceCommunicationException && !(sc = this.proxiedConnection.getServerConnection()).isOpen(120000L)) {
                    ex = null;
                }
                if (ex != null) {
                    SQLException se = null;
                    se = e.getCause() instanceof SQLException ? (SQLException)e.getCause() : TeiidSQLException.create(e.getCause());
                    XAConnectionImpl.this.notifyListener(se);
                }
                throw e.getTargetException();
            }
        }

        void close() {
            this.proxiedConnection.recycleConnection();
            XAConnectionImpl.this.notifyListener(null);
        }
    }
}

