/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.core.util.Assertion;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.DerivedExpression;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Symbol;

public class AliasSymbol
extends Symbol
implements DerivedExpression {
    private Expression symbol;

    private AliasSymbol(String name, String canonicalName, Expression symbol) {
        super(name);
        this.setSymbol(symbol);
    }

    public AliasSymbol(String name, Expression symbol) {
        super(name);
        this.setSymbol(symbol);
    }

    public Expression getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Expression symbol) {
        if (symbol instanceof AliasSymbol || symbol == null) {
            Assertion.failed(QueryPlugin.Util.getString("ERR.015.010.0029"));
        }
        this.symbol = symbol;
    }

    @Override
    public Class<?> getType() {
        return this.symbol.getType();
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        Expression symbolCopy = (Expression)this.symbol.clone();
        AliasSymbol result = new AliasSymbol(this.getName(), this.getShortName(), symbolCopy);
        result.outputName = this.outputName;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AliasSymbol)) {
            return false;
        }
        AliasSymbol other = (AliasSymbol)obj;
        return this.getName().equals(other.getName()) && this.symbol.equals(other.symbol);
    }
}

