/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.List;
import java.util.NavigableMap;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.dqp.internal.process.RecordTable;
import org.teiid.dqp.internal.process.SchemaRecordTable;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.tempdata.BaseIndexInfo;

abstract class SchemaChildRecordTable<T extends AbstractMetadataRecord>
extends RecordTable<T> {
    private SchemaRecordTable schemaTable;

    public SchemaChildRecordTable(int schemaPkColumnIndex, int tablePkColumnIndex, List<ElementSymbol> columns) {
        super(new int[]{0}, columns.subList(tablePkColumnIndex, tablePkColumnIndex + 1));
        this.schemaTable = new SchemaRecordTable(schemaPkColumnIndex, columns);
    }

    @Override
    public RecordTable.SimpleIterator<T> processQuery(final VDBMetaData vdb, CompositeMetadataStore metadataStore, final BaseIndexInfo<?> ii) {
        RecordTable.SimpleIterator schemas = this.schemaTable.processQuery(vdb, metadataStore.getSchemas(), ii);
        return new RecordTable.ExpandingSimpleIterator<Schema, T>(schemas){

            @Override
            protected RecordTable.SimpleIterator<T> getChildIterator(Schema parent) {
                return SchemaChildRecordTable.this.processQuery(vdb, SchemaChildRecordTable.this.getChildren(parent), ii.next);
            }
        };
    }

    @Override
    public BaseIndexInfo<RecordTable<?>> planQuery(Query query, Criteria condition) {
        BaseIndexInfo<RecordTable<?>> ii = this.schemaTable.planQuery(query, query.getCriteria());
        ii.next = super.planQuery(query, ii.getNonCoveredCriteria());
        return ii;
    }

    @Override
    protected void fillRow(T s, List<Object> rowBuffer) {
        rowBuffer.add(s.getName());
    }

    protected abstract NavigableMap<String, T> getChildren(Schema var1);
}

