/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.client.security.ILogon;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.TeiidComponentException;
import org.teiid.net.CommunicationException;
import org.teiid.net.HostInfo;
import org.teiid.net.socket.Handshake;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.net.socket.ObjectChannelFactory;
import org.teiid.net.socket.SocketServerInstanceImpl;

public class TestSocketServerInstanceImpl {
    @Test
    public void testHandshakeTimeout() throws Exception {
        Object[] exs = new SocketTimeoutException[10];
        Arrays.fill(exs, new SocketTimeoutException());
        FakeObjectChannel channel = new FakeObjectChannel(Arrays.asList(exs));
        try {
            this.createInstance(channel);
            Assert.fail((String)"Exception expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private SocketServerInstanceImpl createInstance(ObjectChannelFactory channelFactory) throws CommunicationException, IOException {
        HostInfo info = new HostInfo("0.0.0.0", 1);
        SocketServerInstanceImpl ssii = new SocketServerInstanceImpl(info, 1L);
        ssii.connect(channelFactory);
        return ssii;
    }

    @Test
    public void testSuccessfulHandshake() throws Exception {
        FakeObjectChannel channel = new FakeObjectChannel(Arrays.asList(new Handshake(), new SocketTimeoutException()));
        SocketServerInstanceImpl instance = this.createInstance(channel);
        ILogon logon = (ILogon)instance.getService(ILogon.class);
        try {
            logon.logon(new Properties());
            Assert.fail((String)"Exception expected");
        }
        catch (TeiidComponentException e) {
            Assert.assertTrue((boolean)(e.getCause().getCause() instanceof TimeoutException));
        }
    }

    private static class FakeObjectChannel
    implements ObjectChannel,
    ObjectChannelFactory {
        List<Object> msgs = new ArrayList<Object>();
        List<? extends Object> readMsgs;
        int readCount;

        public FakeObjectChannel(List<? extends Object> readMsgs) {
            this.readMsgs = readMsgs;
        }

        public void close() {
        }

        public boolean isOpen() {
            return true;
        }

        public Future<?> write(Object msg) {
            this.msgs.add(msg);
            ResultsFuture result = new ResultsFuture();
            result.getResultsReceiver().receiveResults(null);
            return result;
        }

        public Object read() throws IOException, ClassNotFoundException {
            Object msg;
            if (this.readCount >= this.readMsgs.size()) {
                return "";
            }
            if ((msg = this.readMsgs.get(this.readCount++)) instanceof IOException) {
                if (msg instanceof SocketTimeoutException) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw (IOException)msg;
            }
            return msg;
        }

        public SocketAddress getRemoteAddress() {
            return null;
        }

        public ObjectChannel createObjectChannel(SocketAddress address, boolean ssl) throws IOException, CommunicationException {
            return this;
        }

        public int getSoTimeout() {
            return 1;
        }

        public InetAddress getLocalAddress() {
            return null;
        }
    }
}

