/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.transaction;

import java.util.Random;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.teiid.client.xa.XidImpl;
import org.teiid.test.framework.TransactionContainer;
import org.teiid.test.framework.TransactionQueryTestCase;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class StandaloneGlobalTransaction
extends TransactionContainer {
    private static Random RANDOM = new Random();
    private XidImpl xid;

    @Override
    protected void before(TransactionQueryTestCase test) {
        try {
            this.xid = StandaloneGlobalTransaction.createXid();
            XAResource xaResource = test.getConnectionStrategy().getXAConnection().getXAResource();
            xaResource.setTransactionTimeout(120);
            xaResource.start((Xid)this.xid, 0);
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
    }

    public static XidImpl createXid() {
        byte[] gid = new byte[10];
        byte[] bid = new byte[10];
        RANDOM.nextBytes(gid);
        RANDOM.nextBytes(bid);
        return new XidImpl(0, gid, bid);
    }

    @Override
    protected void after(TransactionQueryTestCase test) {
        boolean delistSuccessful = false;
        boolean commit = false;
        try {
            XAResource xaResource = test.getConnectionStrategy().getXAConnection().getXAResource();
            xaResource.end((Xid)this.xid, 0x4000000);
            if (!test.exceptionExpected() && xaResource.prepare((Xid)this.xid) == 0) {
                commit = true;
            }
            delistSuccessful = true;
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
        finally {
            try {
                if (!delistSuccessful || test.rollbackAllways() || test.exceptionOccurred()) {
                    test.getConnectionStrategy().getXAConnection().getXAResource().rollback((Xid)this.xid);
                } else if (commit) {
                    test.getConnectionStrategy().getXAConnection().getXAResource().commit((Xid)this.xid, true);
                }
            }
            catch (Exception e) {
                throw new TransactionRuntimeException(e);
            }
        }
    }
}

