/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.util.List;
import java.util.Properties;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminFactory;
import org.teiid.adminapi.VDB;

public class AdminUtil {
    static void cleanUp(Admin admin) throws AdminException {
        for (VDB vdb : admin.getVDBs()) {
            String deploymentName = vdb.getPropertyValue("deployment-name");
            if (deploymentName == null) continue;
            admin.undeploy(deploymentName);
        }
    }

    static boolean createDataSource(Admin admin, String deploymentName, String templateName, Properties properties) throws AdminException {
        if (admin.getDataSourceNames().contains(deploymentName)) {
            return false;
        }
        admin.createDataSource(deploymentName, templateName, properties);
        return true;
    }

    static boolean waitForVDBLoad(Admin admin, String vdbName, int vdbVersion, int timeoutInSecs) throws AdminException {
        long waitUntil = System.currentTimeMillis() + (long)(timeoutInSecs * 1000);
        if (timeoutInSecs < 0) {
            waitUntil = Long.MAX_VALUE;
        }
        boolean first = true;
        do {
            block5: {
                if (!first) {
                    try {
                        Thread.sleep(2000L);
                        break block5;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                first = false;
            }
            VDB vdb = admin.getVDB(vdbName, vdbVersion);
            if (vdb == null || vdb.getStatus() == VDB.Status.LOADING) continue;
            return true;
        } while (System.currentTimeMillis() < waitUntil);
        return false;
    }

    static boolean waitForDeployment(Admin admin, String deploymentName, int timeoutInSecs) {
        long waitUntil = System.currentTimeMillis() + (long)(timeoutInSecs * 1000);
        if (timeoutInSecs < 0) {
            waitUntil = Long.MAX_VALUE;
        }
        boolean first = true;
        do {
            block5: {
                if (!first) {
                    try {
                        Thread.sleep(2000L);
                        break block5;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                first = false;
            }
            List deployments = ((AdminFactory.AdminImpl)admin).getDeployments();
            if (!deployments.contains(deploymentName)) continue;
            return true;
        } while (System.currentTimeMillis() < waitUntil);
        return false;
    }
}

