/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.language.Array;
import org.teiid.language.Comparison;
import org.teiid.language.Parameter;
import org.teiid.language.Select;
import org.teiid.language.WithItem;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.FakeTupleSource;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.ExecutionFactory;

public class TestDependentJoins {
    static ProcessorPlan helpGetPlan(String sql) {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)2);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        return plan;
    }

    @Test
    public void testMultiCritDepJoin1() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm1.g1.e1=pm2.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDependentView() {
        String sql = "SELECT v.e1 FROM (select distinct e1 from pm1.g1) as v, pm2.g1 WHERE v.e1=pm2.g1.e1 order by v.e1 option makedep v";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDependentView1() {
        String sql = "SELECT v.e1 FROM (select distinct e1 from pm1.g1) as v, pm2.g1 WHERE v.e1=pm2.g1.e1 order by v.e1 option makedep v";
        List[] expected = new List[]{Arrays.asList("a")};
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        dataManager.addData("SELECT g_0.e1 AS c_0 FROM g1 AS g_0 ORDER BY c_0", Arrays.asList("a"));
        dataManager.addData("SELECT v_0.c_0 FROM (SELECT DISTINCT g_0.e1 AS c_0 FROM g1 AS g_0) AS v_0 WHERE v_0.c_0 = 'a'", Arrays.asList("a"));
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps));
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin2() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm2.g1.e1=pm1.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestDependentJoins.helpGetPlan(sql);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin2a() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm2.g1.e1=pm1.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.ARRAY_TYPE, true);
        ProcessorPlan plan = TestDependentJoins.helpGetPlan(sql);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin3() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm2.g1.e1=pm1.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin4() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm2.g1.e1=pm1.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin5() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE concat(pm1.g1.e1, 'a') = concat(pm2.g1.e1, 'a') AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin5a() {
        String sql = "SELECT X.e1 FROM pm1.g1 as X, pm2.g1 WHERE concat(X.e1, 'a') = concat(pm2.g1.e1, 'a') AND X.e2=pm2.g1.e2 order by x.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin5b() {
        String sql = "SELECT X.e1, X.e2 FROM pm1.g1 as X, pm2.g1 WHERE concat(X.e1, convert(X.e4, string)) = concat(pm2.g1.e1, convert(pm2.g1.e4, string)) AND X.e2=pm2.g1.e2 order by x.e1, x.e2 option makedep x";
        List[] expected = new List[]{Arrays.asList("a", 0), Arrays.asList("a", 0), Arrays.asList("a", 0), Arrays.asList("a", 0), Arrays.asList("a", 3), Arrays.asList("b", 2)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin6() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm1.g1.e1 = concat(pm2.g1.e1, '') AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin7() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE concat(pm1.g1.e1, '') = pm2.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin8() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm1.g1.e1 = pm2.g1.e1 AND pm1.g1.e2 <> pm2.g1.e2 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestDependentJoins.helpGetPlan(sql);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin9() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm1.g1.e2 <> pm2.g1.e2 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList(new Object[]{null}), Arrays.asList(new Object[]{null}), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("c"), Arrays.asList("c"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("b"), Arrays.asList("b"), Arrays.asList("b"), Arrays.asList("b"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin10() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm1.g1.e3=pm2.g1.e3 AND pm1.g1.e2=pm2.g1.e2 AND pm2.g1.e1 = 'a' option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testLargeSetInDepJoinWAccessPatternCausingSortNodeInsertCanHandleAlias() {
        this.helpTestDepAccessCausingSortNodeInsert(true);
    }

    @Test
    public void testLargeSetInDepJoinWAccessPatternCausingSortNodeInsertCannotHandleAlias() {
        this.helpTestDepAccessCausingSortNodeInsert(false);
    }

    public void helpTestDepAccessCausingSortNodeInsert(boolean accessNodeHandlesAliases) {
        String sql = "SELECT a.e1, b.e1, b.e2 FROM pm4.g1 a INNER JOIN pm1.g1 b ON a.e2=b.e2 AND a.e1 = b.e1 OPTION MAKEDEP a";
        List[] expected = new List[]{Arrays.asList("aa ", "aa ", 0), Arrays.asList("bb   ", "bb   ", 1), Arrays.asList("cc  ", "cc  ", 2)};
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities depcaps = new BasicSourceCapabilities();
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)1);
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        if (accessNodeHandlesAliases) {
            depcaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        }
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("pm4", (SourceCapabilities)depcaps);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata fakeMetadata = RealMetadataFactory.example1Cached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)fakeMetadata, (CapabilitiesFinder)capFinder);
        Assert.assertTrue((boolean)(plan instanceof RelationalPlan));
        RelationalPlan relationalPlan = (RelationalPlan)plan;
        RelationalNode project = relationalPlan.getRootNode();
        RelationalNode join = project.getChildren()[0];
        Assert.assertTrue((String)("Expected instance of JoinNode (for dep join) but got " + join.getClass()), (boolean)(join instanceof JoinNode));
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData2b(dataManager, (QueryMetadataInterface)fakeMetadata);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase5130() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        String sql = "select a.intkey from bqt1.smalla a, bqt1.smallb b where concat(a.stringkey, 't') = b.stringkey option makedep a";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT a.stringkey, a.intkey FROM bqt1.smalla AS a", "SELECT b.stringkey FROM bqt1.smallb AS b"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 1, 0, 0});
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.StringKey FROM BQT1.SmallB AS g_0", Arrays.asList("1t"), Arrays.asList("2"));
        dataManager.addData("SELECT g_0.StringKey, g_0.IntKey FROM BQT1.SmallA AS g_0", Arrays.asList("1", 1));
        List[] expected = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase5130a() throws Exception {
        this.helpTestDependentJoin(false);
    }

    @Test
    public void testUnlimitedIn() throws Exception {
        this.helpTestDependentJoin(true);
    }

    private HardcodedDataManager helpTestDependentJoin(boolean unlimitIn) throws TeiidComponentException, TeiidProcessingException {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        if (unlimitIn) {
            caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)-1);
        }
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        String sql = "select a.intkey from bqt1.smalla a, bqt2.smallb b where concat(a.stringkey, 't') = b.stringkey and a.intkey = b.intkey option makedep a";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.StringKey, g_0.IntKey FROM BQT1.SmallA AS g_0 WHERE g_0.IntKey IN (<dependent values>)", "SELECT g_0.StringKey, g_0.IntKey FROM BQT2.SmallB AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 2, 1, 0, 0});
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.StringKey, g_0.IntKey FROM BQT2.SmallB AS g_0", Arrays.asList("1t", 1), Arrays.asList("2t", 2));
        dataManager.addData("SELECT g_0.StringKey, g_0.IntKey FROM BQT1.SmallA AS g_0 WHERE g_0.IntKey IN (1, 2)", Arrays.asList("1", 1));
        List[] expected = new List[]{Arrays.asList(1)};
        TestProcessor.helpProcess(plan, dataManager, expected);
        return dataManager;
    }

    static void sampleData4(FakeDataManager dataMgr) throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "pm1.g1", new List[]{Arrays.asList("a", 0, Boolean.FALSE, new Double(2.0)), Arrays.asList("q", null, Boolean.FALSE, new Double(0.0)), Arrays.asList("b", 1, Boolean.TRUE, null), Arrays.asList("c", 2, Boolean.FALSE, new Double(0.0))});
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "pm6.g1", new List[]{Arrays.asList("b", 1), Arrays.asList("d", 3), Arrays.asList("e", 1)});
    }

    @Test
    public void testLargeSetInDepAccess() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm6.g1 WHERE pm1.g1.e1=pm6.g1.e1 OPTION MAKEDEP pm6.g1";
        FakeDataManager dataManager = new FakeDataManager();
        TestDependentJoins.sampleData4(dataManager);
        TransformationMetadata fakeMetadata = RealMetadataFactory.example1Cached();
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities depcaps = new BasicSourceCapabilities();
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)1);
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm6", (SourceCapabilities)depcaps);
        List[] expected = new List[]{Arrays.asList(new String("b"))};
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)fakeMetadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testLargeSetInDepAccessMultiJoinCriteria() throws Exception {
        this.helpTestLargeSetInDepAccessMultiJoinCriteria(1, -1, 1, 2);
    }

    @Test
    public void testLargeSetInDepAccessMultiJoinCriteriaSetConstraint() throws Exception {
        this.helpTestLargeSetInDepAccessMultiJoinCriteria(1, 1, 1, 2);
    }

    @Test
    public void testLargeSetInDepAccessMultiJoinCriteriaConcurrent() throws Exception {
        this.helpTestLargeSetInDepAccessMultiJoinCriteria(1, -1, 4, 4);
    }

    @Test
    public void testLargeSetInDepAccessMultiJoinCriteriaCompound() throws Exception {
        this.helpTestLargeSetInDepAccessMultiJoinCriteria(1, 4, 3, 3);
    }

    @Test
    public void testLargeSetInDepAccessMultiJoinCriteriaCompoundAll() throws Exception {
        this.helpTestLargeSetInDepAccessMultiJoinCriteria(1, 10, 2, 2);
    }

    @Test
    public void testLargeSetMultipleDependentSources() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 makedep, /*+ makeind */ pm1.g2 where pm1.g1.e1=pm2.g1.e1 AND pm1.g2.e2=pm2.g1.e2 order by e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities depcaps = new BasicSourceCapabilities();
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)1);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_DEPENDENT_PREDICATES, (Object)3);
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)depcaps);
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a")};
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT pm1.g2.e2 FROM pm1.g2", "SELECT pm2.g1.e1, pm2.g1.e2 FROM pm2.g1 WHERE (pm2.g1.e1 IN (<dependent values>)) AND (pm2.g1.e2 IN (<dependent values>))", "SELECT pm1.g1.e1 FROM pm1.g1"}, plan);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1 FROM pm1.g1", Arrays.asList("a"));
        dataManager.addData("SELECT pm1.g2.e2 FROM pm1.g2", Arrays.asList(1), Arrays.asList(2), Arrays.asList(3));
        dataManager.addData("SELECT pm2.g1.e1, pm2.g1.e2 FROM pm2.g1 WHERE (pm2.g1.e1 = 'a') AND ((pm2.g1.e2 = 1) OR (pm2.g1.e2 = 2))", Arrays.asList("a", 1));
        dataManager.addData("SELECT pm2.g1.e1, pm2.g1.e2 FROM pm2.g1 WHERE (pm2.g1.e1 = 'a') AND (pm2.g1.e2 = 3)", Arrays.asList("a", 3));
        CommandContext cc = TestProcessor.createCommandContext();
        TestProcessor.helpProcess(plan, cc, dataManager, expected);
    }

    public void helpTestLargeSetInDepAccessMultiJoinCriteria(int maxInSize, int maxPredicates, int maxConcurrency, int concurrentOpen) throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM (pm1.g2 cross join pm1.g1) inner join pm2.g1 makedep ON pm1.g1.e1=pm2.g1.e1 AND pm1.g1.e2=pm2.g1.e2 AND pm1.g2.e4 = pm2.g1.e4 order by e1";
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities depcaps = new BasicSourceCapabilities();
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)maxInSize);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_DEPENDENT_PREDICATES, (Object)maxPredicates);
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)depcaps);
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b")};
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT pm1.g2.e4 FROM pm1.g2", "SELECT pm2.g1.e1, pm2.g1.e2, pm2.g1.e4 FROM pm2.g1 WHERE (pm2.g1.e1 IN (<dependent values>)) AND (pm2.g1.e2 IN (<dependent values>)) AND (pm2.g1.e4 IN (<dependent values>))", "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1"}, plan);
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setUserRequestSourceConcurrency(maxConcurrency);
        FakeTupleSource.resetStats();
        TestProcessor.helpProcess(plan, cc, dataManager, expected);
        Assert.assertEquals((String)"Wrong number of concurrent source queries", (long)concurrentOpen, (long)FakeTupleSource.maxOpen);
    }

    @Test
    public void testLargeSetInDepAccessWithAccessPattern() {
        String sql = "SELECT a.e1, b.e1, b.e2 FROM pm4.g1 a INNER JOIN pm1.g1 b ON a.e1=b.e1 AND a.e2 = b.e2";
        List[] expected = new List[]{Arrays.asList("aa ", "aa ", 0), Arrays.asList("bb   ", "bb   ", 1), Arrays.asList("cc  ", "cc  ", 2)};
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities depcaps = new BasicSourceCapabilities();
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)1);
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("pm4", (SourceCapabilities)depcaps);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata fakeMetadata = RealMetadataFactory.example1Cached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)fakeMetadata, (CapabilitiesFinder)capFinder);
        Assert.assertTrue((boolean)(plan instanceof RelationalPlan));
        RelationalPlan relationalPlan = (RelationalPlan)plan;
        RelationalNode project = relationalPlan.getRootNode();
        RelationalNode join = project.getChildren()[0];
        Assert.assertTrue((String)("Expected instance of JoinNode (for dep join) but got " + join.getClass()), (boolean)(join instanceof JoinNode));
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData2b(dataManager, (QueryMetadataInterface)fakeMetadata);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDependentNoRows() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2 WHERE pm1.g1.e1 = pm1.g2.e1 AND pm1.g1.e2 = -100 OPTION MAKEDEP pm1.g2";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testExpressionInDepJoin() {
        String sql = "SELECT pm1.g1.e2, pm2.g1.e2 FROM pm1.g1, pm2.g1 WHERE (pm1.g1.e2+1)=pm2.g1.e2 order by pm1.g1.e2, pm2.g1.e2 OPTION MAKEDEP pm2.g1";
        List[] expected = new List[]{Arrays.asList(0, 1), Arrays.asList(0, 1), Arrays.asList(0, 1), Arrays.asList(0, 1), Arrays.asList(1, 2), Arrays.asList(1, 2), Arrays.asList(2, 3)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)1000);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDependentJoinBackoff() throws Exception {
        FakeDataManager dataManager = this.helpTestBackoff(true);
        Assert.assertEquals(new HashSet<String>(Arrays.asList("SELECT pm6.g1.e1, pm6.g1.e2 FROM pm6.g1 ORDER BY pm6.g1.e1, pm6.g1.e2", "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1")), new HashSet<String>(dataManager.getQueries()));
    }

    @Test
    public void testDependentJoinBackoff1() throws Exception {
        FakeDataManager dataManager = this.helpTestBackoff(false);
        Assert.assertEquals((long)4L, (long)new HashSet<String>(dataManager.getQueries()).size());
    }

    @Test
    public void testIssue1899() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm3.g1 WHERE pm1.g1.e1=pm3.g1.e1";
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm3.g1.e1 FROM pm3.g1 ORDER BY pm3.g1.e1", Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c"));
        dataManager.addData("SELECT pm1.g1.e1 FROM pm1.g1", Arrays.asList("a"));
        TransformationMetadata fakeMetadata = RealMetadataFactory.example4();
        fakeMetadata.getGroupID("pm1.g1").getAccessPatterns().clear();
        RealMetadataFactory.setCardinality("pm1.g1", 1000, (QueryMetadataInterface)fakeMetadata);
        fakeMetadata.getElementID("pm1.g1.e1").setDistinctValues(40);
        RealMetadataFactory.setCardinality("pm3.g1", 1, (QueryMetadataInterface)fakeMetadata);
        fakeMetadata.getElementID("pm3.g1.e1").setDistinctValues(1);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities depcaps = new BasicSourceCapabilities();
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        depcaps.setSourceProperty(SourceCapabilities.Capability.QUERY_ORDERBY_DEFAULT_NULL_ORDER, (Object)ExecutionFactory.NullOrder.HIGH);
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setSourceProperty(SourceCapabilities.Capability.QUERY_ORDERBY_DEFAULT_NULL_ORDER, (Object)ExecutionFactory.NullOrder.HIGH);
        capFinder.addCapabilities("pm3", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm1", (SourceCapabilities)depcaps);
        List[] expected = new List[]{Arrays.asList(new String("a"))};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)fakeMetadata, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1 WHERE pm1.g1.e1 IN (<dependent values>)", "SELECT pm3.g1.e1 FROM pm3.g1 ORDER BY pm3.g1.e1"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    private FakeDataManager helpTestBackoff(boolean setNdv) throws Exception, QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm6.g1 WHERE pm1.g1.e1=pm6.g1.e1 and pm1.g1.e2=pm6.g1.e2";
        FakeDataManager dataManager = new FakeDataManager();
        TestDependentJoins.sampleData4(dataManager);
        TransformationMetadata fakeMetadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", 1, (QueryMetadataInterface)fakeMetadata);
        if (setNdv) {
            fakeMetadata.getElementID("pm1.g1.e1").setDistinctValues(1);
            fakeMetadata.getElementID("pm1.g1.e2").setDistinctValues(1);
        }
        RealMetadataFactory.setCardinality("pm6.g1", 1000, (QueryMetadataInterface)fakeMetadata);
        if (setNdv) {
            fakeMetadata.getElementID("pm6.g1.e1").setDistinctValues(1000);
            fakeMetadata.getElementID("pm6.g1.e2").setDistinctValues(1000);
        }
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities depcaps = new BasicSourceCapabilities();
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)1);
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm6", (SourceCapabilities)depcaps);
        List[] expected = new List[]{Arrays.asList(new String("b"))};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)fakeMetadata, new String[]{"SELECT pm6.g1.e1, pm6.g1.e2 FROM pm6.g1 WHERE (pm6.g1.e1 IN (<dependent values>)) AND (pm6.g1.e2 IN (<dependent values>)) ORDER BY pm6.g1.e1, pm6.g1.e2", "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestProcessor.helpProcess(plan, dataManager, expected);
        return dataManager;
    }

    @Test
    public void testDjHint() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1 WHERE e1 IN /*+ DJ */ (select e1 from pm2.g1) order by pm1.g1.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestOptimizer.checkDependentJoinCount(plan, 1);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMakeIndHint() {
        String sql = "SELECT pm1.g1.e1 FROM /*+ MAKEIND */ pm1.g1, pm2.g1 WHERE pm1.g1.e1 = pm2.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestOptimizer.checkDependentJoinCount(plan, 1);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMakeIndHintPushdown() {
        this.helpTestPushdown(true);
        this.helpTestPushdown(false);
    }

    private void helpTestPushdown(boolean supportsArrayType) {
        String sql = "SELECT pm1.g1.e1 FROM /*+ MAKEIND */ pm1.g1, pm2.g1 WHERE pm1.g1.e1 = pm2.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1";
        List[] expected = new List[]{Arrays.asList("a")};
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        dataManager.addData("SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM g1 AS g_0 ORDER BY c_0, c_1", Arrays.asList("a", 1), Arrays.asList("b", 2));
        if (supportsArrayType) {
            dataManager.addData("SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM g1 AS g_0 WHERE (g_0.e1, g_0.e2) = (?, ?) ORDER BY c_0, c_1", Arrays.asList("a", 1));
        } else {
            dataManager.addData("SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM g1 AS g_0 WHERE g_0.e1 = ? AND g_0.e2 = ? ORDER BY c_0, c_1", Arrays.asList("a", 1));
        }
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.DEPENDENT_JOIN, true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.ARRAY_TYPE, supportsArrayType);
        bsc.setSourceProperty(SourceCapabilities.Capability.MAX_DEPENDENT_PREDICATES, (Object)1);
        bsc.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)1);
        DefaultCapabilitiesFinder dcf = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)dcf);
        TestOptimizer.checkDependentJoinCount(plan, 1);
        TestProcessor.helpProcess(plan, dataManager, expected);
        Select s = (Select)dataManager.getPushdownCommands().get(1);
        Assert.assertEquals((long)1L, (long)s.getDependentValues().size());
        List vals = (List)s.getDependentValues().values().iterator().next();
        Assert.assertEquals((long)2L, (long)vals.size());
        if (supportsArrayType) {
            Comparison comp = (Comparison)s.getWhere();
            Parameter p = (Parameter)((Array)comp.getRightExpression()).getExpressions().get(0);
            Assert.assertEquals((long)0L, (long)p.getValueIndex());
            Assert.assertNotNull(s.getDependentValues().get(p.getDependentValueId()));
        }
    }

    @Test
    public void testIndependentDupRemoval1() {
        String sql = "SELECT pm1.g1.e1, pm1.g1.e2, x.e2 FROM pm1.g1, pm2.g2, /*+ makeind */ (select distinct e1, e2 from pm2.g1) x WHERE x.e1=pm1.g1.e1 AND pm2.g2.e2=x.e2";
        List[] expected = new List[]{Arrays.asList("a", 1, 1), Arrays.asList("b", 1, 1)};
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, false);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)1);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_DEPENDENT_PREDICATES, (Object)1);
        TransformationMetadata fakeMetadata = RealMetadataFactory.example1Cached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)fakeMetadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps));
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT DISTINCT g_0.e1, g_0.e2 FROM pm2.g1 AS g_0", Arrays.asList("b", 1), Arrays.asList("a", 1));
        dataManager.addData("SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0 WHERE g_0.e1 = 'b'", Arrays.asList("b", 1));
        dataManager.addData("SELECT g_0.e2 FROM pm2.g2 AS g_0 WHERE g_0.e2 = 1", Arrays.asList(1));
        dataManager.addData("SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0 WHERE g_0.e1 = 'a'", Arrays.asList("a", 1));
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testIndependentDupRemoval() {
        String sql = "SELECT pm1.g1.e1, pm1.g1.e2, pm2.g1.e2 FROM pm1.g1, pm2.g1 WHERE pm2.g1.e1=pm1.g1.e1 AND pm1.g1.e2<pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a", 0, 3), Arrays.asList("a", 0, 3)};
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)1);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_DEPENDENT_PREDICATES, (Object)1);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        TransformationMetadata fakeMetadata = RealMetadataFactory.example1Cached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)fakeMetadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps));
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testPushdownMax() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 MAKEDEP(max:2) WHERE pm1.g1.e1 = pm2.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        dataManager.addData("SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM g1 AS g_0 ORDER BY c_0, c_1", Arrays.asList("a", 1), Arrays.asList("b", 1), Arrays.asList("c", 1));
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.DEPENDENT_JOIN, true);
        DefaultCapabilitiesFinder dcf = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)dcf);
        TestOptimizer.checkDependentJoinCount(plan, 1);
        TestProcessor.helpProcess(plan, dataManager, expected);
        Select s = (Select)dataManager.getPushdownCommands().get(1);
        Assert.assertNull((Object)s.getDependentValues());
    }

    @Test
    public void testFullDepJoin() throws Exception {
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.FULL_DEPENDENT_JOIN, true);
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1, pm1.g1.e2, pm2.g1.e2 FROM pm1.g1, pm2.g1 where (pm1.g1.e1 = pm2.g1.e1) option makedep pm1.g1(join)", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"WITH TEIID_TEMP__1 (col1, col2) AS (<dependent values>) SELECT g_0.e1, g_0.e2, g_1.col2 FROM pm1.g1 AS g_0, TEIID_TEMP__1 AS g_1 WHERE g_0.e1 = g_1.col1"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
        List[] expected = new List[]{Arrays.asList("a", 2, 1)};
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        dataManager.addData("SELECT g_0.e1, g_0.e2 FROM g1 AS g_0", Arrays.asList("a", 1));
        dataManager.addData("WITH TEIID_TEMP__1 (e1, e2) AS (?) SELECT g_0.e1, g_0.e2, g_1.col2 FROM g1 AS g_0, TEIID_TEMP__1 AS g_1 WHERE g_0.e1 = g_1.col1", Arrays.asList("a", 2, 1));
        TestProcessor.helpProcess(plan, dataManager, expected);
        Select select = (Select)dataManager.getPushdownCommands().get(1);
        List vals = ((WithItem)select.getWith().getItems().get(0)).getDependentValues();
        Assert.assertEquals((long)1L, (long)vals.size());
    }

    @Test
    public void testFullDepJoin1() throws Exception {
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.FULL_DEPENDENT_JOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, false);
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1, pm1.g1.e2, pm2.g1.e2 FROM pm1.g1, pm2.g1 where (pm1.g1.e1 = pm2.g1.e1) option makedep pm1.g1(join)", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm2.g1 AS g_0 ORDER BY c_0", "SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 WHERE g_0.e1 IN (<dependent values>) ORDER BY c_0"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        List[] expected = new List[]{Arrays.asList("a", 2, 1)};
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        dataManager.addData("SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM g1 AS g_0 ORDER BY c_0", Arrays.asList("a", 1));
        dataManager.addData("SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM g1 AS g_0 WHERE g_0.e1 = 'a' ORDER BY c_0", Arrays.asList("a", 2));
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testFullDepJoinOptimizer() throws Exception {
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.FULL_DEPENDENT_JOIN, true);
        String sql = "select pm1.g1.e1, pm1.g1.e2, pm2.g1.e2 FROM pm1.g1, pm2.g1 where (pm1.g1.e1 = pm2.g1.e1)";
        TransformationMetadata metadata = TestOptimizer.example1();
        RealMetadataFactory.setCardinality("pm1.g1", 100, (QueryMetadataInterface)metadata);
        metadata.getElementID("pm2.g1.e1").setDistinctValues(1000);
        RealMetadataFactory.setCardinality("pm2.g1", 1000, (QueryMetadataInterface)metadata);
        CommandContext cc = new CommandContext();
        cc.getOptions().setDependentJoinPushdownThreshold(3.0f);
        cc.setBufferManager(BufferManagerFactory.getStandaloneBufferManager());
        ProcessorPlan plan = TestOptimizer.getPlan(TestOptimizer.helpGetCommand(sql, (QueryMetadataInterface)metadata, null), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), null, true, cc);
        TestOptimizer.checkAtomicQueries(new String[]{"WITH TEIID_TEMP__1 (col1, col2) AS (<dependent values>) SELECT g_0.col1, g_0.col2, g_1.e2 FROM TEIID_TEMP__1 AS g_0, pm2.g1 AS g_1 WHERE g_0.col1 = g_1.e1"}, plan);
        List[] expected = new List[]{Arrays.asList("a", 2, 1)};
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        dataManager.addData("SELECT g_0.e1, g_0.e2 FROM g1 AS g_0", Arrays.asList("a", 1));
        dataManager.addData("WITH TEIID_TEMP__1 (e1, e2) AS (?) SELECT g_0.col1, g_0.col2, g_1.e2 FROM TEIID_TEMP__1 AS g_0, g1 AS g_1 WHERE g_0.col1 = g_1.e1", Arrays.asList("a", 2, 1));
        TestProcessor.helpProcess(plan, dataManager, expected);
        cc.getOptions().setDependentJoinPushdownThreshold(1.01f);
        plan = TestOptimizer.getPlan(TestOptimizer.helpGetCommand(sql, (QueryMetadataInterface)metadata, null), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), null, true, cc);
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0", "SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm2.g1 AS g_0 WHERE g_0.e1 IN (<dependent values>) ORDER BY c_0"}, plan);
    }
}

