/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.jdbc.BaseDataSource;
import org.teiid.jdbc.TeiidDataSource;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.connection.ConnectionStrategy;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class DataSourceConnection
extends ConnectionStrategy {
    public static final String DS_USER = "user";
    public static final String DS_USERNAME = "User";
    public static final String DS_PASSWORD = "Password";
    public static final String DS_DRIVER = "driver";
    public static final String DS_DATASOURCE = "datasource";
    public static final String DS_SERVERNAME = "ServerName";
    public static final String DS_SERVERPORT = "PortNumber";
    public static final String DS_JNDINAME = "ds-jndiname";
    public static final String DS_DATABASENAME = "DatabaseName";
    public static final String DS_APPLICATION_NAME = "application-name";
    public static final String DS_URL = "URL";
    private String driver = null;
    private String username = null;
    private String pwd = null;
    private String applName = null;
    private String databaseName = null;
    private String serverName = null;
    private String portNumber = null;
    private String url = null;
    private XAConnection xaConnection;

    public DataSourceConnection(Properties props) throws QueryTestFailedException {
        super(props);
    }

    public void validate() {
        this.databaseName = this.getEnvironment().getProperty(DS_DATABASENAME);
        if (this.databaseName == null || this.databaseName.length() == 0) {
            throw new TransactionRuntimeException("Property DatabaseName was not specified");
        }
        this.serverName = this.getEnvironment().getProperty(DS_SERVERNAME);
        if (this.serverName == null || this.serverName.length() == 0) {
            throw new TransactionRuntimeException("Property ServerName was not specified");
        }
        this.portNumber = this.getEnvironment().getProperty(DS_SERVERPORT);
        this.applName = this.getEnvironment().getProperty(DS_APPLICATION_NAME);
        if (this.getEnvironment().getProperty(DS_DATASOURCE) != null) {
            this.driver = this.getEnvironment().getProperty(DS_DATASOURCE);
            if (this.driver == null || this.driver.length() == 0) {
                throw new TransactionRuntimeException("Property datasource was null");
            }
        } else {
            this.driver = this.getEnvironment().getProperty(DS_DRIVER);
            if (this.driver == null || this.driver.length() == 0) {
                throw new TransactionRuntimeException("Property driver was not specified");
            }
        }
        this.url = this.getEnvironment().getProperty(DS_URL);
        this.username = this.getEnvironment().getProperty(DS_USER);
        if (this.username == null) {
            this.username = this.getEnvironment().getProperty(DS_USERNAME);
        }
        this.pwd = this.getEnvironment().getProperty(DS_PASSWORD);
    }

    @Override
    public Connection getConnection() throws QueryTestFailedException {
        try {
            return this.getXAConnection().getConnection();
        }
        catch (QueryTestFailedException qtf) {
            throw qtf;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new QueryTestFailedException(e);
        }
    }

    @Override
    public synchronized XAConnection getXAConnection() throws QueryTestFailedException {
        if (this.xaConnection == null) {
            this.validate();
            try {
                this.xaConnection = this.createConnection();
            }
            catch (Exception e) {
                throw new QueryTestFailedException(e);
            }
        }
        return this.xaConnection;
    }

    private XAConnection createConnection() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        TestLogger.log("Creating Datasource Connection: \"" + this.serverName + " - " + this.databaseName + "\"");
        DataSource ds = (DataSource)Class.forName(this.driver).newInstance();
        if (ds instanceof BaseDataSource) {
            BaseDataSource dataSource = (BaseDataSource)ds;
            dataSource.setDatabaseName(this.databaseName);
            if (this.applName != null) {
                dataSource.setApplicationName(this.applName);
            }
            ((TeiidDataSource)dataSource).setServerName(this.serverName);
            ((TeiidDataSource)dataSource).setPortNumber(Integer.parseInt(this.portNumber));
            if (this.username != null) {
                dataSource.setUser(this.username);
                dataSource.setPassword(this.pwd);
            }
            return dataSource.getXAConnection(this.username, this.pwd);
        }
        Properties props = new Properties();
        props.setProperty(DS_DATABASENAME, this.databaseName);
        props.setProperty(DS_SERVERPORT, this.portNumber);
        props.setProperty(DS_URL, this.url);
        props.setProperty(DS_SERVERNAME, this.serverName);
        if (this.username != null) {
            props.setProperty(DS_USERNAME, this.username);
            props.setProperty(DS_USER, this.username);
            props.setProperty(DS_PASSWORD, this.pwd);
        }
        PropertiesUtils.setBeanProperties((Object)ds, (Properties)props, null);
        return ((XADataSource)((Object)ds)).getXAConnection();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        try {
            if (this.xaConnection != null) {
                this.xaConnection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xaConnection = null;
    }
}

