/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.UnresolvedSymbolDescription;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.StringUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.metadata.GroupInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.AccessPattern;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.AbstractCaseExpression;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;

public class ResolverUtil {
    private ResolverUtil() {
    }

    public static String getCommonType(String[] typeNames) {
        if (typeNames == null || typeNames.length == 0) {
            return null;
        }
        if (typeNames.length == 1) {
            return typeNames[0];
        }
        LinkedHashSet<String> commonConversions = null;
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        HashSet<String> conversions = null;
        boolean first = true;
        for (int i = 0; i < typeNames.length && (first || !commonConversions.isEmpty()); ++i) {
            String string = typeNames[i];
            if (string == null) {
                return null;
            }
            if ("null".equals(string) || !types.add(string)) continue;
            if (first) {
                commonConversions = new LinkedHashSet<String>();
                commonConversions.add(string);
                DataTypeManager.getImplicitConversions((String)string, commonConversions);
                first = false;
                continue;
            }
            if (conversions == null) {
                conversions = new HashSet<String>();
            }
            DataTypeManager.getImplicitConversions((String)string, conversions);
            conversions.add(string);
            commonConversions.retainAll(conversions);
            conversions.clear();
        }
        if (types.size() == 1) {
            return (String)types.iterator().next();
        }
        if (types.isEmpty()) {
            return "null";
        }
        for (String string : types) {
            if (!commonConversions.contains(string)) continue;
            return string;
        }
        commonConversions.remove("string");
        commonConversions.remove("object");
        if (!commonConversions.isEmpty()) {
            return (String)commonConversions.iterator().next();
        }
        return null;
    }

    public static boolean canImplicitlyConvert(String fromType, String toType) {
        if (fromType.equals(toType)) {
            return true;
        }
        return DataTypeManager.isImplicitConversion((String)fromType, (String)toType);
    }

    public static Expression convertExpression(Expression sourceExpression, String targetTypeName, QueryMetadataInterface metadata) throws QueryResolverException {
        return ResolverUtil.convertExpression(sourceExpression, DataTypeManager.getDataTypeName(sourceExpression.getType()), targetTypeName, metadata);
    }

    public static Expression convertExpression(Expression sourceExpression, String sourceTypeName, String targetTypeName, QueryMetadataInterface metadata) throws QueryResolverException {
        if (sourceTypeName.equals(targetTypeName)) {
            return sourceExpression;
        }
        if (ResolverUtil.canImplicitlyConvert(sourceTypeName, targetTypeName) || sourceExpression instanceof Constant && ResolverUtil.convertConstant(sourceTypeName, targetTypeName, (Constant)sourceExpression) != null) {
            return ResolverUtil.getConversion(sourceExpression, sourceTypeName, targetTypeName, true, metadata.getFunctionLibrary());
        }
        throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30082, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30082, new Object[]{targetTypeName, sourceExpression, sourceTypeName}));
    }

    public static Constant convertConstant(String sourceTypeName, String targetTypeName, Constant constant) {
        if (!DataTypeManager.isTransformable((String)sourceTypeName, (String)targetTypeName)) {
            return null;
        }
        try {
            Constant result = ResolverUtil.getProperlyTypedConstant(constant.getValue(), DataTypeManager.getDataTypeClass((String)targetTypeName));
            if ("string".equals(sourceTypeName)) {
                String value;
                if ("char".equals(targetTypeName) && (value = (String)constant.getValue()) != null && value.length() != 1) {
                    return null;
                }
                return result;
            }
            if (!DataTypeManager.isTransformable((String)targetTypeName, (String)sourceTypeName)) {
                return null;
            }
            if (!(constant.getValue() instanceof Comparable)) {
                return null;
            }
            Constant reverse = ResolverUtil.getProperlyTypedConstant(result.getValue(), constant.getType());
            if (((Comparable)constant.getValue()).compareTo(reverse.getValue()) == 0) {
                return result;
            }
        }
        catch (QueryResolverException queryResolverException) {
            // empty catch block
        }
        return null;
    }

    public static Function getConversion(Expression sourceExpression, String sourceTypeName, String targetTypeName, boolean implicit, FunctionLibrary library) {
        Class srcType = DataTypeManager.getDataTypeClass((String)sourceTypeName);
        Class targetType = DataTypeManager.getDataTypeClass((String)targetTypeName);
        try {
            ResolverUtil.setDesiredType(sourceExpression, targetType, sourceExpression);
        }
        catch (QueryResolverException e) {
            // empty catch block
        }
        FunctionDescriptor fd = library.findTypedConversionFunction(srcType, DataTypeManager.getDataTypeClass((String)targetTypeName));
        Function conversion = new Function(fd.getName(), new Expression[]{sourceExpression, new Constant(targetTypeName)});
        conversion.setType(DataTypeManager.getDataTypeClass((String)targetTypeName));
        conversion.setFunctionDescriptor(fd);
        if (implicit) {
            conversion.makeImplicit();
        }
        return conversion;
    }

    public static void setDesiredType(List<DerivedColumn> passing, LanguageObject obj) throws QueryResolverException {
        ResolverUtil.setDesiredType(passing, obj, DataTypeManager.DefaultDataClasses.XML);
    }

    public static void setDesiredType(List<DerivedColumn> passing, LanguageObject obj, Class<?> type) throws QueryResolverException {
        for (DerivedColumn dc : passing) {
            ResolverUtil.setDesiredType(dc.getExpression(), type, obj);
        }
    }

    public static void setDesiredType(Expression expression, Class<?> targetType, LanguageObject surroundingExpression) throws QueryResolverException {
        Function f;
        if (expression instanceof Reference) {
            Reference ref = (Reference)expression;
            if (ref.isPositional() && ref.getType() == null) {
                if (targetType == null) {
                    throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30083, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30083, new Object[]{surroundingExpression}));
                }
                ref.setType(targetType);
            }
        } else if (expression instanceof Function && (f = (Function)expression).getType() == null) {
            f.setType(targetType);
        }
    }

    public static void resolveOrderBy(OrderBy orderBy, QueryCommand command, TempMetadataAdapter metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        int i;
        List<Expression> knownElements = command.getProjectedQuery().getSelect().getProjectedSymbols();
        boolean isSimpleQuery = false;
        List<GroupSymbol> fromClauseGroups = Collections.emptyList();
        if (command instanceof Query) {
            Query query = (Query)command;
            boolean bl = isSimpleQuery = !query.getSelect().isDistinct() && !query.hasAggregates();
            if (query.getFrom() != null) {
                fromClauseGroups = query.getFrom().getGroups();
            }
        }
        String[] knownShortNames = new String[knownElements.size()];
        ArrayList<Expression> expressions = new ArrayList<Expression>(knownElements.size());
        for (i = 0; i < knownElements.size(); ++i) {
            String name;
            Expression knownSymbol = knownElements.get(i);
            expressions.add(SymbolMap.getExpression(knownSymbol));
            if (!(knownSymbol instanceof ElementSymbol) && !(knownSymbol instanceof AliasSymbol)) continue;
            knownShortNames[i] = name = ((Symbol)((Object)knownSymbol)).getShortName();
        }
        for (i = 0; i < orderBy.getVariableCount(); ++i) {
            Expression sortKey = orderBy.getVariable(i);
            if (sortKey instanceof ElementSymbol) {
                ElementSymbol symbol = (ElementSymbol)sortKey;
                String groupPart = null;
                if (symbol.getGroupSymbol() != null) {
                    groupPart = symbol.getGroupSymbol().getName();
                }
                String symbolName = symbol.getName();
                String shortName = symbol.getShortName();
                if (groupPart == null) {
                    int position = -1;
                    Expression matchedSymbol = null;
                    for (int j = 0; j < knownShortNames.length; ++j) {
                        if (!shortName.equalsIgnoreCase(knownShortNames[j])) continue;
                        if (matchedSymbol != null) {
                            if (matchedSymbol.equals(knownElements.get(j))) continue;
                            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30084, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30084, new Object[]{symbolName}));
                        }
                        matchedSymbol = knownElements.get(j);
                        position = j;
                    }
                    if (matchedSymbol != null) {
                        TempMetadataID tempMetadataID = new TempMetadataID(symbol.getName(), matchedSymbol.getType());
                        symbol.setMetadataID(tempMetadataID);
                        symbol.setType(matchedSymbol.getType());
                    }
                    if (position != -1) {
                        orderBy.setExpressionPosition(i, position);
                        continue;
                    }
                }
            } else if (sortKey instanceof Constant) {
                Constant c = (Constant)sortKey;
                int elementOrder = Integer.valueOf(c.getValue().toString());
                if (elementOrder > knownElements.size() || elementOrder < 1) {
                    throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30085, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30085, new Object[]{c}));
                }
                orderBy.setExpressionPosition(i, elementOrder - 1);
                continue;
            }
            if (command instanceof SetQuery) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30086, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30086, new Object[]{sortKey}));
            }
            for (SubqueryContainer<?> container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(sortKey)) {
                Object c = container.getCommand();
                QueryResolver.setChildMetadata(c, command);
                ((Command)c).pushNewResolvingContext(fromClauseGroups);
                QueryResolver.resolveCommand(c, metadata.getMetadata(), false);
            }
            for (ElementSymbol symbol : ElementCollectorVisitor.getElements((LanguageObject)sortKey, false)) {
                try {
                    ResolverVisitor.resolveLanguageObject(symbol, fromClauseGroups, command.getExternalGroupContexts(), metadata);
                }
                catch (QueryResolverException e) {
                    throw new QueryResolverException(QueryPlugin.Event.TEIID30087, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30087, new Object[]{symbol.getName()}));
                }
            }
            ResolverVisitor.resolveLanguageObject(sortKey, metadata);
            int index = expressions.indexOf(SymbolMap.getExpression(sortKey));
            if (index == -1 && !isSimpleQuery) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30088, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30088, new Object[]{sortKey}));
            }
            orderBy.setExpressionPosition(i, index);
        }
    }

    public static Expression getDefault(ElementSymbol symbol, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        Object mid = symbol.getMetadataID();
        Class<?> type = symbol.getType();
        Object defaultValue = metadata.getDefaultValue(mid);
        if (defaultValue == null && !metadata.elementSupports(mid, 4)) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30089, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30089, new Object[]{symbol.getOutputName()}));
        }
        return ResolverUtil.getProperlyTypedConstant(defaultValue, type);
    }

    public static boolean hasDefault(Object mid, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        Object defaultValue = metadata.getDefaultValue(mid);
        return defaultValue != null || metadata.elementSupports(mid, 4);
    }

    private static Constant getProperlyTypedConstant(Object defaultValue, Class<?> parameterType) throws QueryResolverException {
        try {
            Object newValue = DataTypeManager.transformValue((Object)defaultValue, parameterType);
            return new Constant(newValue, parameterType);
        }
        catch (TransformationException e) {
            throw new QueryResolverException(QueryPlugin.Event.TEIID30090, e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30090, new Object[]{defaultValue, defaultValue.getClass(), parameterType}));
        }
    }

    public static List<ElementSymbol> resolveElementsInGroup(GroupSymbol group, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        return new ArrayList<ElementSymbol>(ResolverUtil.getGroupInfo(group, metadata).getSymbolList());
    }

    public static void clearGroupInfo(GroupSymbol group, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        metadata.addToMetadataCache(group.getMetadataID(), "groupinfo/" + group.getName(), null);
    }

    static GroupInfo getGroupInfo(GroupSymbol group, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        String key = "groupinfo/" + group.getName();
        GroupInfo groupInfo = (GroupInfo)metadata.getFromMetadataCache(group.getMetadataID(), key);
        if (groupInfo == null) {
            group = group.clone();
            List elementIDs = metadata.getElementIDsInGroupID(group.getMetadataID());
            LinkedHashMap<Object, ElementSymbol> symbols = new LinkedHashMap<Object, ElementSymbol>(elementIDs.size());
            for (Object elementID : elementIDs) {
                String elementName = metadata.getName(elementID);
                ElementSymbol element = new ElementSymbol(elementName, group);
                element.setMetadataID(elementID);
                element.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(element.getMetadataID())));
                symbols.put(elementID, element);
            }
            groupInfo = new GroupInfo(symbols);
            metadata.addToMetadataCache(group.getMetadataID(), key, groupInfo);
        }
        return groupInfo;
    }

    public static List getAccessPatternElementsInGroups(QueryMetadataInterface metadata, Collection groups, boolean flatten) throws TeiidComponentException, QueryMetadataException {
        ArrayList<Cloneable> accessPatterns = null;
        for (GroupSymbol group : groups) {
            Collection accessPatternIDs = metadata.getAccessPatternsInGroup(group.getMetadataID());
            if (accessPatternIDs == null || accessPatternIDs.size() <= 0) continue;
            Iterator j = accessPatternIDs.iterator();
            if (accessPatterns == null) {
                accessPatterns = new ArrayList<Cloneable>();
            }
            while (j.hasNext()) {
                List elements = metadata.getElementIDsInAccessPattern(j.next());
                GroupInfo groupInfo = ResolverUtil.getGroupInfo(group, metadata);
                ArrayList<ElementSymbol> result = new ArrayList<ElementSymbol>(elements.size());
                for (Object id : elements) {
                    ElementSymbol symbol = groupInfo.getSymbol(id);
                    assert (symbol != null);
                    result.add(symbol);
                }
                if (flatten) {
                    accessPatterns.addAll(result);
                    continue;
                }
                accessPatterns.add(new AccessPattern(result));
            }
        }
        return accessPatterns;
    }

    public static void resolveLimit(Limit limit) throws QueryResolverException {
        if (limit.getOffset() != null) {
            ResolverUtil.setDesiredType(limit.getOffset(), DataTypeManager.DefaultDataClasses.INTEGER, limit);
        }
        ResolverUtil.setDesiredType(limit.getRowLimit(), DataTypeManager.DefaultDataClasses.INTEGER, limit);
    }

    public static void resolveImplicitTempGroup(TempMetadataAdapter metadata, GroupSymbol symbol, List symbols) throws TeiidComponentException, QueryResolverException {
        if (symbol.isImplicitTempGroupSymbol()) {
            if (metadata.getMetadataStore().getTempElementElementIDs(symbol.getName()) == null) {
                ResolverUtil.addTempGroup(metadata, symbol, symbols, true);
            }
            ResolverUtil.resolveGroup(symbol, metadata);
        }
    }

    public static TempMetadataID addTempGroup(TempMetadataAdapter metadata, GroupSymbol symbol, List<? extends Expression> symbols, boolean tempTable) throws QueryResolverException {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Expression expression : symbols) {
            if (names.add(Symbol.getShortName(expression))) continue;
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30091, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30091, new Object[]{symbol, Symbol.getShortName(expression)}));
        }
        if (tempTable) {
            ResolverUtil.resolveNullLiterals(symbols);
        }
        TempMetadataStore store = metadata.getMetadataStore();
        return store.addTempGroup(symbol.getName(), symbols, !tempTable, tempTable);
    }

    public static TempMetadataID addTempTable(TempMetadataAdapter metadata, GroupSymbol symbol, List<? extends Expression> symbols) throws QueryResolverException {
        return ResolverUtil.addTempGroup(metadata, symbol, symbols, true);
    }

    public static void resolveNullLiterals(List symbols) {
        for (int i = 0; i < symbols.size(); ++i) {
            Expression selectSymbol = (Expression)symbols.get(i);
            ResolverUtil.setTypeIfNull(selectSymbol, DataTypeManager.DefaultDataClasses.STRING);
        }
    }

    public static void setTypeIfNull(Expression symbol, Class<?> replacement) {
        if (!DataTypeManager.DefaultDataClasses.NULL.equals(symbol.getType()) && symbol.getType() != null) {
            return;
        }
        if ((symbol = SymbolMap.getExpression(symbol)) instanceof Constant) {
            ((Constant)symbol).setType(replacement);
        } else if (symbol instanceof AbstractCaseExpression) {
            ((AbstractCaseExpression)symbol).setType(replacement);
        } else if (symbol instanceof ScalarSubquery) {
            ((ScalarSubquery)symbol).setType(replacement);
        } else if (symbol instanceof ElementSymbol) {
            ElementSymbol elementSymbol = (ElementSymbol)symbol;
            elementSymbol.setType(replacement);
        } else {
            try {
                ResolverUtil.setDesiredType(symbol, replacement, symbol);
            }
            catch (QueryResolverException queryResolverException) {
                // empty catch block
            }
        }
    }

    public static List<GroupSymbol> findMatchingGroups(String groupContext, Collection<GroupSymbol> groups, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        if (groups == null) {
            return null;
        }
        LinkedList<GroupSymbol> matchedGroups = new LinkedList<GroupSymbol>();
        if (groupContext == null) {
            matchedGroups.addAll(groups);
        } else {
            for (GroupSymbol group : groups) {
                String actualVdbName;
                String fullName;
                if (!(ResolverUtil.nameMatchesGroup(groupContext, matchedGroups, group, fullName = group.getName()) ? groupContext.length() == fullName.length() : !(group.getMetadataID() instanceof TempMetadataID) && (actualVdbName = metadata.getVirtualDatabaseName()) != null && ResolverUtil.nameMatchesGroup(groupContext, matchedGroups, group, fullName = actualVdbName + "." + fullName) && groupContext.length() == fullName.length())) continue;
                return matchedGroups;
            }
        }
        return matchedGroups;
    }

    public static boolean nameMatchesGroup(String groupContext, String fullName) {
        int matchIndex;
        return StringUtil.endsWithIgnoreCase((String)fullName, (String)groupContext) && ((matchIndex = fullName.length() - groupContext.length()) == 0 || fullName.charAt(matchIndex - 1) == '.');
    }

    private static boolean nameMatchesGroup(String groupContext, LinkedList<GroupSymbol> matchedGroups, GroupSymbol group, String fullName) {
        if (ResolverUtil.nameMatchesGroup(groupContext, fullName)) {
            matchedGroups.add(group);
            return true;
        }
        return false;
    }

    static Expression resolveSubqueryPredicateCriteria(Expression expression, SubqueryContainer crit, QueryMetadataInterface metadata) throws QueryResolverException {
        Class<?> exprType = expression.getType();
        if (exprType == null) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30075, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30075, new Object[]{expression}));
        }
        String exprTypeName = DataTypeManager.getDataTypeName(exprType);
        List<Expression> projectedSymbols = ((Command)crit.getCommand()).getProjectedSymbols();
        if (projectedSymbols.size() != 1) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30093, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30093, new Object[]{crit.getCommand()}));
        }
        Class<?> subqueryType = ((Expression)projectedSymbols.iterator().next()).getType();
        String subqueryTypeName = DataTypeManager.getDataTypeName(subqueryType);
        Expression result = null;
        try {
            result = ResolverUtil.convertExpression(expression, exprTypeName, subqueryTypeName, metadata);
        }
        catch (QueryResolverException qre) {
            throw new QueryResolverException(QueryPlugin.Event.TEIID30094, (Throwable)((Object)qre), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30094, new Object[]{crit}));
        }
        return result;
    }

    public static ResolvedLookup resolveLookup(Function lookup, QueryMetadataInterface metadata) throws QueryResolverException, TeiidComponentException {
        Expression[] args = lookup.getArgs();
        ResolvedLookup result = new ResolvedLookup();
        if (!(args[0] instanceof Constant && args[1] instanceof Constant && args[2] instanceof Constant)) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30095, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30095, new Object[0]));
        }
        GroupSymbol groupSym = new GroupSymbol((String)((Constant)args[0]).getValue());
        try {
            groupSym.setMetadataID(metadata.getGroupID((String)((Constant)args[0]).getValue()));
            if (groupSym.getMetadataID() instanceof TempMetadataID) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30096, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30096, new Object[]{((Constant)args[0]).getValue()}));
            }
        }
        catch (QueryMetadataException e) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30097, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30097, new Object[]{((Constant)args[0]).getValue()}));
        }
        result.setGroup(groupSym);
        List<GroupSymbol> groups = Arrays.asList(groupSym);
        String returnElementName = (String)((Constant)args[0]).getValue() + "." + (String)((Constant)args[1]).getValue();
        ElementSymbol returnElement = new ElementSymbol(returnElementName);
        try {
            ResolverVisitor.resolveLanguageObject(returnElement, groups, metadata);
        }
        catch (QueryMetadataException e) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30098, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30098, new Object[]{returnElementName}));
        }
        result.setReturnElement(returnElement);
        String keyElementName = (String)((Constant)args[0]).getValue() + "." + (String)((Constant)args[2]).getValue();
        ElementSymbol keyElement = new ElementSymbol(keyElementName);
        try {
            ResolverVisitor.resolveLanguageObject(keyElement, groups, metadata);
        }
        catch (QueryMetadataException e) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30099, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30099, new Object[]{keyElementName}));
        }
        result.setKeyElement(keyElement);
        args[3] = ResolverUtil.convertExpression(args[3], DataTypeManager.getDataTypeName(keyElement.getType()), metadata);
        return result;
    }

    private static QueryResolverException handleUnresolvedGroup(GroupSymbol symbol, String description) {
        UnresolvedSymbolDescription usd = new UnresolvedSymbolDescription(symbol.toString(), description);
        QueryResolverException e = new QueryResolverException(usd.getDescription() + ": " + usd.getSymbol());
        e.setUnresolvedSymbols(Arrays.asList(usd));
        return e;
    }

    public static void resolveGroup(GroupSymbol symbol, QueryMetadataInterface metadata) throws TeiidComponentException, QueryResolverException {
        String[] parts;
        if (symbol.getMetadataID() != null) {
            return;
        }
        String potentialID = symbol.getNonCorrelationName();
        String name = symbol.getName();
        String definition = symbol.getDefinition();
        Object groupID = null;
        try {
            groupID = metadata.getGroupID(potentialID);
        }
        catch (QueryMetadataException e) {
            // empty catch block
        }
        if (groupID == null && (parts = potentialID.split("\\.", 2)).length > 1 && parts[0].equalsIgnoreCase(metadata.getVirtualDatabaseName())) {
            try {
                groupID = metadata.getGroupID(parts[1]);
            }
            catch (QueryMetadataException e) {
                // empty catch block
            }
            if (groupID != null) {
                potentialID = parts[1];
            }
        }
        if (groupID == null) {
            Collection groupNames = null;
            try {
                groupNames = metadata.getGroupsForPartialName(potentialID);
            }
            catch (QueryMetadataException e) {
                // empty catch block
            }
            if (groupNames != null) {
                int matches = groupNames.size();
                if (matches == 1) {
                    potentialID = (String)groupNames.iterator().next();
                    try {
                        groupID = metadata.getGroupID(potentialID);
                    }
                    catch (QueryMetadataException e) {}
                } else if (matches > 1) {
                    throw ResolverUtil.handleUnresolvedGroup(symbol, QueryPlugin.Util.getString("ERR.015.008.0055"));
                }
            }
        }
        if (groupID == null || metadata.isProcedure(groupID)) {
            try {
                StoredProcedureInfo storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(potentialID);
                symbol.setProcedure(true);
                groupID = storedProcedureInfo.getProcedureID();
            }
            catch (QueryMetadataException e) {
                // empty catch block
            }
        }
        if (groupID == null) {
            throw ResolverUtil.handleUnresolvedGroup(symbol, QueryPlugin.Util.getString("ERR.015.008.0056"));
        }
        symbol.setMetadataID(groupID);
        potentialID = metadata.getFullName(groupID);
        if (symbol.getDefinition() == null) {
            symbol.setName(potentialID);
        } else {
            symbol.setDefinition(potentialID);
        }
        try {
            if (!symbol.isProcedure()) {
                symbol.setIsTempTable(metadata.isTemporaryTable(groupID));
            }
        }
        catch (QueryMetadataException e) {
            // empty catch block
        }
        if (metadata.useOutputName()) {
            symbol.setOutputDefinition(definition);
            symbol.setOutputName(name);
        }
    }

    public static void findKeyPreserved(Query query, Set<GroupSymbol> keyPreservingGroups, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        if (query.getFrom() == null) {
            return;
        }
        if (query.getFrom().getClauses().size() == 1) {
            ResolverUtil.findKeyPreserved(query.getFrom().getClauses().get(0), keyPreservingGroups, metadata);
            return;
        }
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>(query.getFrom().getGroups());
        for (GroupSymbol groupSymbol : groups) {
            if (!metadata.getUniqueKeysInGroup(groupSymbol.getMetadataID()).isEmpty()) continue;
            return;
        }
        LinkedList<Expression> leftExpressions = new LinkedList<Expression>();
        LinkedList<Expression> rightExpressions = new LinkedList<Expression>();
        for (Criteria crit : Criteria.separateCriteriaByAnd(query.getCriteria())) {
            CompareCriteria cc;
            if (!(crit instanceof CompareCriteria) || (cc = (CompareCriteria)crit).getOperator() != 1 || !(cc.getLeftExpression() instanceof ElementSymbol) || !(cc.getRightExpression() instanceof ElementSymbol)) continue;
            ElementSymbol left = (ElementSymbol)cc.getLeftExpression();
            ElementSymbol right = (ElementSymbol)cc.getRightExpression();
            int compare = left.getGroupSymbol().compareTo(right.getGroupSymbol());
            if (compare > 0) {
                leftExpressions.add(left);
                rightExpressions.add(right);
                continue;
            }
            if (compare == 0) continue;
            leftExpressions.add(right);
            rightExpressions.add(left);
        }
        HashMap<List<GroupSymbol>, List<HashSet<Object>>> crits = ResolverUtil.createGroupMap(leftExpressions, rightExpressions);
        HashSet<GroupSymbol> tempSet = new HashSet<GroupSymbol>();
        HashSet<GroupSymbol> nonKeyPreserved = new HashSet<GroupSymbol>();
        for (GroupSymbol group : groups) {
            LinkedHashSet<GroupSymbol> visited = new LinkedHashSet<GroupSymbol>();
            LinkedList<GroupSymbol> toVisit = new LinkedList<GroupSymbol>();
            toVisit.add(group);
            while (!toVisit.isEmpty()) {
                GroupSymbol visiting = (GroupSymbol)toVisit.removeLast();
                if (!visited.add(visiting) || nonKeyPreserved.contains(visiting)) continue;
                if (keyPreservingGroups.contains(visiting)) {
                    visited.addAll(groups);
                    break;
                }
                toVisit.addAll(ResolverUtil.findKeyPreserved(tempSet, Collections.singleton(visiting), crits, true, metadata, groups));
                toVisit.addAll(ResolverUtil.findKeyPreserved(tempSet, Collections.singleton(visiting), crits, false, metadata, groups));
            }
            if (visited.containsAll(groups)) {
                keyPreservingGroups.add(group);
                continue;
            }
            nonKeyPreserved.add(group);
        }
    }

    public static void findKeyPreserved(FromClause clause, Set<GroupSymbol> keyPreservingGroups, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        UnaryFromClause ufc;
        if (clause instanceof UnaryFromClause && !metadata.getUniqueKeysInGroup((ufc = (UnaryFromClause)clause).getGroup().getMetadataID()).isEmpty()) {
            keyPreservingGroups.add(ufc.getGroup());
        }
        if (clause instanceof JoinPredicate) {
            JoinPredicate jp = (JoinPredicate)clause;
            if (jp.getJoinType() == JoinType.JOIN_CROSS || jp.getJoinType() == JoinType.JOIN_FULL_OUTER) {
                return;
            }
            HashSet<GroupSymbol> leftPk = new HashSet<GroupSymbol>();
            ResolverUtil.findKeyPreserved(jp.getLeftClause(), leftPk, metadata);
            HashSet<GroupSymbol> rightPk = new HashSet<GroupSymbol>();
            ResolverUtil.findKeyPreserved(jp.getRightClause(), rightPk, metadata);
            if (leftPk.isEmpty() && rightPk.isEmpty()) {
                return;
            }
            HashSet<GroupSymbol> leftGroups = new HashSet<GroupSymbol>();
            HashSet<GroupSymbol> rightGroups = new HashSet<GroupSymbol>();
            jp.getLeftClause().collectGroups(leftGroups);
            jp.getRightClause().collectGroups(rightGroups);
            LinkedList<Expression> leftExpressions = new LinkedList<Expression>();
            LinkedList<Expression> rightExpressions = new LinkedList<Expression>();
            RuleChooseJoinStrategy.separateCriteria(leftGroups, rightGroups, leftExpressions, rightExpressions, jp.getJoinCriteria(), new LinkedList<Criteria>());
            HashMap<List<GroupSymbol>, List<HashSet<Object>>> crits = ResolverUtil.createGroupMap(leftExpressions, rightExpressions);
            if (!(leftPk.isEmpty() || jp.getJoinType() != JoinType.JOIN_INNER && jp.getJoinType() != JoinType.JOIN_LEFT_OUTER)) {
                ResolverUtil.findKeyPreserved(keyPreservingGroups, leftPk, crits, true, metadata, rightPk);
            }
            if (!(rightPk.isEmpty() || jp.getJoinType() != JoinType.JOIN_INNER && jp.getJoinType() != JoinType.JOIN_RIGHT_OUTER)) {
                ResolverUtil.findKeyPreserved(keyPreservingGroups, rightPk, crits, false, metadata, leftPk);
            }
        }
    }

    private static HashMap<List<GroupSymbol>, List<HashSet<Object>>> createGroupMap(LinkedList<Expression> leftExpressions, LinkedList<Expression> rightExpressions) {
        HashMap<List<GroupSymbol>, List<HashSet<Object>>> crits = new HashMap<List<GroupSymbol>, List<HashSet<Object>>>();
        for (int i = 0; i < leftExpressions.size(); ++i) {
            Expression lexpr = leftExpressions.get(i);
            Expression rexpr = rightExpressions.get(i);
            if (!(lexpr instanceof ElementSymbol) || !(rexpr instanceof ElementSymbol)) continue;
            ElementSymbol les = (ElementSymbol)lexpr;
            ElementSymbol res = (ElementSymbol)rexpr;
            List<GroupSymbol> tbls = Arrays.asList(les.getGroupSymbol(), res.getGroupSymbol());
            List<HashSet<Object>> ids = crits.get(tbls);
            if (ids == null) {
                ids = Arrays.asList(new HashSet(), new HashSet());
                crits.put(tbls, ids);
            }
            ids.get(0).add(les.getMetadataID());
            ids.get(1).add(res.getMetadataID());
        }
        return crits;
    }

    private static HashSet<GroupSymbol> findKeyPreserved(Set<GroupSymbol> keyPreservingGroups, Set<GroupSymbol> pk, HashMap<List<GroupSymbol>, List<HashSet<Object>>> crits, boolean left, QueryMetadataInterface metadata, Set<GroupSymbol> otherGroups) throws TeiidComponentException, QueryMetadataException {
        HashSet<GroupSymbol> result = new HashSet<GroupSymbol>();
        for (GroupSymbol gs : pk) {
            for (Map.Entry<List<GroupSymbol>, List<HashSet<Object>>> entry : crits.entrySet()) {
                if (!entry.getKey().get(left ? 0 : 1).equals(gs) || !otherGroups.contains(entry.getKey().get(left ? 1 : 0)) || !RuleRaiseAccess.matchesForeignKey(metadata, (Collection<Object>)entry.getValue().get(left ? 0 : 1), (Collection<Object>)entry.getValue().get(left ? 1 : 0), gs, false, true)) continue;
                keyPreservingGroups.add(gs);
                result.add(entry.getKey().get(left ? 1 : 0));
            }
        }
        return result;
    }

    public static void fullyQualifyElements(Command command) {
        Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements(command, false, true);
        for (ElementSymbol element : elements) {
            element.setDisplayFullyQualified(true);
        }
    }

    public static class ResolvedLookup {
        private GroupSymbol group;
        private ElementSymbol keyElement;
        private ElementSymbol returnElement;

        void setGroup(GroupSymbol group) {
            this.group = group;
        }

        public GroupSymbol getGroup() {
            return this.group;
        }

        void setKeyElement(ElementSymbol keyElement) {
            this.keyElement = keyElement;
        }

        public ElementSymbol getKeyElement() {
            return this.keyElement;
        }

        void setReturnElement(ElementSymbol returnElement) {
            this.returnElement = returnElement;
        }

        public ElementSymbol getReturnElement() {
            return this.returnElement;
        }
    }
}

