/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.TempTableTestHarness;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestGlobalTemp {
    @Test
    public void testGlobalTempUse() throws Exception {
        TempTableTestHarness harness = new TempTableTestHarness();
        TransformationMetadata metadata = RealMetadataFactory.fromDDL("create global temporary table temp (x serial, s string) options (updatable true);", "x", "y");
        HardcodedDataManager dm = new HardcodedDataManager();
        harness.setUp((QueryMetadataInterface)metadata, dm);
        harness.execute("select * from temp", new List[0]);
        harness.execute("insert into temp (s) values ('a')", new List[]{Arrays.asList(1)});
        harness.execute("select * from temp", new List[]{Arrays.asList(1, "a")});
        try {
            harness.execute("drop table temp", new List[0]);
            Assert.fail();
        }
        catch (QueryValidatorException e) {
            // empty catch block
        }
    }

    @Test
    public void testInsertCreation() throws Exception {
        TempTableTestHarness harness = new TempTableTestHarness();
        TransformationMetadata metadata = RealMetadataFactory.fromDDL("create global temporary table temp (x serial, s string) options (updatable true);", "x", "y");
        HardcodedDataManager dm = new HardcodedDataManager();
        harness.setUp((QueryMetadataInterface)metadata, dm);
        harness.execute("insert into temp (s) values ('a')", new List[]{Arrays.asList(1)});
        harness.execute("select * from temp", new List[]{Arrays.asList(1, "a")});
    }

    @Test
    public void testPkInitialUse() throws Exception {
        TempTableTestHarness harness = new TempTableTestHarness();
        TransformationMetadata metadata = RealMetadataFactory.fromDDL("create global temporary table temp (x serial, s string primary key) options (updatable true);", "x", "y");
        HardcodedDataManager dm = new HardcodedDataManager();
        harness.setUp((QueryMetadataInterface)metadata, dm);
        harness.execute("select * from temp", new List[0]);
    }
}

