/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Properties;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.util.CommandContext;

public class FunctionDescriptor
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5374103983118037242L;
    private static final boolean ALLOW_NAN_INFINITY = PropertiesUtils.getBooleanProperty((Properties)System.getProperties(), (String)"org.teiid.allowNanInfinity", (boolean)false);
    private Class<?>[] types;
    private Class<?> returnType;
    private boolean requiresContext;
    private FunctionMethod method;
    private String schema;
    private boolean hasWrappedArgs;
    private boolean calledWithVarArgArrayParam;
    private transient Method invocationMethod;
    private ClassLoader classLoader;

    FunctionDescriptor() {
    }

    FunctionDescriptor(FunctionMethod method, Class<?>[] types, Class<?> outputType, Method invocationMethod, boolean requiresContext, ClassLoader classloader) {
        this.types = types;
        this.returnType = outputType;
        this.invocationMethod = invocationMethod;
        this.requiresContext = requiresContext;
        this.method = method;
        this.classLoader = classloader;
    }

    public Object newInstance() {
        try {
            return this.invocationMethod.getDeclaringClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30602, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30602, new Object[]{this.method.getName(), this.method.getInvocationClass()}));
        }
        catch (IllegalAccessException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30602, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30602, new Object[]{this.method.getName(), this.method.getInvocationClass()}));
        }
    }

    public void setHasWrappedArgs(boolean hasWrappedArgs) {
        this.hasWrappedArgs = hasWrappedArgs;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.method.getName();
    }

    public String getFullName() {
        if ("SYS".equals(this.schema)) {
            return this.getName();
        }
        return this.schema + '.' + this.getName();
    }

    public FunctionMethod.PushDown getPushdown() {
        return this.method.getPushdown();
    }

    public Class<?>[] getTypes() {
        return this.types;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    Method getInvocationMethod() {
        return this.invocationMethod;
    }

    public boolean requiresContext() {
        return this.requiresContext;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.method.getName());
        str.append("(");
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != null) {
                str.append(this.types[i].getName());
            } else {
                str.append("null");
            }
            if (i >= this.types.length - 1) continue;
            str.append(", ");
        }
        str.append(") : ");
        if (this.returnType == null) {
            str.append("null");
        } else {
            str.append(this.returnType.getName());
        }
        return str.toString();
    }

    public boolean isNullDependent() {
        return !this.method.isNullOnNull();
    }

    public FunctionMethod.Determinism getDeterministic() {
        return this.method.getDeterminism();
    }

    public FunctionDescriptor clone() {
        try {
            return (FunctionDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30381, (Throwable)e);
        }
    }

    public FunctionMethod getMethod() {
        return this.method;
    }

    void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeFunction(Object[] values, CommandContext context, Object functionTarget) throws FunctionExecutionException, BlockedException {
        int i;
        if (!this.isNullDependent()) {
            int n = i = this.requiresContext ? 1 : 0;
            while (i < values.length) {
                if (values[i] == null) {
                    return null;
                }
                ++i;
            }
        }
        if (this.invocationMethod == null) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30382, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30382, new Object[]{this.getFullName()}));
        }
        try {
            if (this.hasWrappedArgs) {
                for (i = 0; i < values.length; ++i) {
                    Object val = values[i];
                    if (val == null || this.types[i] != DataTypeManager.DefaultDataClasses.VARBINARY) continue;
                    values[i] = ((BinaryType)val).getBytesDirect();
                }
            }
            if (this.method.isVarArgs()) {
                if (this.calledWithVarArgArrayParam) {
                    ArrayImpl av = (ArrayImpl)values[values.length - 1];
                    if (av != null) {
                        Class<?> arrayType;
                        Object[] vals;
                        values[values.length - 1] = vals = av.getValues();
                        if (this.hasWrappedArgs && this.types[this.types.length - 1] == DataTypeManager.DefaultDataClasses.VARBINARY) {
                            vals = Arrays.copyOf(vals, vals.length);
                            for (int i2 = 0; i2 < vals.length; ++i2) {
                                if (vals[i2] == null) continue;
                                vals[i2] = ((BinaryType)vals[i2]).getBytesDirect();
                            }
                            values[values.length - 1] = vals;
                        }
                        if ((arrayType = this.invocationMethod.getParameterTypes()[this.types.length - 1]).getComponentType() != Object.class && vals.getClass() != arrayType) {
                            Object varArgs = Array.newInstance(arrayType.getComponentType(), vals.length);
                            for (int i3 = 0; i3 < vals.length; ++i3) {
                                Array.set(varArgs, i3, vals[i3]);
                            }
                            values[values.length - 1] = varArgs;
                        }
                    }
                } else {
                    i = this.invocationMethod.getParameterTypes().length;
                    Object[] newValues = Arrays.copyOf(values, i);
                    Object varArgs = null;
                    if (this.invocationMethod.getParameterTypes()[i - 1].getComponentType() != Object.class) {
                        int varArgCount = values.length - i + 1;
                        varArgs = Array.newInstance(this.invocationMethod.getParameterTypes()[i - 1].getComponentType(), varArgCount);
                        for (int j = 0; j < varArgCount; ++j) {
                            Array.set(varArgs, j, values[i - 1 + j]);
                        }
                    } else {
                        varArgs = Arrays.copyOfRange(values, i - 1, values.length);
                    }
                    newValues[i - 1] = varArgs;
                    values = newValues;
                }
            }
            Object result = null;
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            try {
                if (this.classLoader != null) {
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                }
                result = this.invocationMethod.invoke(functionTarget, values);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
            if (context != null && this.getDeterministic().ordinal() <= FunctionMethod.Determinism.USER_DETERMINISTIC.ordinal()) {
                context.setDeterminismLevel(this.getDeterministic());
            }
            return FunctionDescriptor.importValue(result, this.getReturnType());
        }
        catch (ArithmeticException e) {
            throw new FunctionExecutionException(QueryPlugin.Event.TEIID30384, e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30384, new Object[]{this.getFullName()}));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof BlockedException) {
                throw (BlockedException)((Object)e.getTargetException());
            }
            throw new FunctionExecutionException(QueryPlugin.Event.TEIID30384, e.getTargetException(), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30384, new Object[]{this.getFullName()}));
        }
        catch (IllegalAccessException e) {
            throw new FunctionExecutionException(QueryPlugin.Event.TEIID30385, e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30385, new Object[]{this.method.toString()}));
        }
        catch (TransformationException e) {
            throw new FunctionExecutionException(e);
        }
    }

    public static Object importValue(Object result, Class<?> expectedType) throws ArithmeticException, TransformationException {
        String s;
        Number floatVal;
        if (!ALLOW_NAN_INFINITY && (result instanceof Double ? Double.isInfinite((Double)(floatVal = (Double)result)) || Double.isNaN((Double)floatVal) : result instanceof Float && (Float.isInfinite(((Float)(floatVal = (Float)result)).floatValue()) || Float.isNaN(((Float)floatVal).floatValue())))) {
            throw new ArithmeticException("Infinite or invalid result");
        }
        result = DataTypeManager.convertToRuntimeType((Object)result, (expectedType != DataTypeManager.DefaultDataClasses.OBJECT ? 1 : 0) != 0);
        if (expectedType.isArray() && result instanceof ArrayImpl) {
            return result;
        }
        if ((result = DataTypeManager.transformValue((Object)result, expectedType)) instanceof String && (s = (String)result).length() > DataTypeManager.MAX_STRING_LENGTH) {
            return s.substring(0, DataTypeManager.MAX_STRING_LENGTH);
        }
        return result;
    }

    public boolean isCalledWithVarArgArrayParam() {
        return this.calledWithVarArgArrayParam;
    }

    public void setCalledWithVarArgArrayParam(boolean calledWithVarArgArrayParam) {
        this.calledWithVarArgArrayParam = calledWithVarArgArrayParam;
    }

    public boolean isSystemFunction(String name) {
        return this.getName().equalsIgnoreCase(name) && "SYS".equals(this.getSchema());
    }
}

