/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import java.util.Collections;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class CreateProcedureCommand
extends Command {
    private Block block;
    private List projectedSymbols;
    private List<? extends Expression> resultSetColumns;
    private GroupSymbol virtualGroup;
    private int updateType = 0;
    private ElementSymbol returnVariable;

    public CreateProcedureCommand() {
    }

    public CreateProcedureCommand(Block block) {
        this.block = block;
    }

    @Override
    public int getType() {
        return 7;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        CreateProcedureCommand copy = new CreateProcedureCommand();
        if (this.block != null) {
            copy.setBlock(this.block.clone());
        }
        if (this.projectedSymbols != null) {
            copy.projectedSymbols = LanguageObject.Util.deepClone(this.projectedSymbols, Expression.class);
        }
        if (this.resultSetColumns != null) {
            copy.resultSetColumns = LanguageObject.Util.deepClone(this.resultSetColumns, Expression.class);
        }
        if (this.virtualGroup != null) {
            copy.virtualGroup = this.virtualGroup.clone();
        }
        if (this.returnVariable != null) {
            copy.returnVariable = this.returnVariable;
        }
        copy.updateType = this.updateType;
        this.copyMetadataState(copy);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CreateProcedureCommand)) {
            return false;
        }
        CreateProcedureCommand other = (CreateProcedureCommand)obj;
        return this.sameOptionAndHint(other) && EquivalenceUtil.areEqual((Object)this.getBlock(), (Object)other.getBlock());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getBlock()});
        return myHash;
    }

    @Override
    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public List getProjectedSymbols() {
        if (this.projectedSymbols != null) {
            return this.projectedSymbols;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<? extends Expression> getResultSetColumns() {
        return this.resultSetColumns;
    }

    public void setResultSetColumns(List<? extends Expression> resultSetColumns) {
        this.resultSetColumns = resultSetColumns;
    }

    public void setProjectedSymbols(List projSymbols) {
        this.projectedSymbols = projSymbols;
    }

    @Override
    public boolean areResultsCachable() {
        return Query.areColumnsCachable(this.getProjectedSymbols());
    }

    public GroupSymbol getVirtualGroup() {
        return this.virtualGroup;
    }

    public void setVirtualGroup(GroupSymbol virtualGroup) {
        this.virtualGroup = virtualGroup;
    }

    public void setUpdateType(int type) {
        this.resultSetColumns = Command.getUpdateCommandSymbol();
        this.updateType = type;
    }

    public int getUpdateType() {
        return this.updateType;
    }

    public void setReturnVariable(ElementSymbol symbol) {
        this.returnVariable = symbol;
    }

    public ElementSymbol getReturnVariable() {
        return this.returnVariable;
    }

    @Override
    public boolean returnsResultSet() {
        return this.resultSetColumns != null && !this.resultSetColumns.isEmpty();
    }
}

