/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.List;
import org.junit.Assert;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.tempdata.TempTableDataManager;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;

public class TempTableTestHarness {
    protected TempMetadataAdapter metadata;
    protected TempTableDataManager dataManager;
    protected TempTableStore tempStore;
    protected TransactionContext tc;

    public ProcessorPlan execute(String sql, List<?>[] expectedResults, CapabilitiesFinder finder) throws Exception {
        CommandContext cc = TestProcessor.createCommandContext();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)this.metadata, finder, cc);
        cc.setTransactionContext(this.tc);
        cc.setMetadata((QueryMetadataInterface)this.metadata);
        cc.setTempTableStore(this.tempStore);
        TestProcessor.doProcess(plan, (ProcessorDataManager)this.dataManager, expectedResults, cc);
        Assert.assertTrue((FunctionMethod.Determinism.SESSION_DETERMINISTIC.compareTo((Enum)cc.getDeterminismLevel()) <= 0 ? 1 : 0) != 0);
        return plan;
    }

    public ProcessorPlan execute(String sql, List<?>[] expectedResults) throws Exception {
        return this.execute(sql, expectedResults, (CapabilitiesFinder)DefaultCapabilitiesFinder.INSTANCE);
    }

    public void setUp(QueryMetadataInterface qmi, ProcessorDataManager dm) {
        this.tempStore = new TempTableStore("1", TempTableStore.TransactionMode.ISOLATE_WRITES);
        this.metadata = new TempMetadataAdapter(qmi, this.tempStore.getMetadataStore());
        this.metadata.setSession(true);
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        SessionAwareCache cache = new SessionAwareCache("resultset", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.RESULTSET, 0);
        cache.setTupleBufferCache((TupleBufferCache)bm);
        this.dataManager = new TempTableDataManager(dm, bm, cache);
    }
}

