/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.util.BitSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.core.util.Assertion;

public class ConcurrentBitSet {
    private static final int CONCURRENT_MODIFICATION = -2;
    private static final int ADDRESS_BITS_PER_TOP_VALUE = 18;
    private static final int MAX_TOP_VALUE = 262144;
    private int bitsPerSegment;
    private int totalBits;
    private AtomicInteger counter = new AtomicInteger();
    private AtomicInteger bitsSet = new AtomicInteger();
    private Segment[] segments;
    private boolean compact;

    public ConcurrentBitSet(int maxBits, int concurrencyLevel) {
        Assertion.assertTrue((maxBits > 0 ? 1 : 0) != 0);
        while ((this.bitsPerSegment = maxBits / concurrencyLevel) < concurrencyLevel) {
            concurrencyLevel >>= 1;
        }
        this.segments = new Segment[concurrencyLevel];
        int modBits = maxBits % concurrencyLevel;
        if (modBits > 0) {
            ++this.bitsPerSegment;
        }
        for (int i = 0; i < concurrencyLevel; ++i) {
            this.segments[i] = new Segment(this.bitsPerSegment);
            this.segments[i].offset = i * this.bitsPerSegment;
            if (i != concurrencyLevel - 1) continue;
            this.segments[i].maxBits -= this.bitsPerSegment * concurrencyLevel - maxBits;
        }
        this.totalBits = maxBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(int bitIndex) {
        this.checkIndex(bitIndex);
        Segment s = this.segments[bitIndex / this.bitsPerSegment];
        int segmentBitIndex = bitIndex % this.bitsPerSegment;
        Segment segment = s;
        synchronized (segment) {
            if (!s.bitSet.get(segmentBitIndex)) {
                throw new AssertionError((Object)(bitIndex + " not set"));
            }
            if (this.compact) {
                s.startSearch = Math.min(s.startSearch, segmentBitIndex);
            }
            s.bitSet.clear(segmentBitIndex);
            --s.bitsSet;
            int n = segmentBitIndex >> 18;
            s.topVals[n] = s.topVals[n] - 1;
        }
        this.bitsSet.decrementAndGet();
    }

    public int getAndSetNextClearBit() {
        return this.getAndSetNextClearBit(this.counter.getAndIncrement());
    }

    public int getNextSegment() {
        return this.counter.getAndIncrement();
    }

    public int getBitsSet(int segment) {
        Segment s = this.segments[segment & this.segments.length - 1];
        return s.bitsSet;
    }

    public int getHighestBitSet(int segment) {
        Segment s = this.segments[segment & this.segments.length - 1];
        return s.highestBitSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAndSetNextClearBit(int segment) {
        int nextBit = -1;
        for (int i = 0; i < this.segments.length; ++i) {
            Segment s;
            Segment segment2 = s = this.segments[segment + i & this.segments.length - 1];
            synchronized (segment2) {
                int indexSearchStart;
                if (s.bitsSet == s.maxBits) {
                    continue;
                }
                for (int j = indexSearchStart = s.startSearch >> 18; j < s.topVals.length; ++j) {
                    if (s.topVals[j] == 262144) continue;
                    if (s.topVals[j] == 0) {
                        if (j == segment) {
                            nextBit = s.startSearch;
                            break;
                        }
                        nextBit = j * 262144;
                        break;
                    }
                    int index = j * 262144;
                    if (j == indexSearchStart) {
                        index = s.startSearch;
                    }
                    nextBit = s.bitSet.nextClearBit(index);
                    if (s.startSearch <= 0 || nextBit < s.maxBits - 1) break;
                    s.startSearch = 0;
                    nextBit = s.bitSet.nextClearBit(s.startSearch);
                    break;
                }
                if (nextBit >= s.maxBits) {
                    throw new AssertionError((Object)"could not find clear bit");
                }
                int n = nextBit >> 18;
                s.topVals[n] = s.topVals[n] + 1;
                ++s.bitsSet;
                s.bitSet.set(nextBit);
                s.startSearch = nextBit + 1;
                s.highestBitSet = Math.max(s.highestBitSet, nextBit);
                if (s.startSearch == s.maxBits) {
                    s.startSearch = 0;
                }
                nextBit += s.offset;
                break;
            }
        }
        if (nextBit != -1) {
            this.bitsSet.getAndIncrement();
        }
        return nextBit;
    }

    private void checkIndex(int bitIndex) {
        if (bitIndex >= this.totalBits) {
            throw new ArrayIndexOutOfBoundsException(bitIndex);
        }
    }

    public int getTotalBits() {
        return this.totalBits;
    }

    public int getBitsSet() {
        return this.bitsSet.get();
    }

    public int getBitsPerSegment() {
        return this.bitsPerSegment;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compactHighestBitSet(int segment) {
        Segment s = this.segments[segment & this.segments.length - 1];
        for (int i = 0; i < 3; ++i) {
            int result = this.tryCompactHighestBitSet(s);
            if (result == -2) continue;
            return result;
        }
        Segment segment2 = s;
        synchronized (segment2) {
            return this.tryCompactHighestBitSet(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryCompactHighestBitSet(Segment s) {
        int indexSearchStart;
        int highestBitSet = 0;
        Segment segment = s;
        synchronized (segment) {
            highestBitSet = s.highestBitSet;
            if (highestBitSet < 0) {
                return -1;
            }
            if (s.bitSet.get(highestBitSet)) {
                return highestBitSet;
            }
        }
        for (int j = indexSearchStart = highestBitSet >> 18; j >= 0; --j) {
            Segment segment2;
            if (s.topVals[j] == 0) {
                if (j != 0) continue;
                segment2 = s;
                synchronized (segment2) {
                    if (s.highestBitSet != highestBitSet) {
                        return -2;
                    }
                    s.highestBitSet = -1;
                    continue;
                }
            }
            if (s.topVals[j] == 262144) {
                segment2 = s;
                synchronized (segment2) {
                    if (s.highestBitSet != highestBitSet) {
                        return -2;
                    }
                    s.highestBitSet = (j + 1) * 262144 - 1;
                    break;
                }
            }
            int index = j * 262144;
            int end = index + s.maxBits;
            if (j == indexSearchStart) {
                end = highestBitSet;
            }
            BitSet bs = s.bitSet;
            int offset = 0;
            if (j == indexSearchStart) {
                bs = s.bitSet.get(index, end);
                offset = index;
            }
            index -= offset;
            end = end - offset - 1;
            while (index < end) {
                int next = bs.nextSetBit(index);
                if (next == -1) {
                    --index;
                    break;
                }
                index = next + 1;
            }
            Segment segment3 = s;
            synchronized (segment3) {
                if (s.highestBitSet != highestBitSet) {
                    return -2;
                }
                s.highestBitSet = index + offset;
                return s.highestBitSet;
            }
        }
        return -1;
    }

    private static class Segment {
        int offset;
        int maxBits;
        int startSearch;
        int highestBitSet = -1;
        int bitsSet;
        int[] topVals;
        final BitSet bitSet = new BitSet();

        public Segment(int bitCount) {
            this.maxBits = bitCount;
            this.topVals = new int[Math.max(1, this.maxBits >> 18)];
        }
    }
}

