/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.validator.ValidationVisitor;

public class LimitNode
extends RelationalNode {
    private final Expression limitExpr;
    private final Expression offsetExpr;
    private int limit;
    private int offset;
    private int rowCounter;
    private boolean offsetPhase = true;
    private boolean implicit;

    public LimitNode(int nodeID, Expression limitExpr, Expression offsetExpr) {
        super(nodeID);
        this.limitExpr = limitExpr;
        this.offsetExpr = offsetExpr;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    protected TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        TupleBatch resultBatch;
        List<List<?>> originalTuples;
        List<Object> tuples;
        TupleBatch batch = null;
        if (this.limit == 0) {
            this.terminateBatches();
            return this.pullBatch();
        }
        if (this.offsetPhase) {
            while (this.rowCounter <= this.offset) {
                batch = this.getChildren()[0].nextBatch();
                this.rowCounter += batch.getRowCount();
                if (!batch.getTerminationFlag()) continue;
            }
            tuples = null;
            if (this.rowCounter > this.offset) {
                originalTuples = batch.getTuples();
                int rowsToKeep = this.rowCounter - this.offset;
                tuples = new ArrayList(originalTuples.subList(batch.getRowCount() - rowsToKeep, batch.getRowCount()));
            } else {
                tuples = Collections.emptyList();
            }
            resultBatch = new TupleBatch(1L, tuples);
            resultBatch.setTerminationFlag(batch.getTerminationFlag());
            batch = resultBatch;
            this.offsetPhase = false;
            this.rowCounter = 0;
        } else {
            batch = this.getChildren()[0].nextBatch();
        }
        tuples = null;
        if (this.limit < 0 || this.rowCounter + batch.getRowCount() <= this.limit) {
            tuples = batch.getTuples();
        } else {
            originalTuples = batch.getTuples();
            tuples = new ArrayList(originalTuples.subList(0, this.limit - this.rowCounter));
        }
        resultBatch = new TupleBatch((long)(this.rowCounter + 1), tuples);
        this.rowCounter += resultBatch.getRowCount();
        if (this.rowCounter == this.limit || batch.getTerminationFlag()) {
            resultBatch.setTerminationFlag(true);
        }
        return resultBatch;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        this.limit = -1;
        if (this.limitExpr != null) {
            Integer limitVal = (Integer)new Evaluator(Collections.emptyMap(), this.getDataManager(), this.getContext()).evaluate(this.limitExpr, Collections.emptyList());
            ValidationVisitor.LIMIT_CONSTRAINT.validate(limitVal);
            this.limit = limitVal;
        }
        if (this.limit == 0) {
            return;
        }
        if (this.offsetExpr != null) {
            Integer offsetVal = (Integer)new Evaluator(Collections.emptyMap(), this.getDataManager(), this.getContext()).evaluate(this.offsetExpr, Collections.emptyList());
            ValidationVisitor.LIMIT_CONSTRAINT.validate(offsetVal);
            this.offset = offsetVal;
        } else {
            this.offset = 0;
        }
        this.offsetPhase = this.offset > 0;
        super.open();
    }

    @Override
    public void reset() {
        super.reset();
        this.rowCounter = 0;
        this.offsetPhase = true;
    }

    @Override
    protected void getNodeString(StringBuffer buf) {
        super.getNodeString(buf);
        if (this.limitExpr != null) {
            buf.append("limit ");
            buf.append(this.limitExpr);
        }
        if (this.offsetExpr != null) {
            buf.append(" offset ");
            buf.append(this.offsetExpr);
        }
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        props.addProperty("Row Offset", String.valueOf(this.offsetExpr));
        props.addProperty("Row Limit", String.valueOf(this.limitExpr));
        return props;
    }

    @Override
    public Object clone() {
        LimitNode node = new LimitNode(this.getID(), this.limitExpr, this.offsetExpr);
        node.implicit = this.implicit;
        this.copyTo(node);
        node.rowCounter = this.rowCounter;
        return node;
    }

    public Expression getLimitExpr() {
        return this.limitExpr;
    }

    public Expression getOffsetExpr() {
        return this.offsetExpr;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public boolean hasBuffer(boolean requireFinal) {
        return this.offsetExpr == null && this.getChildren()[0].hasBuffer(requireFinal);
    }

    @Override
    public TupleBuffer getBuffer(int maxRows) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (maxRows >= 0) {
            if (this.limit >= 0) {
                maxRows = Math.min(maxRows, this.limit);
            }
        } else {
            maxRows = this.limit;
        }
        return this.getChildren()[0].getBuffer(maxRows);
    }
}

