/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.client.security.SessionToken;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.StringUtil;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TupleSourceCache;
import org.teiid.events.EventDistributor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.tempdata.AlterTempTable;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.query.tempdata.TempTable;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.CacheDirective;

public class TempTableDataManager
implements ProcessorDataManager {
    private static final String REFRESHMATVIEWROW = ".refreshmatviewrow";
    private static final String REFRESHMATVIEWROWS = ".refreshmatviewrows";
    private static final String REFRESHMATVIEW = ".refreshmatview";
    public static final String CODE_PREFIX = "#CODE_";
    private static String REFRESH_SQL = "CALL SYSADMIN.refreshmatview(?, ?)";
    private ProcessorDataManager processorDataManager;
    private BufferManager bufferManager;
    private SessionAwareCache<CachedResults> cache;
    private RequestExecutor executor;
    private EventDistributor eventDistributor;

    public TempTableDataManager(ProcessorDataManager processorDataManager, BufferManager bufferManager, SessionAwareCache<CachedResults> cache) {
        this.processorDataManager = processorDataManager;
        this.bufferManager = bufferManager;
        this.cache = cache;
    }

    public void setExecutor(RequestExecutor executor) {
        this.executor = executor;
    }

    public void setEventDistributor(EventDistributor eventDistributor) {
        this.eventDistributor = eventDistributor;
    }

    @Override
    public TupleSource registerRequest(CommandContext context, Command command, String modelName, RegisterRequestParameter parameterObject) throws TeiidComponentException, TeiidProcessingException {
        TupleSourceCache tsc;
        if (parameterObject.info != null && (tsc = context.getTupleSourceCache()) != null) {
            return tsc.getSharedTupleSource(context, command, modelName, parameterObject, this.bufferManager, this);
        }
        TempTableStore tempTableStore = context.getTempTableStore();
        if (tempTableStore != null) {
            try {
                TupleSource result = this.registerRequest(context, modelName, command);
                if (result != null) {
                    return result;
                }
            }
            catch (BlockedException e) {
                throw new AssertionError((Object)"blocked is not expected");
            }
        }
        return this.processorDataManager.registerRequest(context, command, modelName, parameterObject);
    }

    TupleSource registerRequest(final CommandContext context, String modelName, final Command command) throws TeiidComponentException, TeiidProcessingException {
        final TempTableStore contextStore = context.getTempTableStore();
        if (command instanceof Query) {
            Query query = (Query)command;
            if (modelName != null && !modelName.equals(TempMetadataAdapter.TEMP_MODEL.getID())) {
                return null;
            }
            return this.registerQuery(context, contextStore, query);
        }
        if (command instanceof ProcedureContainer) {
            if (command instanceof StoredProcedure) {
                StoredProcedure proc = (StoredProcedure)command;
                if ("SYSADMIN".equals(modelName)) {
                    TupleSource result = this.handleSystemProcedures(context, proc);
                    if (result != null) {
                        return result;
                    }
                } else if (proc.getGroup().isGlobalTable()) {
                    return this.handleCachedProcedure(context, proc);
                }
                return null;
            }
            final GroupSymbol group = ((ProcedureContainer)command).getGroup();
            if (!modelName.equals(TempMetadataAdapter.TEMP_MODEL.getID()) || !group.isTempGroupSymbol()) {
                return null;
            }
            return new ProxyTupleSource(){

                @Override
                protected TupleSource createTupleSource() throws TeiidComponentException, TeiidProcessingException {
                    String groupKey = group.getNonCorrelationName();
                    TempTable table = contextStore.getOrCreateTempTable(groupKey, command, TempTableDataManager.this.bufferManager, true, true, context, group);
                    if (command instanceof Insert) {
                        Insert insert = (Insert)command;
                        TupleSource ts = insert.getTupleSource();
                        if (ts == null) {
                            Evaluator eval = new Evaluator(Collections.emptyMap(), TempTableDataManager.this, context);
                            ArrayList<Object> values = new ArrayList<Object>(insert.getValues().size());
                            for (Expression expr : insert.getValues()) {
                                values.add(eval.evaluate(expr, null));
                            }
                            ts = new CollectionTupleSource(Arrays.asList(values).iterator());
                        }
                        return table.insert(ts, insert.getVariables(), true, context);
                    }
                    if (command instanceof Update) {
                        Update update = (Update)command;
                        Criteria crit = update.getCriteria();
                        return table.update(crit, update.getChangeList());
                    }
                    if (command instanceof Delete) {
                        Delete delete = (Delete)command;
                        Criteria crit = delete.getCriteria();
                        if (crit == null) {
                            long rows = table.truncate(false);
                            return CollectionTupleSource.createUpdateCountTupleSource((int)Math.min(Integer.MAX_VALUE, rows));
                        }
                        return table.delete(crit);
                    }
                    throw new AssertionError((Object)("unknown command " + command));
                }
            };
        }
        if (command instanceof Create) {
            Create create = (Create)command;
            String tempTableName = create.getTable().getName();
            if (contextStore.hasTempTable(tempTableName, true)) {
                throw new QueryProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30229, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30229, new Object[]{tempTableName}));
            }
            if (create.getTableMetadata() != null) {
                contextStore.addForeignTempTable(tempTableName, create);
            } else {
                contextStore.addTempTable(tempTableName, create, this.bufferManager, true, context);
            }
            return CollectionTupleSource.createUpdateCountTupleSource(0);
        }
        if (command instanceof Drop) {
            String tempTableName = ((Drop)command).getTable().getName();
            contextStore.removeTempTableByName(tempTableName, context);
            return CollectionTupleSource.createUpdateCountTupleSource(0);
        }
        if (command instanceof AlterTempTable) {
            AlterTempTable att = (AlterTempTable)command;
            TempTable tt = contextStore.getTempTable(att.getTempTable());
            Assertion.isNotNull((Object)tt, (String)"Table doesn't exist");
            tt.setUpdatable(false);
            if (att.getIndexColumns() != null && tt.getRowCount() > (long)(2 * tt.getTree().getPageSize(true))) {
                for (List<ElementSymbol> cols : att.getIndexColumns()) {
                    tt.addIndex(cols, false);
                }
            }
            return CollectionTupleSource.createUpdateCountTupleSource(0);
        }
        return null;
    }

    private TupleSource handleCachedProcedure(final CommandContext context, StoredProcedure proc) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        String fullName = context.getMetadata().getFullName(proc.getProcedureID());
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"processing cached procedure request for", (Object)fullName);
        LinkedList<Object> vals = new LinkedList<Object>();
        for (SPParameter param : proc.getInputParameters()) {
            vals.add(((Constant)param.getExpression()).getValue());
        }
        int hash = vals.hashCode();
        hash |= hash >>> 16;
        hash |= hash >>> 8;
        final SessionAwareCache.CacheID cid = new SessionAwareCache.CacheID(new ParseInfo(), fullName + (hash &= 0xFF), context.getVdbName(), context.getVdbVersion(), context.getConnectionId(), context.getUserName());
        cid.setParameters(vals);
        CachedResults results = this.cache.get(cid);
        if (results != null) {
            TupleBuffer buffer = results.getResults();
            return buffer.createIndexedTupleSource();
        }
        final CacheHint hint = proc.getCacheHint();
        proc.setCacheHint(null);
        Option option = new Option();
        option.setNoCache(true);
        option.addNoCacheGroup(fullName);
        proc.setOption(option);
        StoredProcedure cloneProc = (StoredProcedure)proc.clone();
        int i = 0;
        for (SPParameter param : cloneProc.getInputParameters()) {
            param.setExpression(new Reference(i++));
        }
        final QueryProcessor qp = context.getQueryProcessorFactory().createQueryProcessor(cloneProc.toString(), fullName.toUpperCase(), context, vals.toArray());
        final BatchCollector bc = qp.createBatchCollector();
        return new ProxyTupleSource(){
            boolean success = false;

            @Override
            protected TupleSource createTupleSource() throws TeiidComponentException, TeiidProcessingException {
                TupleBuffer tb = bc.collectTuples();
                CachedResults cr = new CachedResults();
                cr.setResults(tb, qp.getProcessorPlan());
                FunctionMethod.Determinism determinismLevel = qp.getContext().getDeterminismLevel();
                if (hint != null && hint.getDeterminism() != null) {
                    LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Cache hint modified the query determinism from ", determinismLevel, " to ", hint.getDeterminism()});
                    determinismLevel = hint.getDeterminism();
                }
                TempTableDataManager.this.cache.put(cid, determinismLevel, cr, hint != null ? hint.getTtl() : null);
                context.setDeterminismLevel(determinismLevel);
                this.success = true;
                return tb.createIndexedTupleSource();
            }

            @Override
            public void closeSource() {
                super.closeSource();
                qp.closeProcessing();
                if (!this.success && bc.getTupleBuffer() != null) {
                    bc.getTupleBuffer().remove();
                }
            }
        };
    }

    private TupleSource handleSystemProcedures(CommandContext context, StoredProcedure proc) throws TeiidComponentException, QueryMetadataException, QueryProcessingException, QueryResolverException, QueryValidatorException, TeiidProcessingException, ExpressionEvaluationException {
        QueryMetadataInterface metadata = context.getMetadata();
        if (StringUtil.endsWithIgnoreCase((String)proc.getProcedureCallableName(), (String)REFRESHMATVIEW)) {
            Object groupID = this.validateMatView(metadata, (String)((Constant)proc.getParameter(2).getExpression()).getValue());
            TempMetadataID matTableId = context.getGlobalTableStore().getGlobalTempTableMetadataId(groupID);
            GlobalTableStore globalStore = this.getGlobalStore(context, matTableId);
            String matViewName = metadata.getFullName(groupID);
            String matTableName = metadata.getFullName(matTableId);
            LogManager.logDetail((String)"org.teiid.PROCESSOR.MATVIEWS", (Object)"processing refreshmatview for", (Object)matViewName);
            boolean invalidate = Boolean.TRUE.equals(((Constant)proc.getParameter(3).getExpression()).getValue());
            boolean needsLoading = globalStore.needsLoading(matTableName, globalStore.getAddress(), true, true, invalidate);
            if (!needsLoading) {
                return CollectionTupleSource.createUpdateCountTupleSource(-1);
            }
            GroupSymbol matTable = new GroupSymbol(matTableName);
            matTable.setMetadataID(matTableId);
            return this.loadGlobalTable(context, matTable, matTableName, globalStore);
        }
        if (StringUtil.endsWithIgnoreCase((String)proc.getProcedureCallableName(), (String)REFRESHMATVIEWROWS)) {
            Object groupID = this.validateMatView(metadata, (String)((Constant)proc.getParameter(2).getExpression()).getValue());
            TempMetadataID matTableId = context.getGlobalTableStore().getGlobalTempTableMetadataId(groupID);
            GlobalTableStore globalStore = this.getGlobalStore(context, matTableId);
            Object pk = metadata.getPrimaryKey(groupID);
            String matViewName = metadata.getFullName(groupID);
            if (pk == null) {
                throw new QueryProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30230, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30230, new Object[]{matViewName}));
            }
            List ids = metadata.getElementIDsInKey(pk);
            Object[][] params = (Object[][])((ArrayImpl)((Constant)proc.getParameter(3).getExpression()).getValue()).getValues();
            return this.updateMatviewRows(context, metadata, groupID, globalStore, matViewName, ids, params);
        }
        if (StringUtil.endsWithIgnoreCase((String)proc.getProcedureCallableName(), (String)REFRESHMATVIEWROW)) {
            Object[] otherCols;
            Object groupID = this.validateMatView(metadata, (String)((Constant)proc.getParameter(2).getExpression()).getValue());
            TempMetadataID matTableId = context.getGlobalTableStore().getGlobalTempTableMetadataId(groupID);
            GlobalTableStore globalStore = this.getGlobalStore(context, matTableId);
            Object pk = metadata.getPrimaryKey(groupID);
            String matViewName = metadata.getFullName(groupID);
            if (pk == null) {
                throw new QueryProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30230, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30230, new Object[]{matViewName}));
            }
            List ids = metadata.getElementIDsInKey(pk);
            Constant key = (Constant)proc.getParameter(3).getExpression();
            Object initialValue = key.getValue();
            SPParameter keyOther = proc.getParameter(4);
            Object[] param = null;
            if (keyOther != null && (otherCols = ((ArrayImpl)((Constant)keyOther.getExpression()).getValue()).getValues()) != null) {
                param = new Object[1 + otherCols.length];
                param[0] = initialValue;
                for (int i = 0; i < otherCols.length; ++i) {
                    param[i + 1] = otherCols[i];
                }
            }
            if (param == null) {
                param = new Object[]{initialValue};
            }
            Object[][] params = new Object[][]{param};
            return this.updateMatviewRows(context, metadata, groupID, globalStore, matViewName, ids, params);
        }
        return null;
    }

    private TupleSource updateMatviewRows(final CommandContext context, final QueryMetadataInterface metadata, final Object groupID, final GlobalTableStore globalStore, final String matViewName, List<?> ids, Object[][] params) throws QueryProcessingException, TeiidComponentException, QueryMetadataException, TransformationException {
        final String matTableName = "#MAT_" + matViewName.toUpperCase();
        GlobalTableStoreImpl.MatTableInfo info = globalStore.getMatTableInfo(matTableName);
        if (!info.isValid()) {
            return CollectionTupleSource.createUpdateCountTupleSource(-1);
        }
        TempTable tempTable = globalStore.getTempTable(matTableName);
        if (!tempTable.isUpdatable()) {
            throw new QueryProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30232, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30232, new Object[]{matViewName}));
        }
        ArrayList<Object[]> converted = new ArrayList<Object[]>();
        for (Object[] param : params) {
            if (param == null || ids.size() != param.length) {
                throw new QueryProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30231, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30231, new Object[]{matViewName, ids.size(), param == null ? 0 : param.length}));
            }
            Object[] vals = new Object[param.length];
            for (int i = 0; i < ids.size(); ++i) {
                Object value = param[i];
                String targetTypeName = metadata.getElementType(ids.get(i));
                vals[i] = value = DataTypeManager.transformValue((Object)value, (Class)DataTypeManager.getDataTypeClass((String)targetTypeName));
            }
            converted.add(vals);
        }
        final Iterator paramIter = converted.iterator();
        Iterator<?> iter = ids.iterator();
        StringBuilder criteria = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            Object id = iter.next();
            String targetTypeName = metadata.getElementType(id);
            if (i != 0) {
                criteria.append(" AND ");
            }
            criteria.append(metadata.getFullName(id)).append(" = ?");
        }
        final String queryString = "SELECT * FROM " + matViewName + ' ' + "WHERE" + ' ' + criteria.toString() + ' ' + "OPTION" + ' ' + "NOCACHE";
        return new ProxyTupleSource(){
            private QueryProcessor qp;
            private TupleSource ts;
            private Object[] params;
            private int count;

            @Override
            protected TupleSource createTupleSource() throws TeiidComponentException, TeiidProcessingException {
                do {
                    if (this.qp == null) {
                        this.params = (Object[])paramIter.next();
                        LogManager.logInfo((String)"org.teiid.PROCESSOR.MATVIEWS", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30012, new Object[]{matViewName, Arrays.toString(this.params)}));
                        this.qp = context.getQueryProcessorFactory().createQueryProcessor(queryString, matViewName.toUpperCase(), context, this.params);
                        this.ts = new BatchCollector.BatchProducerTupleSource(this.qp);
                    }
                    List<Object> tuple = this.ts.nextTuple();
                    boolean delete = false;
                    if (tuple == null) {
                        delete = true;
                        tuple = Arrays.asList(this.params);
                    } else {
                        tuple = new ArrayList(tuple);
                    }
                    List<?> result = globalStore.updateMatViewRow(matTableName, tuple, delete);
                    if (result != null) {
                        ++this.count;
                    }
                    if (TempTableDataManager.this.eventDistributor != null) {
                        TempTableDataManager.this.eventDistributor.updateMatViewRow(context.getVdbName(), context.getVdbVersion(), metadata.getName(metadata.getModelID(groupID)), metadata.getName(groupID), tuple, delete);
                    }
                    this.qp.closeProcessing();
                    this.qp = null;
                    this.ts = null;
                } while (paramIter.hasNext());
                return CollectionTupleSource.createUpdateCountTupleSource(this.count);
            }

            @Override
            public void closeSource() {
                super.closeSource();
                if (this.qp != null) {
                    this.qp.closeProcessing();
                }
            }
        };
    }

    private Object validateMatView(QueryMetadataInterface metadata, String viewName) throws TeiidComponentException, TeiidProcessingException {
        try {
            Object groupID = metadata.getGroupID(viewName);
            if (!metadata.hasMaterialization(groupID) || metadata.getMaterialization(groupID) != null) {
                throw new QueryProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30233, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30233, new Object[]{viewName}));
            }
            return groupID;
        }
        catch (QueryMetadataException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30234, (Throwable)((Object)e));
        }
    }

    private TupleSource registerQuery(final CommandContext context, final TempTableStore contextStore, final Query query) {
        final GroupSymbol group = query.getFrom().getGroups().get(0);
        if (!group.isTempGroupSymbol()) {
            return null;
        }
        final String tableName = group.getNonCorrelationName();
        if (group.isGlobalTable()) {
            TempMetadataID matTableId = (TempMetadataID)group.getMetadataID();
            final GlobalTableStore globalStore = this.getGlobalStore(context, matTableId);
            final GlobalTableStoreImpl.MatTableInfo info = globalStore.getMatTableInfo(tableName);
            return new ProxyTupleSource(){
                Future<Void> moreWork = null;
                TupleSource loadingTupleSource;
                DQPWorkContext newWorkContext;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected TupleSource createTupleSource() throws TeiidComponentException, TeiidProcessingException {
                    if (this.loadingTupleSource != null) {
                        this.load();
                    } else {
                        boolean load = false;
                        if (!info.isUpToDate()) {
                            boolean invalidate = TempTableDataManager.shouldInvalidate(context.getVdb());
                            load = globalStore.needsLoading(tableName, globalStore.getAddress(), true, false, info.isValid() && invalidate);
                            if (load) {
                                load = globalStore.needsLoading(tableName, globalStore.getAddress(), false, false, info.isValid() && invalidate);
                            }
                            if (!load) {
                                GlobalTableStoreImpl.MatTableInfo matTableInfo = info;
                                synchronized (matTableInfo) {
                                    if (!info.isUpToDate()) {
                                        RequestWorkItem workItem = context.getWorkItem();
                                        info.addWaiter(workItem);
                                        if (this.moreWork != null) {
                                            this.moreWork.cancel(false);
                                        }
                                        this.moreWork = workItem.scheduleWork(10000L);
                                        throw BlockedException.block("Blocking on mat view load", tableName);
                                    }
                                }
                            } else if (!info.isValid() || TempTableDataManager.this.executor == null) {
                                if (info.getVdbMetaData() != null && context.getDQPWorkContext() != null && !info.getVdbMetaData().getFullName().equals(context.getDQPWorkContext().getVDB().getFullName())) {
                                    assert (TempTableDataManager.this.executor != null);
                                    this.newWorkContext = TempTableDataManager.this.createWorkContext(context, info.getVdbMetaData());
                                    CommandContext newContext = context.clone();
                                    newContext.setNewVDBState(this.newWorkContext);
                                    this.loadingTupleSource = TempTableDataManager.this.loadGlobalTable(newContext, group, tableName, newContext.getGlobalTableStore());
                                } else {
                                    this.loadingTupleSource = TempTableDataManager.this.loadGlobalTable(context, group, tableName, globalStore);
                                }
                                this.load();
                            } else {
                                TempTableDataManager.this.loadViaRefresh(context, tableName, context.getDQPWorkContext().getVDB(), info);
                            }
                        }
                    }
                    TempTable table = globalStore.getTempTable(tableName);
                    context.accessedDataObject(group.getMetadataID());
                    TupleSource result = table.createTupleSource(query.getProjectedSymbols(), query.getCriteria(), query.getOrderBy());
                    this.cancelMoreWork();
                    return result;
                }

                private void load() throws TeiidComponentException, TeiidProcessingException {
                    if (this.newWorkContext != null) {
                        try {
                            this.newWorkContext.runInContext(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    loadingTupleSource.nextTuple();
                                    return null;
                                }
                            });
                        }
                        catch (Throwable e) {
                            TempTableDataManager.rethrow(e);
                        }
                    } else {
                        this.loadingTupleSource.nextTuple();
                    }
                }

                private void cancelMoreWork() {
                    if (this.moreWork != null) {
                        this.moreWork.cancel(false);
                        this.moreWork = null;
                    }
                }

                @Override
                public void closeSource() {
                    if (this.loadingTupleSource != null) {
                        this.loadingTupleSource.closeSource();
                    }
                    super.closeSource();
                    this.cancelMoreWork();
                }
            };
        }
        return new ProxyTupleSource(){

            @Override
            protected TupleSource createTupleSource() throws TeiidComponentException, TeiidProcessingException {
                Object id;
                TempTableStore tts = contextStore;
                TempTable tt = tts.getOrCreateTempTable(tableName, query, TempTableDataManager.this.bufferManager, true, false, context, group);
                if (context.getDataObjects() != null && (id = RelationalPlanner.getTrackableGroup(group, context.getMetadata())) != null) {
                    context.accessedDataObject(id);
                }
                return tt.createTupleSource(query.getProjectedSymbols(), query.getCriteria(), query.getOrderBy());
            }
        };
    }

    private GlobalTableStore getGlobalStore(CommandContext context, TempMetadataID matTableId) {
        GlobalTableStore globalStore = context.getGlobalTableStore();
        if (matTableId.getCacheHint() == null || matTableId.getCacheHint().getScope() == null || CacheDirective.Scope.VDB.compareTo((Enum)matTableId.getCacheHint().getScope()) <= 0) {
            return globalStore;
        }
        return context.getSessionScopedStore(true);
    }

    private void loadViaRefresh(CommandContext context, String tableName, VDBMetaData vdb, GlobalTableStoreImpl.MatTableInfo info) throws TeiidProcessingException, TeiidComponentException {
        info.setAsynchLoad();
        DQPWorkContext workContext = this.createWorkContext(context, vdb);
        final String viewName = tableName.substring("#MAT_".length());
        workContext.runInContext(new Runnable(){

            @Override
            public void run() {
                TempTableDataManager.this.executor.execute(REFRESH_SQL, Arrays.asList(viewName, Boolean.FALSE));
            }
        });
    }

    private DQPWorkContext createWorkContext(CommandContext context, VDBMetaData vdb) {
        SessionMetadata session = TempTableDataManager.createTemporarySession(context.getUserName(), "asynch-mat-view-load", vdb);
        session.setSubject(context.getSubject());
        session.setSecurityDomain(context.getSession().getSecurityDomain());
        session.setSecurityContext(context.getSession().getSecurityContext());
        DQPWorkContext workContext = new DQPWorkContext();
        workContext.setAdmin(true);
        DQPWorkContext current = context.getDQPWorkContext();
        workContext.setSession(session);
        workContext.setPolicies(current.getAllowedDataPolicies());
        workContext.setSecurityHelper(current.getSecurityHelper());
        return workContext;
    }

    private TupleSource loadGlobalTable(final CommandContext context, final GroupSymbol group, final String tableName, final GlobalTableStore globalStore) throws TeiidComponentException, TeiidProcessingException {
        LogManager.logInfo((String)"org.teiid.PROCESSOR.MATVIEWS", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30013, new Object[]{tableName}));
        final QueryMetadataInterface metadata = context.getMetadata();
        final List<ElementSymbol> allColumns = ResolverUtil.resolveElementsInGroup(group, metadata);
        final TempTable table = globalStore.createMatTable(tableName, group);
        table.setUpdatable(false);
        return new ProxyTupleSource(){
            TupleSource insertTupleSource;
            boolean success;
            QueryProcessor qp;
            boolean closed;
            boolean errored;

            @Override
            protected TupleSource createTupleSource() throws TeiidComponentException, TeiidProcessingException {
                long rowCount = -1L;
                try {
                    List<ElementSymbol> columns;
                    if (this.insertTupleSource == null) {
                        String fullName = metadata.getFullName(group.getMetadataID());
                        Iterator transformation = metadata.getVirtualPlan(group.getMetadataID()).getQuery();
                        this.qp = context.getQueryProcessorFactory().createQueryProcessor((String)((Object)transformation), fullName, context, new Object[0]);
                        this.insertTupleSource = new BatchCollector.BatchProducerTupleSource(this.qp);
                    }
                    table.insert(this.insertTupleSource, allColumns, false, null);
                    table.getTree().compact();
                    rowCount = table.getRowCount();
                    FunctionMethod.Determinism determinism = this.qp.getContext().getDeterminismLevel();
                    context.setDeterminismLevel(determinism);
                    for (Object index : metadata.getIndexesInGroup(group.getMetadataID())) {
                        columns = GlobalTableStoreImpl.resolveIndex(metadata, allColumns, index);
                        table.addIndex(columns, false);
                    }
                    for (Object key : metadata.getUniqueKeysInGroup(group.getMetadataID())) {
                        columns = GlobalTableStoreImpl.resolveIndex(metadata, allColumns, key);
                        table.addIndex(columns, true);
                    }
                    CacheHint hint = table.getCacheHint();
                    if (hint != null && table.getPkLength() > 0) {
                        table.setUpdatable(hint.isUpdatable(false));
                    }
                    if (determinism.compareTo((Enum)FunctionMethod.Determinism.VDB_DETERMINISTIC) < 0 && (hint == null || hint.getScope() == null || CacheDirective.Scope.VDB.compareTo((Enum)hint.getScope()) <= 0)) {
                        LogManager.logInfo((String)"org.teiid.PROCESSOR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31143, new Object[]{determinism, tableName}));
                    }
                    globalStore.loaded(tableName, table);
                    this.success = true;
                    LogManager.logInfo((String)"org.teiid.PROCESSOR.MATVIEWS", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30014, new Object[]{tableName, rowCount}));
                    return CollectionTupleSource.createUpdateCountTupleSource((int)Math.min(Integer.MAX_VALUE, rowCount));
                }
                catch (BlockedException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.errored = true;
                    LogManager.logError((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30015, new Object[]{tableName}));
                    this.closeSource();
                    TempTableDataManager.rethrow(e);
                    throw new AssertionError();
                }
            }

            @Override
            public void closeSource() {
                if (this.closed) {
                    return;
                }
                if (!this.errored && !this.success) {
                    LogManager.logInfo((String)"org.teiid.PROCESSOR.MATVIEWS", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31153, new Object[]{tableName}));
                }
                this.closed = true;
                if (!this.success) {
                    globalStore.failedLoad(tableName);
                    table.remove();
                }
                if (this.qp != null) {
                    this.qp.closeProcessing();
                }
                super.closeSource();
            }
        };
    }

    @Override
    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        codeTableName = codeTableName.toUpperCase();
        keyElementName = keyElementName.toUpperCase();
        returnElementName = returnElementName.toUpperCase();
        String matTableName = CODE_PREFIX + codeTableName + "." + keyElementName + "." + returnElementName;
        TupleSource ts = context.getCodeLookup(matTableName, keyValue);
        if (ts == null) {
            QueryMetadataInterface metadata = context.getMetadata();
            TempMetadataID id = context.getGlobalTableStore().getCodeTableMetadataId(codeTableName, returnElementName, keyElementName, matTableName);
            ElementSymbol keyElement = new ElementSymbol(keyElementName, new GroupSymbol(matTableName));
            ElementSymbol returnElement = new ElementSymbol(returnElementName, new GroupSymbol(matTableName));
            keyElement.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(metadata.getElementID(codeTableName + "." + keyElementName))));
            returnElement.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(metadata.getElementID(codeTableName + "." + returnElementName))));
            Query query = RelationalPlanner.createMatViewQuery(id, matTableName, Arrays.asList(returnElement), true);
            query.setCriteria(new CompareCriteria(keyElement, 1, new Constant(keyValue)));
            ts = this.registerQuery(context, context.getTempTableStore(), query);
        }
        try {
            List<?> row = ts.nextTuple();
            Object result = null;
            if (row != null) {
                result = row.get(0);
            }
            ts.closeSource();
            return result;
        }
        catch (BlockedException e) {
            context.putCodeLookup(matTableName, keyValue, ts);
            throw e;
        }
    }

    @Override
    public EventDistributor getEventDistributor() {
        return this.eventDistributor;
    }

    public static SessionMetadata createTemporarySession(String userName, String app, VDBMetaData vdb) {
        long creationTime = System.currentTimeMillis();
        SessionMetadata newSession = new SessionMetadata();
        newSession.setSessionToken(new SessionToken(userName));
        newSession.setSessionId(newSession.getSessionToken().getSessionID());
        newSession.setUserName(userName);
        newSession.setCreatedTime(creationTime);
        newSession.setApplicationName(app);
        newSession.setVDBName(vdb.getName());
        newSession.setVDBVersion(vdb.getVersion());
        newSession.setVdb(vdb);
        newSession.setEmbedded(true);
        return newSession;
    }

    private static void rethrow(Throwable e) throws TeiidComponentException, TeiidProcessingException {
        if (e instanceof TeiidComponentException) {
            throw (TeiidComponentException)e;
        }
        if (e instanceof TeiidProcessingException) {
            throw (TeiidProcessingException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new TeiidRuntimeException(e);
    }

    public static boolean shouldInvalidate(VDBMetaData vdb) {
        String val;
        boolean invalidate = true;
        if (vdb != null && (val = vdb.getPropertyValue("lazy-invalidate")) != null) {
            invalidate = Boolean.valueOf(val) == false;
        }
        return invalidate;
    }

    public abstract class ProxyTupleSource
    implements TupleSource {
        TupleSource actual;

        @Override
        public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
            if (this.actual == null) {
                this.actual = this.createTupleSource();
            }
            return this.actual.nextTuple();
        }

        protected abstract TupleSource createTupleSource() throws TeiidComponentException, TeiidProcessingException;

        @Override
        public void closeSource() {
            if (this.actual != null) {
                this.actual.closeSource();
            }
        }
    }

    public static interface RequestExecutor {
        public void execute(String var1, List<?> var2);
    }
}

