/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache;

import java.io.Serializable;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.LRUCache;
import org.teiid.query.QueryPlugin;

public class DefaultCacheFactory
implements CacheFactory,
Serializable {
    private static final long serialVersionUID = -5541424157695857527L;
    private static CacheConfiguration DEFAULT = new CacheConfiguration(CacheConfiguration.Policy.LRU, 3600, 100, "default");
    public static DefaultCacheFactory INSTANCE = new DefaultCacheFactory(DEFAULT);
    private volatile boolean destroyed = false;
    private CacheConfiguration config;

    public DefaultCacheFactory(CacheConfiguration config) {
        this.config = config;
    }

    public void destroy() {
        this.destroyed = true;
    }

    public <K, V> Cache<K, V> get(String cacheName) {
        if (!this.destroyed) {
            return new MockCache(cacheName, this.config.getMaxEntries());
        }
        throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30562, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30562, new Object[0]));
    }

    private static class MockCache<K, V>
    extends LRUCache<K, V>
    implements Cache<K, V> {
        private String name;

        public MockCache(String cacheName, int maxSize) {
            super(maxSize < 0 ? Integer.MAX_VALUE : maxSize);
            this.name = cacheName;
        }

        public V put(K key, V value, Long ttl) {
            return (V)this.put(key, value);
        }

        public String getName() {
            return this.name;
        }

        public boolean isTransactional() {
            return false;
        }
    }
}

