/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.common.buffer.CacheEntry;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.Serializer;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.impl.BufferFrontedFileStoreCache;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.common.buffer.impl.OutOfDiskException;
import org.teiid.common.buffer.impl.PhysicalInfo;
import org.teiid.common.buffer.impl.SplittableStorageManager;
import org.teiid.core.TeiidComponentException;

public class TestBufferFrontedFileStoreCache {
    private BufferFrontedFileStoreCache cache;

    @After
    public void teardown() {
        if (this.cache != null) {
            this.cache.shutdown();
        }
    }

    @Test
    public void testAddGetMultiBlock() throws Exception {
        this.cache = TestBufferFrontedFileStoreCache.createLayeredCache(0x4000000, 0x4000000, true, true);
        CacheEntry ce = new CacheEntry(Long.valueOf(2L));
        SimpleSerializer s = new SimpleSerializer();
        this.cache.createCacheGroup(s.getId());
        Integer cacheObject = 2;
        ce.setObject((Object)cacheObject);
        this.cache.addToCacheGroup(s.getId(), ce.getId());
        this.cache.add(ce, (Serializer)s);
        ce = TestBufferFrontedFileStoreCache.get(this.cache, 2L, s);
        Assert.assertEquals((Object)cacheObject, (Object)ce.getObject());
        ce = new CacheEntry(Long.valueOf(3L));
        cacheObject = 80000;
        ce.setObject((Object)cacheObject);
        this.cache.addToCacheGroup(s.getId(), ce.getId());
        this.cache.add(ce, (Serializer)s);
        ce = TestBufferFrontedFileStoreCache.get(this.cache, 3L, s);
        Assert.assertEquals((Object)cacheObject, (Object)ce.getObject());
        ce = new CacheEntry(Long.valueOf(4L));
        cacheObject = 60000;
        ce.setObject((Object)cacheObject);
        this.cache.addToCacheGroup(s.getId(), ce.getId());
        this.cache.add(ce, (Serializer)s);
        ce = TestBufferFrontedFileStoreCache.get(this.cache, 4L, s);
        Assert.assertEquals((Object)cacheObject, (Object)ce.getObject());
        this.cache.removeCacheGroup(Long.valueOf(1L));
        Assert.assertEquals((long)0L, (long)this.cache.getDataBlocksInUse());
        Assert.assertEquals((long)0L, (long)this.cache.getInodesInUse());
        ce = new CacheEntry(Long.valueOf(3L));
        this.cache.createCacheGroup(s.getId());
        cacheObject = 5000000;
        ce.setObject((Object)cacheObject);
        this.cache.addToCacheGroup(s.getId(), ce.getId());
        this.cache.add(ce, (Serializer)s);
        ce = TestBufferFrontedFileStoreCache.get(this.cache, 3L, s);
        Assert.assertEquals((Object)cacheObject, (Object)ce.getObject());
        this.cache.removeCacheGroup(Long.valueOf(1L));
        Assert.assertEquals((long)0L, (long)this.cache.getDataBlocksInUse());
        Assert.assertEquals((long)0L, (long)this.cache.getInodesInUse());
        ce = new CacheEntry(Long.valueOf(3L));
        this.cache.createCacheGroup(s.getId());
        cacheObject = 500000000;
        ce.setObject((Object)cacheObject);
        this.cache.addToCacheGroup(s.getId(), ce.getId());
        this.cache.add(ce, (Serializer)s);
        ce = TestBufferFrontedFileStoreCache.get(this.cache, 3L, s);
        Assert.assertNull((Object)ce);
        this.cache.removeCacheGroup(Long.valueOf(1L));
        Assert.assertEquals((long)0L, (long)this.cache.getDataBlocksInUse());
        Assert.assertEquals((long)0L, (long)this.cache.getInodesInUse());
    }

    private static CacheEntry get(BufferFrontedFileStoreCache cache, Long oid, Serializer<Integer> s) throws TeiidComponentException {
        PhysicalInfo o = cache.lockForLoad(oid, s);
        CacheEntry ce = cache.get(o, oid, new WeakReference<Serializer<Integer>>(s));
        cache.unlockForLoad(o);
        return ce;
    }

    @Test
    public void testEviction() throws Exception {
        this.cache = TestBufferFrontedFileStoreCache.createLayeredCache(32768, 32768, true, true);
        Assert.assertEquals((long)3L, (long)this.cache.getMaxMemoryBlocks());
        CacheEntry ce = new CacheEntry(Long.valueOf(2L));
        SimpleSerializer s = new SimpleSerializer();
        WeakReference<SimpleSerializer> ref = new WeakReference<SimpleSerializer>(s);
        ce.setSerializer(ref);
        this.cache.createCacheGroup(s.getId());
        Integer cacheObject = 5000;
        ce.setObject((Object)cacheObject);
        this.cache.addToCacheGroup(s.getId(), ce.getId());
        this.cache.add(ce, (Serializer)s);
        ce = new CacheEntry(Long.valueOf(3L));
        ce.setSerializer(ref);
        cacheObject = 5001;
        ce.setObject((Object)cacheObject);
        this.cache.addToCacheGroup(s.getId(), ce.getId());
        this.cache.add(ce, (Serializer)s);
        Assert.assertTrue((this.cache.getDataBlocksInUse() < 4 ? 1 : 0) != 0);
        Assert.assertTrue((this.cache.getInodesInUse() < 2 ? 1 : 0) != 0);
        ce = TestBufferFrontedFileStoreCache.get(this.cache, 2L, s);
        Assert.assertEquals((Object)5000, (Object)ce.getObject());
        ce = TestBufferFrontedFileStoreCache.get(this.cache, 3L, s);
        Assert.assertEquals((Object)5001, (Object)ce.getObject());
    }

    @Test
    public void testEvictionFails() throws Exception {
        this.cache = TestBufferFrontedFileStoreCache.createLayeredCache(32768, 32768, false, true);
        BufferManagerImpl bmi = (BufferManagerImpl)Mockito.mock(BufferManagerImpl.class);
        this.cache.setBufferManager(bmi);
        SimpleSerializer s = new SimpleSerializer();
        WeakReference<SimpleSerializer> ref = new WeakReference<SimpleSerializer>(s);
        this.cache.createCacheGroup(s.getId());
        for (int i = 0; i < 3; ++i) {
            this.add(this.cache, s, ref, i);
        }
        ((BufferManagerImpl)Mockito.verify((Object)bmi, (VerificationMode)Mockito.atLeastOnce())).invalidCacheGroup(Long.valueOf(1L));
    }

    private void add(BufferFrontedFileStoreCache cache, Serializer<Integer> s, WeakReference<? extends Serializer<?>> ref, int i) {
        CacheEntry ce = new CacheEntry(Long.valueOf(i));
        ce.setSerializer(ref);
        Integer cacheObject = 5000 + i;
        ce.setObject((Object)cacheObject);
        cache.addToCacheGroup(s.getId(), ce.getId());
        cache.add(ce, s);
    }

    private static BufferFrontedFileStoreCache createLayeredCache(int bufferSpace, int objectSize, boolean memStorage, boolean allocate) throws TeiidComponentException {
        BufferFrontedFileStoreCache fsc = new BufferFrontedFileStoreCache();
        fsc.cleanerRunning.set(true);
        fsc.setMemoryBufferSpace((long)bufferSpace);
        fsc.setMaxStorageObjectSize(objectSize);
        fsc.setDirect(false);
        if (memStorage) {
            SplittableStorageManager ssm = new SplittableStorageManager((StorageManager)new MemoryStorageManager());
            ssm.setMaxFileSizeDirect(131072L);
            fsc.setStorageManager((StorageManager)ssm);
        } else {
            StorageManager sm = new StorageManager(){

                public void initialize() throws TeiidComponentException {
                }

                public FileStore createFileStore(String name) {
                    return new FileStore(){

                        public void setLength(long length) throws IOException {
                            throw new OutOfDiskException(null);
                        }

                        protected void removeDirect() {
                        }

                        protected int readWrite(long fileOffset, byte[] b, int offSet, int length, boolean write) throws IOException {
                            return 0;
                        }

                        public long getLength() {
                            return 0L;
                        }
                    };
                }
            };
            fsc.setStorageManager(sm);
        }
        fsc.initialize(allocate);
        return fsc;
    }

    @Test
    public void testSizeIndex() throws Exception {
        PhysicalInfo info = new PhysicalInfo(Long.valueOf(1L), Long.valueOf(1L), -1, 0L);
        info.setSize(8192);
        Assert.assertEquals((long)0L, (long)info.sizeIndex);
        info = new PhysicalInfo(Long.valueOf(1L), Long.valueOf(1L), -1, 0L);
        info.setSize(8193);
        Assert.assertEquals((long)1L, (long)info.sizeIndex);
        info = new PhysicalInfo(Long.valueOf(1L), Long.valueOf(1L), -1, 0L);
        info.setSize(32770);
        Assert.assertEquals((long)3L, (long)info.sizeIndex);
    }

    @Test(expected=Exception.class)
    public void testSizeChanged() throws Exception {
        PhysicalInfo info = new PhysicalInfo(Long.valueOf(1L), Long.valueOf(1L), -1, 0L);
        info.setSize(8192);
        Assert.assertEquals((long)0L, (long)info.sizeIndex);
        info.setSize(8193);
    }

    @Test
    public void testDefragTruncateEmpty() throws Exception {
        int i;
        this.cache = TestBufferFrontedFileStoreCache.createLayeredCache(32768, 32768, true, true);
        this.cache.setMinDefrag(10000000L);
        SimpleSerializer s = new SimpleSerializer();
        WeakReference<SimpleSerializer> ref = new WeakReference<SimpleSerializer>(s);
        this.cache.createCacheGroup(s.getId());
        Integer cacheObject = 5000;
        for (i = 0; i < 4; ++i) {
            CacheEntry ce = new CacheEntry(Long.valueOf(i));
            ce.setSerializer(ref);
            ce.setObject((Object)cacheObject);
            this.cache.addToCacheGroup(s.getId(), ce.getId());
            this.cache.add(ce, (Serializer)s);
        }
        Assert.assertEquals((long)98304L, (long)this.cache.getDiskUsage());
        for (i = 0; i < 4; ++i) {
            this.cache.remove(Long.valueOf(1L), Long.valueOf(i));
        }
        Assert.assertEquals((long)98304L, (long)this.cache.getDiskUsage());
        this.cache.setMinDefrag(0L);
        this.cache.defragTask.run();
        Assert.assertEquals((long)98304L, (long)this.cache.getDiskUsage());
        this.cache.setTruncateInterval(1);
        this.cache.defragTask.run();
        Assert.assertEquals((long)0L, (long)this.cache.getDiskUsage());
    }

    @Test
    public void testDefragTruncate() throws Exception {
        int i;
        this.cache = TestBufferFrontedFileStoreCache.createLayeredCache(32768, 32768, true, true);
        this.cache.setMinDefrag(10000000L);
        SimpleSerializer s = new SimpleSerializer();
        WeakReference<SimpleSerializer> ref = new WeakReference<SimpleSerializer>(s);
        this.cache.createCacheGroup(s.getId());
        Integer cacheObject = 5000;
        for (i = 0; i < 30; ++i) {
            CacheEntry ce = new CacheEntry(Long.valueOf(i));
            ce.setSerializer(ref);
            ce.setObject((Object)cacheObject);
            this.cache.addToCacheGroup(s.getId(), ce.getId());
            this.cache.add(ce, (Serializer)s);
        }
        Assert.assertEquals((long)950272L, (long)this.cache.getDiskUsage());
        for (i = 0; i < 25; ++i) {
            this.cache.remove(Long.valueOf(1L), Long.valueOf(i));
        }
        Assert.assertEquals((long)950272L, (long)this.cache.getDiskUsage());
        this.cache.setMinDefrag(0L);
        this.cache.setTruncateInterval(1);
        this.cache.defragTask.run();
        Assert.assertEquals((long)622592L, (long)this.cache.getDiskUsage());
        this.cache.defragTask.run();
        Assert.assertEquals((long)262144L, (long)this.cache.getDiskUsage());
        this.cache.defragTask.run();
        Assert.assertEquals((long)131072L, (long)this.cache.getDiskUsage());
        this.cache.defragTask.run();
        Assert.assertEquals((long)131072L, (long)this.cache.getDiskUsage());
    }

    @Test
    public void testDefragTruncateCompact() throws Exception {
        int i;
        this.cache = TestBufferFrontedFileStoreCache.createLayeredCache(32768, 32768, true, true);
        this.cache.setCompactBufferFiles(true);
        this.cache.setTruncateInterval(1);
        this.cache.setMinDefrag(10000000L);
        SimpleSerializer s = new SimpleSerializer();
        WeakReference<SimpleSerializer> ref = new WeakReference<SimpleSerializer>(s);
        this.cache.createCacheGroup(s.getId());
        Integer cacheObject = 5000;
        for (i = 0; i < 30; ++i) {
            CacheEntry ce = new CacheEntry(Long.valueOf(i));
            ce.setSerializer(ref);
            ce.setObject((Object)cacheObject);
            this.cache.addToCacheGroup(s.getId(), ce.getId());
            this.cache.add(ce, (Serializer)s);
        }
        Assert.assertEquals((long)950272L, (long)this.cache.getDiskUsage());
        for (i = 0; i < 25; ++i) {
            this.cache.remove(Long.valueOf(1L), Long.valueOf(i));
        }
        Assert.assertEquals((long)950272L, (long)this.cache.getDiskUsage());
        this.cache.setMinDefrag(0L);
        this.cache.setTruncateInterval(1);
        this.cache.defragTask.run();
        Assert.assertEquals((long)131072L, (long)this.cache.getDiskUsage());
        this.cache.defragTask.run();
        Assert.assertEquals((long)131072L, (long)this.cache.getDiskUsage());
    }

    @Test
    public void testDefragMin() throws Exception {
        int i;
        this.cache = TestBufferFrontedFileStoreCache.createLayeredCache(32768, 32768, true, true);
        this.cache.setMinDefrag(10000000L);
        SimpleSerializer s = new SimpleSerializer();
        WeakReference<SimpleSerializer> ref = new WeakReference<SimpleSerializer>(s);
        this.cache.createCacheGroup(s.getId());
        Integer cacheObject = 5000;
        for (i = 0; i < 100; ++i) {
            CacheEntry ce = new CacheEntry(Long.valueOf(i));
            ce.setSerializer(ref);
            ce.setObject((Object)cacheObject);
            this.cache.addToCacheGroup(s.getId(), ce.getId());
            this.cache.add(ce, (Serializer)s);
        }
        Assert.assertEquals((long)3244032L, (long)this.cache.getDiskUsage());
        for (i = 0; i < 90; ++i) {
            this.cache.remove(Long.valueOf(1L), Long.valueOf(i));
        }
        Assert.assertEquals((long)3244032L, (long)this.cache.getDiskUsage());
        this.cache.setMinDefrag(5000L);
        this.cache.setTruncateInterval(1);
        this.cache.defragTask.run();
        Assert.assertEquals((long)1802240L, (long)this.cache.getDiskUsage());
        this.cache.defragTask.run();
        Assert.assertEquals((long)0x110000L, (long)this.cache.getDiskUsage());
        this.cache.defragTask.run();
        Assert.assertEquals((long)655360L, (long)this.cache.getDiskUsage());
        this.cache.defragTask.run();
        Assert.assertEquals((long)655360L, (long)this.cache.getDiskUsage());
    }

    @Test
    public void testLargeMax() throws TeiidComponentException {
        TestBufferFrontedFileStoreCache.createLayeredCache(0x100000, 0x40000000, false, false);
    }

    @Test
    public void testNonAlignedMaxBlocks() throws TeiidComponentException {
        BufferFrontedFileStoreCache bf = TestBufferFrontedFileStoreCache.createLayeredCache(0x100000, 8000000, false, false);
        Assert.assertEquals((long)974L, (long)bf.getMaxMemoryBlocks());
    }

    private static final class SimpleSerializer
    implements Serializer<Integer> {
        private SimpleSerializer() {
        }

        public Integer deserialize(ObjectInput ois) throws IOException, ClassNotFoundException {
            Integer result = ois.readInt();
            for (int i = 0; i < result; ++i) {
                Assert.assertEquals((long)i, (long)ois.readInt());
            }
            return result;
        }

        public Long getId() {
            return 1L;
        }

        public void serialize(Integer obj, ObjectOutput oos) throws IOException {
            oos.writeInt(obj);
            for (int i = 0; i < obj; ++i) {
                oos.writeInt(i);
            }
        }

        public boolean useSoftCache() {
            return false;
        }
    }
}

