/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.CacheKey;
import org.teiid.common.buffer.impl.LrfuEvictionQueue;

public class TestLrfuEvictionQueue {
    @Test
    public void testPrecision() {
        LrfuEvictionQueue q = new LrfuEvictionQueue(new AtomicLong());
        long value = 0L;
        for (long i = Integer.MAX_VALUE; i < 0x80000009L; ++i) {
            long valueNext = q.computeNextOrderingValue(i, i - 1L, value);
            Assert.assertTrue((valueNext > value ? 1 : 0) != 0);
            value = valueNext;
        }
    }

    @Test
    public void testKeyCompare() {
        CacheKey key = new CacheKey(Long.valueOf(-5600000000000000000L), 0L, 0L);
        CacheKey key1 = new CacheKey(Long.valueOf(3831662765844904176L), 0L, 0L);
        CacheKey key2 = new CacheKey(Long.valueOf(0L), 0L, 0L);
        Assert.assertTrue((key.compareTo(key1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((key1.compareTo(key) > 0 ? 1 : 0) != 0);
    }
}

