/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.crypto.CryptoException;
import org.teiid.core.crypto.Cryptor;
import org.teiid.core.crypto.SymmetricCryptor;

public class TestEncryptDecrypt {
    private static final String ALPHA_U = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String ALPHA_L = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toLowerCase();
    private static final String NUMBERS = "0123456789";
    private static final String MISC_CHAR = "<>,.:;'{}[][]|`~!@#$%^&*()_+-=";
    private static final String CLEARTEXT = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" + ALPHA_L + "0123456789" + "<>,.:;'{}[][]|`~!@#$%^&*()_+-=";
    private static Cryptor cryptor;

    @BeforeClass
    public static void oneTimeSetup() throws CryptoException, IOException {
        cryptor = SymmetricCryptor.getSymmectricCryptor((URL)TestEncryptDecrypt.class.getResource("/teiid.keystore"));
    }

    public void helpTestEncryptDecrypt(String cleartext) throws CryptoException {
        String ciphertext = cryptor.encrypt(cleartext);
        String cleartext2 = cryptor.decrypt(ciphertext);
        Assert.assertTrue((boolean)ciphertext.startsWith("{teiid-encrypt}"));
        Assert.assertEquals((Object)cleartext, (Object)cleartext2);
    }

    @Test
    public void testPos_EncryptDecryptLongString() throws CryptoException {
        this.helpTestEncryptDecrypt(CLEARTEXT);
    }

    @Test
    public void testPos_EncryptDecryptHalfLongString() throws CryptoException {
        this.helpTestEncryptDecrypt(CLEARTEXT.substring(0, CLEARTEXT.length() / 2));
    }

    @Test
    public void testPos_EncryptDecryptStringsOfVariousLengths() throws CryptoException {
        for (int k = 1; k < CLEARTEXT.length() / 4; ++k) {
            String cleartext = CLEARTEXT.substring(k, k + k);
            this.helpTestEncryptDecrypt(cleartext);
        }
    }

    @Test
    public void testPos_EncryptDecryptStringsOfBlanks() throws CryptoException {
        String BLANKS = "          ";
        for (int k = 1; k < BLANKS.length(); ++k) {
            String cleartext = BLANKS.substring(0, k);
            this.helpTestEncryptDecrypt(cleartext);
        }
    }

    @Test
    public void testNeg_DecryptNonEncryptedStringLen10() throws CryptoException {
        String ciphertext = "abcdefghij";
        try {
            cryptor.decrypt(ciphertext);
            Assert.fail((String)"expected exception");
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    @Test
    public void testNeg_DecryptNullString() throws Exception {
        try {
            cryptor.decrypt((String)null);
            Assert.fail((String)"expected exception");
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    @Test
    public void testNeg_EncryptZeroLengthString() throws CryptoException {
        try {
            cryptor.encrypt("");
            Assert.fail((String)"expected exception");
        }
        catch (CryptoException e) {
            Assert.assertEquals((Object)"TEIID10015 Attempt to encrypt zero-length cleartext.", (Object)e.getMessage());
        }
    }

    @Test
    public void testNeg_EncryptNullCharArray() throws CryptoException {
        try {
            cryptor.encrypt((String)null);
            Assert.fail((String)"expected exception");
        }
        catch (CryptoException e) {
            Assert.assertEquals((Object)"TEIID10014 Attempt to encrypt null cleartext.", (Object)e.getMessage());
        }
    }

    @Test
    public void testPos_EncryptAfterException() throws Exception {
        try {
            cryptor.encrypt("");
        }
        catch (CryptoException e) {
            this.helpTestEncryptDecrypt(CLEARTEXT);
        }
    }

    @Test
    public void testLongEncryption() throws Exception {
        this.helpTestEncryptDecrypt(CLEARTEXT + CLEARTEXT + CLEARTEXT);
    }

    @Test
    public void testSymmetricEncryptionWithRandomKey() throws Exception {
        SymmetricCryptor randomSymCryptor = SymmetricCryptor.getSymmectricCryptor();
        ArrayList<String> test = new ArrayList<String>(Arrays.asList(ALPHA_L, ALPHA_U, CLEARTEXT, NUMBERS));
        Object result = randomSymCryptor.sealObject(test);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(result);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        result = ois.readObject();
        ArrayList clearObject = (ArrayList)randomSymCryptor.unsealObject(result);
        Assert.assertEquals(test, (Object)clearObject);
        SymmetricCryptor cryptor1 = SymmetricCryptor.getSymmectricCryptor((byte[])randomSymCryptor.getEncodedKey());
        clearObject = (ArrayList)cryptor1.unsealObject(result);
        Assert.assertEquals(test, (Object)clearObject);
    }
}

