/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.util.ObjectConverterUtil;

public class TestSQLXMLImpl {
    String testStr = "<foo>test</foo>";

    @Test
    public void testGetSource() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        Assert.assertTrue((boolean)(xml.getSource(null) instanceof StreamSource));
        StreamSource ss = (StreamSource)xml.getSource(null);
        Assert.assertEquals((Object)this.testStr, (Object)new String(ObjectConverterUtil.convertToByteArray((InputStream)ss.getInputStream()), "UTF-8"));
    }

    @Test
    public void testGetCharacterStream() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        Assert.assertEquals((Object)this.testStr, (Object)ObjectConverterUtil.convertToString((Reader)xml.getCharacterStream()));
    }

    @Test
    public void testGetBinaryStream() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        Assert.assertEquals((Object)this.testStr, (Object)new String(ObjectConverterUtil.convertToByteArray((InputStream)xml.getBinaryStream()), "UTF-8"));
    }

    @Test
    public void testGetString() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        Assert.assertEquals((Object)this.testStr, (Object)xml.getString());
    }

    @Test(expected=SQLException.class)
    public void testSetBinaryStream() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        xml.setBinaryStream();
    }

    @Test(expected=SQLException.class)
    public void testSetCharacterStream() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        xml.setCharacterStream();
    }

    @Test(expected=SQLException.class)
    public void testSetString() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        xml.setString(this.testStr);
    }

    @Test
    public void testGetString1() throws Exception {
        SQLXMLImpl clob = new SQLXMLImpl(){

            public Reader getCharacterStream() throws SQLException {
                return new Reader(){
                    int pos = 0;

                    @Override
                    public void close() throws IOException {
                    }

                    @Override
                    public int read(char[] cbuf, int off, int len) throws IOException {
                        if (this.pos < 5) {
                            cbuf[off] = 97;
                            ++this.pos;
                            return 1;
                        }
                        return -1;
                    }
                };
            }
        };
        Assert.assertEquals((Object)"aaaaa", (Object)clob.getString());
    }
}

