/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.datasource;

import java.sql.Connection;
import java.sql.Statement;
import org.teiid.test.framework.connection.ConnectionStrategy;
import org.teiid.test.framework.exception.QueryTestFailedException;

public class DataStore {
    public static void initialize(ConnectionStrategy connStrategy) {
        if (connStrategy.isDataStoreDisabled()) {
            return;
        }
        try {
            DataStore.load(DataStore.getConnection("pm1", connStrategy));
            DataStore.load(DataStore.getConnection("pm2", connStrategy));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Connection getConnection(String identifier, ConnectionStrategy connStrategy) throws QueryTestFailedException {
        Connection conn = connStrategy.createDriverConnection(identifier);
        try {
            conn.setAutoCommit(true);
        }
        catch (Exception sqle) {
            throw new QueryTestFailedException(sqle);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(Connection c) throws Exception {
        try (Statement stmt = c.createStatement();){
            int i;
            stmt.execute("delete from g2");
            stmt.execute("delete from g1");
            for (i = 0; i < 100; ++i) {
                stmt.execute("insert into g1 (e1, e2) values(" + i + ",'" + i + "')");
            }
            for (i = 0; i < 50; ++i) {
                stmt.execute("insert into g2 (e1, e2) values(" + i + ",'" + i + "')");
            }
        }
    }

    public static void setup(ConnectionStrategy connStrategy) {
        if (connStrategy.isDataStoreDisabled()) {
            return;
        }
        try {
            DataStore.setUpTest(DataStore.getConnection("pm1", connStrategy));
            DataStore.setUpTest(DataStore.getConnection("pm2", connStrategy));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setUpTest(Connection c) throws Exception {
        try (Statement stmt = c.createStatement();){
            stmt.execute("delete from g2 where e1 >= 50");
            stmt.execute("delete from g1 where e1 >= 100");
        }
    }
}

