/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TempTableTestHarness;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.query.tempdata.TempTableDataManager;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestTempTables
extends TempTableTestHarness {
    private Transaction txn;
    private Synchronization synch;

    @Before
    public void setUp() {
        FakeDataManager fdm = new FakeDataManager();
        TestProcessor.sampleData1(fdm);
        this.setUp((QueryMetadataInterface)RealMetadataFactory.example1Cached(), fdm);
    }

    @Test
    public void testRollbackNoExisting() throws Exception {
        this.setupTransaction(8);
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) select e2, e1 from pm1.g1", new List[]{Arrays.asList(6)});
        this.execute("update x set e1 = e2 where e2 > 1", new List[]{Arrays.asList(2)});
        ((Transaction)Mockito.verify((Object)this.txn)).registerSynchronization((Synchronization)Mockito.anyObject());
        this.synch.afterCompletion(4);
        try {
            this.execute("select * from x", new List[0]);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
    }

    @Test
    public void testRollbackExisting() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.setupTransaction(8);
        for (int i = 0; i < 86; ++i) {
            this.execute("insert into x (e2, e1) select e2, e1 from pm1.g1", new List[]{Arrays.asList(6)});
        }
        this.execute("update x set e1 = e2 where e2 > 1", new List[]{Arrays.asList(172)});
        this.synch.afterCompletion(4);
        this.execute("select * from x", new List[0]);
    }

    @Test
    public void testCommitExistingRemoved() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.setupTransaction(8);
        this.execute("drop table x", new List[]{Arrays.asList(0)});
        this.synch.afterCompletion(3);
        try {
            this.execute("select * from x", new List[0]);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateLock() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.setupTransaction(8);
        this.execute("insert into x (e2, e1) select e2, e1 from pm1.g1", new List[]{Arrays.asList(6)});
        this.tc = null;
        try {
            this.execute("insert into x (e2, e1) select e2, e1 from pm1.g1", new List[]{Arrays.asList(6)});
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.synch.afterCompletion(3);
        this.execute("insert into x (e2, e1) select e2, e1 from pm1.g1", new List[]{Arrays.asList(6)});
    }

    @Test
    public void testRollbackExisting1() throws Exception {
        int i;
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        for (i = 0; i < 86; ++i) {
            this.execute("insert into x (e2, e1) select e2, e1 from pm1.g1", new List[]{Arrays.asList(6)});
        }
        this.setupTransaction(8);
        for (i = 0; i < 86; ++i) {
            this.execute("insert into x (e2, e1) select e2, e1 from pm1.g1", new List[]{Arrays.asList(6)});
        }
        this.execute("update x set e1 = e2 where e2 > 1", new List[]{Arrays.asList(344)});
        this.synch.afterCompletion(4);
        this.tc = null;
        this.execute("select count(*) from x", new List[]{Arrays.asList(516)});
        this.execute("delete from x", new List[]{Arrays.asList(516)});
    }

    @Test
    public void testIsolateReads() throws Exception {
        GlobalTableStoreImpl gtsi = new GlobalTableStoreImpl(BufferManagerFactory.getStandaloneBufferManager(), RealMetadataFactory.example1Cached().getVdbMetaData(), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        this.tempStore = gtsi.getTempTableStore();
        this.metadata = new TempMetadataAdapter((QueryMetadataInterface)RealMetadataFactory.example1Cached(), this.tempStore.getMetadataStore());
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        for (int i = 0; i < 300; ++i) {
            this.execute("insert into x (e2, e1) select e2, e1 from pm1.g1", new List[]{Arrays.asList(6)});
        }
        this.setupTransaction(8);
        this.execute("select count(e1) from x", new List[]{Arrays.asList(1500)});
        gtsi.updateMatViewRow("X", Arrays.asList(2L), true);
        this.tc = null;
        this.execute("select count(e1) from x", new List[]{Arrays.asList(1499)});
        this.setupTransaction(8);
        this.execute("select count(e1) from x", new List[]{Arrays.asList(1500)});
        this.synch.afterCompletion(3);
    }

    private void setupTransaction(int isolation) throws RollbackException, SystemException {
        this.txn = (Transaction)Mockito.mock(Transaction.class);
        ((Transaction)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                TestTempTables.this.synch = (Synchronization)invocation.getArguments()[0];
                return null;
            }
        }).when((Object)this.txn)).registerSynchronization((Synchronization)Mockito.anyObject());
        Mockito.stub((Object)this.txn.toString()).toReturn((Object)"txn");
        this.tc = new TransactionContext();
        this.tc.setTransaction(this.txn);
        this.tc.setIsolationLevel(isolation);
        this.tc.setTransactionType(TransactionContext.Scope.REQUEST);
    }

    @Test
    public void testInsertWithQueryExpression() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) select e2, e1 from pm1.g1", new List[]{Arrays.asList(6)});
        this.execute("update x set e1 = e2 where e2 > 1", new List[]{Arrays.asList(2)});
    }

    @Test
    public void testOutofOrderInsert() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("select e1, e2 from x", new List[]{Arrays.asList("one", 1)});
    }

    @Test
    public void testUpdate() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("select e1, e2 into x from pm1.g1", new List[]{Arrays.asList(6)});
        this.execute("update x set e1 = e2 where e2 > 1", new List[]{Arrays.asList(2)});
        this.execute("select e1 from x where e2 > 0 order by e1", new List[]{Arrays.asList(new String[]{null}), Arrays.asList("2"), Arrays.asList("3"), Arrays.asList("c"), Arrays.asList("one")});
    }

    @Test
    public void testDelete() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("select e1, e2 into x from pm1.g1", new List[]{Arrays.asList(6)});
        this.execute("delete from x where ascii(e1) > e2", new List[]{Arrays.asList(5)});
        this.execute("select e1 from x order by e1", new List[]{Arrays.asList(new String[]{null})});
    }

    @Test
    public void testDelete1() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("select e1, e2 into x from pm1.g1", new List[]{Arrays.asList(6)});
        this.execute("delete from x", new List[]{Arrays.asList(6)});
        this.execute("select e1 from x order by e1", new List[0]);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testDuplicatePrimaryKey() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
    }

    @Test
    public void testAtomicUpdate() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'one')", new List[]{Arrays.asList(1)});
        try {
            this.execute("update x set e2 = 3", new List[]{Arrays.asList(1)});
        }
        catch (TeiidProcessingException e) {
            // empty catch block
        }
        this.execute("select count(*) from x", new List[]{Arrays.asList(2)});
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    TestTempTables.this.execute("select count(e1) from x", new List[]{Arrays.asList(2)});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        t.join(2000L);
        Assert.assertFalse((boolean)t.isAlive());
    }

    @Test
    public void testAtomicDelete() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'one')", new List[]{Arrays.asList(1)});
        try {
            this.execute("delete from x where 1/(e2 - 2) <> 4", new List[]{Arrays.asList(1)});
        }
        catch (TeiidProcessingException teiidProcessingException) {
            // empty catch block
        }
        this.execute("select count(*) from x", new List[]{Arrays.asList(2)});
    }

    @Test
    public void testPrimaryKeyMetadata() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        Collection c = this.metadata.getUniqueKeysInGroup(this.metadata.getGroupID("x"));
        Assert.assertEquals((long)1L, (long)c.size());
        Assert.assertEquals((long)1L, (long)this.metadata.getElementIDsInKey(c.iterator().next()).size());
    }

    @Test
    public void testProjection() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("select * from x where e2 = 1", new List[]{Arrays.asList("one", 1)});
        this.execute("select e2, e1 from x where e2 = 1", new List[]{Arrays.asList(1, "one")});
    }

    @Test
    public void testOrderByWithIndex() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'one')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'one')", new List[]{Arrays.asList(1)});
        this.execute("select * from x as y order by e2 desc", new List[]{Arrays.asList("one", 3), Arrays.asList("one", 2)});
        this.execute("select * from x as y where e2 in (2, 3) order by e2 desc", new List[]{Arrays.asList("one", 3), Arrays.asList("one", 2)});
        this.execute("select * from x as y where e2 in (3, 2) order by e2", new List[]{Arrays.asList("one", 2), Arrays.asList("one", 3)});
        this.execute("select * from x as y where e2 in (3, 2) order by e2 desc", new List[]{Arrays.asList("one", 3), Arrays.asList("one", 2)});
    }

    @Test
    public void testOrderByWithoutIndex() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("select * from x order by e1", new List[]{Arrays.asList("a", 3), Arrays.asList("b", 2)});
    }

    @Test
    public void testCompareEqualsWithIndex() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("select * from x where e2 = 3", new List[]{Arrays.asList("a", 3)});
    }

    @Test
    public void testCompareLessThan() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (4, 'a')", new List[]{Arrays.asList(1)});
        ProcessorPlan plan = this.execute("select * from x where e2 < 4", new List[]{Arrays.asList("a", 3)});
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT x.e1, x.e2 FROM x WHERE x.e2 < 4"}, plan);
    }

    @Test
    public void testLikeWithIndex() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("select * from x where e1 like 'z%'", new List[0]);
    }

    @Test
    public void testLikeRegexWithIndex() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'ab')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("select * from x where e1 like_regex '^b?.*'", new List[]{Arrays.asList("ab", 3), Arrays.asList("b", 2)});
        this.execute("select * from x where e1 like_regex '^ab+.*'", new List[]{Arrays.asList("ab", 3)});
        this.execute("select * from x where e1 like_regex '^ab|b'", new List[]{Arrays.asList("ab", 3), Arrays.asList("b", 2)});
    }

    @Test
    public void testIsNullWithIndex() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, null)", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("select * from x where e1 is null", new List[]{Arrays.asList(null, 3)});
    }

    @Test
    public void testInWithIndex() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (1, 'c')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (0, 'd')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (-1, 'e')", new List[]{Arrays.asList(1)});
        this.execute("select * from x where e1 in ('a', 'c', 'e', 'f', 'g')", new List[]{Arrays.asList("a", 3), Arrays.asList("c", 1), Arrays.asList("e", -1)});
    }

    @Test
    public void testInWithIndexUpdate() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, e3 string, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (1, 'c')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (0, 'd')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1, e3) values (-1, 'e', 'e')", new List[]{Arrays.asList(1)});
        this.execute("update x set e2 = 5 where e1 in ('a', 'c')", new List[]{Arrays.asList(2)});
        this.execute("select * from x where e1 in ('b', e3)", new List[]{Arrays.asList("b", 2, null), Arrays.asList("e", -1, "e")});
    }

    @Test
    public void testCompositeKeyCompareEquals() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1, e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (1, 'c')", new List[]{Arrays.asList(1)});
        this.execute("select * from x where e1 = 'b' and e2 = 2", new List[]{Arrays.asList("b", 2)});
    }

    @Test
    public void testCompositeKeyPartial() throws Exception {
        this.sampleTable();
        this.execute("select * from x where e1 = 'b'", new List[]{Arrays.asList("b", 2), Arrays.asList("b", 3)});
    }

    @Test
    public void testCompositeKeyPartial1() throws Exception {
        this.sampleTable();
        this.execute("select * from x where e1 < 'c'", new List[]{Arrays.asList("a", 1), Arrays.asList("b", 2), Arrays.asList("b", 3)});
    }

    @Test
    public void testCompositeKeyPartial2() throws Exception {
        this.sampleTable();
        this.execute("select * from x where e2 = 1", new List[]{Arrays.asList("a", 1), Arrays.asList("c", 1)});
    }

    @Test
    public void testCompositeKeyPartial3() throws Exception {
        this.sampleTable();
        this.execute("select * from x where e1 >= 'b'", new List[]{Arrays.asList("b", 2), Arrays.asList("b", 3), Arrays.asList("c", 1)});
    }

    @Test
    public void testCompositeKeyPartial4() throws Exception {
        this.sampleTable();
        this.execute("select * from x where e1 >= 'b' order by e1 desc, e2 desc", new List[]{Arrays.asList("c", 1), Arrays.asList("b", 3), Arrays.asList("b", 2)});
    }

    @Test
    public void testCompositeKeyPartial5() throws Exception {
        this.sampleTable();
        this.execute("select * from x where e1 in ('a', 'b')", new List[]{Arrays.asList("a", 1), Arrays.asList("b", 2), Arrays.asList("b", 3)});
    }

    @Test
    public void testCompositeKeyPartial6() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1, e2))", new List[]{Arrays.asList(0)});
        this.execute("select * from x where e1 in ('a', 'b') order by e1 desc", new List[0]);
    }

    @Test
    public void testCountStar() throws Exception {
        this.sampleTable();
        this.execute("select count(*) a from x", new List[]{Arrays.asList(4)});
        this.execute("select count(*) a from x where e2 = 1 order by a", new List[]{Arrays.asList(2)});
    }

    @Test
    public void testAutoIncrement() throws Exception {
        this.execute("create local temporary table x (e1 serial, e2 integer, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2) values (1)", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2) values (3)", new List[]{Arrays.asList(1)});
        this.execute("select * from x", new List[]{Arrays.asList(1, 1), Arrays.asList(2, 3)});
    }

    @Test
    public void testAutoIncrement1() throws Exception {
        this.execute("create local temporary table x (e1 serial, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2) values (1)", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2) values (3)", new List[]{Arrays.asList(1)});
        this.execute("select * from x", new List[]{Arrays.asList(1, 1), Arrays.asList(2, 3)});
    }

    @Test(expected=TeiidProcessingException.class)
    public void testNotNull() throws Exception {
        this.execute("create local temporary table x (e1 serial, e2 integer not null, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e1, e2) values ((select null), 1)", new List[]{Arrays.asList(1)});
    }

    @Test(expected=TeiidProcessingException.class)
    public void testNotNull1() throws Exception {
        this.execute("create local temporary table x (e1 serial, e2 integer not null, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2) values ((select null))", new List[]{Arrays.asList(1)});
    }

    @Test
    public void testSessionResolving() throws Exception {
        this.execute("create local temporary table temp_table (column1 integer)", new List[]{Arrays.asList(0)});
        this.execute("exec pm1.vsp60()", new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")});
    }

    @Test
    public void testCompositeKeyJoinUsesKeyOrder() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1, e2))", new List[]{Arrays.asList(0)});
        this.execute("create local temporary table x1 (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        TestOptimizer.helpPlan("select * from /*+ makenotdep */ x, /*+ makenotdep */ x1 where x.e2 = x1.e2 and x.e1 = x1.e1", (QueryMetadataInterface)this.metadata, new String[]{"SELECT x1.e2, x1.e1 FROM x1 ORDER BY x1.e1, x1.e2", "SELECT x.e2, x.e1 FROM x ORDER BY x.e1, x.e2"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testUnneededMergePredicate() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("create local temporary table x1 (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        TestOptimizer.helpPlan("select x.e1 from x makenotdep, x1 makenotdep where x.e2 = x1.e2 and x.e1 = x1.e1", (QueryMetadataInterface)this.metadata, new String[]{"SELECT x.e2, x.e1 FROM x ORDER BY x.e1", "SELECT x1.e2, x1.e1 FROM x1 ORDER BY x1.e1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("insert into x1 (e2, e1) values (3, 'b')", new List[]{Arrays.asList(1)});
        this.execute("select x.e1 from x makenotdep, x1 makenotdep where x.e2 = x1.e2 and x.e1 = x1.e1", new List[0]);
        this.execute("select x.e1 from x left outer join x1 on x.e2 = x1.e2 and x.e1 = x1.e1", new List[]{Arrays.asList("b")});
    }

    @Test
    public void testUnneededMergePredicate1() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, e3 integer, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("create local temporary table x1 (e1 string, e2 integer, e3 integer)", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e3, e2, e1) values (4, 2, '1')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e3, e2, e1) values (4, 2, '2')", new List[]{Arrays.asList(1)});
        this.execute("insert into x1 (e3, e2, e1) values (5, 2, '1')", new List[]{Arrays.asList(1)});
        this.execute("insert into x1 (e3, e2, e1) values (5, 1, '2')", new List[]{Arrays.asList(1)});
        this.execute("select x.e1, upper(x.e1),  x1.e2 from /*+ makenotdep */ x inner join  /*+ makenotdep */ x1 on x.e1 = x1.e1 and upper(x.e1) = x1.e2", new List[0]);
        this.execute("select x.e1 from /*+ makenotdep */ x inner join  /*+ makenotdep */ x1 on x.e1 = x1.e1 and upper(x.e1) = x1.e2 and x1.e3 = x.e3", new List[0]);
        this.execute("select x.e1 from /*+ makedep */ x inner join  x1 on x.e1 = x1.e1 and x.e2 = x1.e2", new List[]{Arrays.asList("1")});
    }

    private void sampleTable() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1, e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'b')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (1, 'c')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (1, 'a')", new List[]{Arrays.asList(1)});
    }

    @Test
    public void testForeignTemp() throws Exception {
        HardcodedDataManager hdm = new HardcodedDataManager((QueryMetadataInterface)this.metadata);
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        SessionAwareCache cache = new SessionAwareCache("resultset", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.RESULTSET, 0);
        cache.setTupleBufferCache((TupleBufferCache)bm);
        this.dataManager = new TempTableDataManager((ProcessorDataManager)hdm, bm, cache);
        this.execute("create foreign temporary table x (e1 string options (nameinsource 'a'), e2 integer, e3 string, primary key (e1)) options (cardinality 1000, updatable true, \"other\" 'prop') on pm1", new List[]{Arrays.asList(0)});
        TempMetadataID id = (TempMetadataID)this.tempStore.getMetadataStore().getData().get("x");
        Assert.assertNotNull((Object)id);
        Assert.assertNotNull((Object)this.metadata.getPrimaryKey((Object)id));
        Assert.assertEquals((float)1000.0f, (float)this.metadata.getCardinality((Object)id), (float)0.0f);
        Assert.assertEquals((Object)"pm1", (Object)this.metadata.getName(this.metadata.getModelID((Object)id)));
        Assert.assertEquals((Object)"prop", (Object)this.metadata.getExtensionProperty((Object)id, "other", false));
        hdm.addData("SELECT x.a, x.e2, x.e3 FROM x", Arrays.asList(1, 2, "3"));
        this.execute("select * from x", new List[]{Arrays.asList(1, 2, "3")});
        hdm.addData("SELECT g_0.e2 AS c_0, g_0.e3 AS c_1, g_0.a AS c_2 FROM x AS g_0 ORDER BY c_1, c_0", Arrays.asList(2, "3", "1"));
        hdm.addData("SELECT g_0.e3, g_0.e2 FROM x AS g_0", Arrays.asList("3", 2));
        hdm.addData("DELETE FROM x WHERE x.a = '1'", Arrays.asList(1));
        this.execute("delete from x where e2 = (select max(e2) from x as z where e3 = x.e3)", new List[]{Arrays.asList(1)}, TestOptimizer.getGenericFinder());
        hdm.addData("SELECT g_0.e1 FROM g1 AS g_0, x AS g_1 WHERE g_1.a = g_0.e1", Arrays.asList(1));
        this.execute("select g1.e1 from pm1.g1 g1, x where x.e1 = g1.e1", new List[]{Arrays.asList(1)}, TestOptimizer.getGenericFinder());
        try {
            this.execute("create local temporary table x (e1 string)", new List[]{Arrays.asList(0)});
            Assert.fail();
        }
        catch (QueryResolverException e) {
            // empty catch block
        }
        this.execute("drop table x", new List[]{Arrays.asList(0)});
        try {
            this.execute("drop table x", new List[]{Arrays.asList(0)});
            Assert.fail();
        }
        catch (QueryResolverException e) {
            // empty catch block
        }
    }

    @Test
    public void testInherentUpdateUsingTemp() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.fromDDL("create foreign table g1 (e1 string primary key, e2 integer, e3 boolean, e4 double, FOREIGN KEY (e1) REFERENCES G2 (e1)) options (updatable true); create foreign table g2 (e1 string primary key, e2 integer, e3 boolean, e4 double) options (updatable true); create view v options (updatable true) as select g1.e2 from g1 inner join g2 on g1.e1 = g2.e1;", "x", "pm1");
        HardcodedDataManager hdm = new HardcodedDataManager((QueryMetadataInterface)metadata);
        this.setUp((QueryMetadataInterface)metadata, hdm);
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        SessionAwareCache cache = new SessionAwareCache("resultset", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.RESULTSET, 0);
        cache.setTupleBufferCache((TupleBufferCache)bm);
        this.dataManager = new TempTableDataManager((ProcessorDataManager)hdm, bm, cache);
        this.execute("create temporary table x (e1 string, e2 integer, e3 string, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x values ('a', 1, 'b')", new List[]{Arrays.asList(1)});
        TempMetadataID id = (TempMetadataID)this.tempStore.getMetadataStore().getData().get("x");
        Assert.assertNotNull((Object)id);
        Assert.assertNotNull((Object)this.metadata.getPrimaryKey((Object)id));
        hdm.addData("SELECT g_0.e1 FROM g1 AS g_0, g2 AS g_1 WHERE g_0.e1 = g_1.e1 AND g_0.e2 = 1", Arrays.asList("a"));
        hdm.addData("DELETE FROM g1 WHERE g1.e1 = 'a'", Arrays.asList(1));
        this.execute("delete from v where e2 = (select max(e2) from x as z where e3 = z.e3)", new List[]{Arrays.asList(1)}, TestOptimizer.getGenericFinder());
    }

    @Test
    public void testDependentArrayType() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, e3 integer, primary key (e2, e3))", new List[]{Arrays.asList(0)});
        this.execute("create local temporary table x1 (e1 string, e2 integer, e3 integer)", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e3, e2, e1) values (4, 2, '1')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e3, e2, e1) values (3, 2, '2')", new List[]{Arrays.asList(1)});
        this.execute("insert into x1 (e3, e2, e1) values (4, 2, '1')", new List[]{Arrays.asList(1)});
        this.execute("insert into x1 (e3, e2, e1) values (3, 2, '2')", new List[]{Arrays.asList(1)});
        this.execute("select x.e1 from x inner join /*+ makeind */ x1 on x.e2 = x1.e2 and x.e3 = x1.e3 and x1.e1='1'", new List[]{Arrays.asList("1")});
        this.execute("select x.e1 from x inner join /*+ makeind */ x1 on x.e2 = x1.e2 and x.e3 = x1.e3", new List[]{Arrays.asList("2"), Arrays.asList("1")});
        this.execute("select x.e1 from x inner join /*+ makeind */ x1 on x.e3 = x1.e3 and x.e2 = x1.e2", new List[]{Arrays.asList("2"), Arrays.asList("1")});
    }

    @Test
    public void testSubquery() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, e3 integer, primary key (e2, e3))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e3, e2, e1) values (4, 2, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e3, e2, e1) values (4, 3, '1')", new List[]{Arrays.asList(1)});
        this.execute("update x set e1 = 1 where e1 in (select e1 from pm1.g1)", new List[]{Arrays.asList(1)});
    }

    @Test
    public void testIndexInPredicate() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1))", new List[]{Arrays.asList(0)});
        for (int i = 0; i < 2048; ++i) {
            this.execute("insert into x (e2, e1) values (" + i + ", '" + i + "')", new List[]{Arrays.asList(1)});
        }
        this.execute("select e2, e1 from x where e1 in ('2000', '1')", new List[]{Arrays.asList(1, "1"), Arrays.asList(2000, "2000")});
    }

    @Test
    public void testDeleteRemovingPage() throws Exception {
        this.execute("insert into #tmp_params select parsetimestamp('2016-04-01','yyyy-MM-dd') as starttime, parsetimestamp('2016-04-15','yyyy-MM-dd') as endtime", new List[]{Arrays.asList(1)});
        this.execute("insert into #tmp_dates select cast(parsetimestamp('2016-03-20','yyyy-MM-dd') as date) as datum, 'somevalue' as somevalue UNION select cast(parsetimestamp('2016-04-02','yyyy-MM-dd') as date) as datum, 'somevalue' as somevalue UNION select cast(parsetimestamp('2016-04-20','yyyy-MM-dd') as date) as datum, 'somevalue' as somevalue", new List[]{Arrays.asList(3)});
        for (int i = 0; i < 1277; ++i) {
            this.execute("insert into #tmp_dates select DATE '2016-05-01' as datum, 'somevalue' as somevalue", new List[]{Arrays.asList(1)});
        }
        this.execute("delete from #tmp_dates where datum > (select cast(endtime as date) from #tmp_params)", new List[]{Arrays.asList(1024)});
        this.execute("delete from #tmp_dates where datum < (select cast(starttime as date) from #tmp_params)", new List[]{Arrays.asList(1)});
    }

    @Test
    public void testImplicitResolvingWithoutColumns() throws Exception {
        this.execute("insert into #tmp_dates select cast(parsetimestamp('2016-03-20','yyyy-MM-dd') as date) as datum, 'somevalue' as somevalue UNION select cast(parsetimestamp('2016-04-02','yyyy-MM-dd') as date) as datum, 'somevalue' as somevalue UNION select cast(parsetimestamp('2016-04-20','yyyy-MM-dd') as date) as datum, 'somevalue' as somevalue", new List[]{Arrays.asList(3)});
        this.execute("insert into #tmp_dates select DATE '2016-05-01', somevalue from #tmp_dates", new List[]{Arrays.asList(3)});
    }
}

