/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TestMMDatabaseMetaData;

public class TestSystemVirtualModel
extends AbstractMMQueryTestCase {
    private static final String VDB = "PartsSupplier";
    private static FakeServer server;

    @BeforeClass
    public static void setup() throws Exception {
        server = new FakeServer(true);
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("x");
        mmd.setModelType(Model.Type.VIRTUAL);
        mmd.addSourceMetadata("DDL", "create view t as select 1");
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("y");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.addSourceMetadata("DDL", "create view T as select 1");
        server.deployVDB("test", new ModelMetaData[]{mmd, mmd1});
        ModelMetaData mmd2 = new ModelMetaData();
        mmd2.setName("x");
        mmd2.setModelType(Model.Type.VIRTUAL);
        mmd2.addSourceMetadata("DDL", "create view t (g geometry options (\"teiid_spatial:srid\" 3819)) as select null;");
        server.deployVDB("test1", new ModelMetaData[]{mmd2});
    }

    @AfterClass
    public static void teardown() throws Exception {
        server.stop();
    }

    public TestSystemVirtualModel() {
        this.DELIMITER = "\t";
    }

    @Before
    public void setUp() throws Exception {
        this.internalConnection = server.createConnection("jdbc:teiid:PartsSupplier");
    }

    protected void checkResult(String testName, String query) throws Exception {
        this.execute(query);
        TestMMDatabaseMetaData.compareResultSet("TestSystemVirtualModel/" + testName, this.internalResultSet);
    }

    @Test
    public void testModels() throws Exception {
        this.checkResult("testSchemas", "select* from SYS.Schemas order by Name");
    }

    @Test
    public void testKeys() throws Exception {
        this.checkResult("testKeys", "select* from SYS.Keys order by Name");
    }

    @Test
    public void testGroups() throws Exception {
        this.checkResult("testTables", "select* from SYS.Tables order by Name");
    }

    @Test
    public void testDataTypes() throws Exception {
        this.checkResult("testDataTypes", "select * from SYS.DataTypes order by name");
    }

    @Test
    public void testProcedureParams() throws Exception {
        this.checkResult("testProcedureParams", "select * from SYS.ProcedureParams order by Name");
    }

    @Test
    public void testProcedures() throws Exception {
        this.checkResult("testProcedures", "select* from SYS.Procedures order by Name");
    }

    @Test
    public void testProperties() throws Exception {
        this.checkResult("testProperties", "select* from SYS.Properties");
    }

    @Test
    public void testVirtualDatabase() throws Exception {
        String[] expected = new String[]{"Name[string]\tVersion[string]\t", "PartsSupplier\t1"};
        this.executeAndAssertResults("select* from SYS.VirtualDatabases", expected);
    }

    @Test
    public void testKeyColumns() throws Exception {
        this.checkResult("testKeyColumns", "select* from SYS.KeyColumns order by Name, KeyName");
    }

    @Test
    public void testVDBResources() throws IOException, SQLException {
        this.execute("select * from vdbresources order by resourcePath", new Object[0]);
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void testColumns() throws Exception {
        this.checkResult("testColumns", "select* from SYS.Columns order by Name, uid");
    }

    @Test
    public void testTableType() throws Exception {
        String[] expected = new String[]{"Type[string]\t", "Table"};
        this.executeAndAssertResults("select distinct Type from SYS.Tables order by Type", expected);
    }

    @Test
    public void testTableIsSystem() throws Exception {
        this.checkResult("testTableIsSystem", "select Name from SYS.Tables where IsSystem = 'false' order by Name");
    }

    @Test
    public void testDefect12064() throws Exception {
        this.checkResult("testDefect12064", "select KeyName, RefKeyUID FROM SYS.KeyColumns WHERE RefKeyUID IS NULL order by KeyName");
    }

    @Test
    public void testReferenceKeyColumns() throws Exception {
        this.checkResult("testReferenceKeyColumns", "select* FROM SYS.ReferenceKeyColumns order by PKTABLE_NAME");
    }

    @Test
    public void testLogMsg() throws Exception {
        this.execute("call logMsg(level=>'DEBUG', context=>'org.teiid.foo', msg=>'hello world')");
    }

    @Test(expected=SQLException.class)
    public void testLogMsg1() throws Exception {
        this.execute("call logMsg(level=>'foo', context=>'org.teiid.foo', msg=>'hello world')");
    }

    @Test
    public void testCallableParametersByName() throws Exception {
        CallableStatement cs = this.internalConnection.prepareCall("{? = call logMsg(?, ?, ?)}");
        ParameterMetaData pmd = cs.getParameterMetaData();
        Assert.assertEquals((long)3L, (long)pmd.getParameterCount());
        cs.registerOutParameter("logged", 16);
        cs.setString("LEVEL", "DEBUG");
        try {
            cs.setString("n", "");
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        cs.setString("context", "org.teiid.foo");
        cs.setString("msg", "hello world");
        cs.execute();
        Assert.assertEquals((Object)cs.getBoolean(1), (Object)cs.getBoolean("logged"));
    }

    @Test
    public void testArrayAggType() throws Exception {
        String sql = "SELECT array_agg(name) from tables";
        this.checkResult("testArrayAggType", sql);
    }

    @Test
    public void testExecuteUpdateWithStoredProcedure() throws Exception {
        PreparedStatement cs = this.internalConnection.prepareStatement("call logMsg(?, ?, ?)");
        cs.setString(1, "DEBUG");
        cs.setString(2, "org.teiid.foo");
        cs.setString(3, "hello world");
        Assert.assertEquals((long)0L, (long)cs.executeUpdate());
        Statement s = this.internalConnection.createStatement();
        Assert.assertEquals((long)0L, (long)s.executeUpdate("call logMsg('DEBUG', 'org.teiid.foo', 'hello world')"));
    }

    @Test
    public void testExpectedTypes() throws Exception {
        ResultSet rs = this.internalConnection.createStatement().executeQuery("select name from tables where schemaname in ('SYS', 'SYSADMIN')");
        while (rs.next()) {
            String name = rs.getString(1);
            ResultSet rs1 = this.internalConnection.createStatement().executeQuery("select * from " + name + " limit 1");
            ResultSetMetaData metadata = rs1.getMetaData();
            if (!rs1.next()) continue;
            for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                Object o = rs1.getObject(i);
                Assert.assertTrue((String)("Type mismatch for " + name + " " + metadata.getColumnName(i)), (o == null || Class.forName(metadata.getColumnClassName(i)).isAssignableFrom(o.getClass()) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testPrefixSearches() throws Exception {
        this.execute("select name from schemas where ucase(name) >= 'BAZ_BAR' and ucase(name) <= 'A'");
        this.assertRowCount(0);
        this.execute("select name from schemas where upper(name) like 'ab[_'");
        this.assertRowCount(0);
    }

    @Test
    public void testColumnsIn() throws Exception {
        this.internalConnection.close();
        this.internalConnection = server.createConnection("jdbc:teiid:test");
        this.execute("select tablename, name from columns where tablename in ('t', 'T')");
        this.assertRowCount(2);
        this.execute("select tablename, name from columns where upper(tablename) in ('t', 's')");
        this.assertRowCount(0);
    }

    @Test
    public void testViews() throws Exception {
        this.checkResult("testViews", "select Name, Body from Views order by Name");
    }

    @Test
    public void testStoredProcedures() throws Exception {
        this.checkResult("testStoredProcedures", "select Name, Body from StoredProcedures order by Name");
    }

    @Test
    public void testUsage() throws Exception {
        this.checkResult("testUsgae", "select * from usage");
    }

    @Test
    public void testFunctions() throws Exception {
        this.checkResult("testFunctions", "select * from functions");
    }

    @Test
    public void testFunctionParameters() throws Exception {
        this.checkResult("testFunctionParams", "select * from FunctionParams");
    }

    @Test
    public void testSpatial() throws Exception {
        this.checkResult("testSpatial", "select * from spatial_ref_sys");
    }

    @Test
    public void testGeometryColumns() throws Exception {
        this.internalConnection.close();
        this.internalConnection = server.createConnection("jdbc:teiid:test1");
        this.checkResult("testGeometryColumns", "select * from GEOMETRY_COLUMNS");
    }

    @Test
    public void testArrayIterate() throws Exception {
        String sql = "select array_get(cast(x.col as string[]), 2) from (exec arrayiterate((('a', 'b'),('c','d')))) x";
        this.execute(sql);
        this.assertResults(new String[]{"expr1[string]", "b", "d"});
        sql = "select array_get(cast(x.col as string[]), 2) from (exec arrayiterate(null)) x";
        this.execute(sql);
        this.assertRowCount(0);
    }

    @Test
    public void testCloseOnCompletion() throws Exception {
        String sql = "values (1)";
        this.execute(sql);
        this.internalStatement.closeOnCompletion();
        this.internalResultSet.close();
        Assert.assertTrue((boolean)this.internalStatement.isClosed());
        sql = "values (1)";
        this.execute(sql);
        this.internalStatement.closeOnCompletion();
        try {
            this.internalStatement.execute(sql);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

