/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;

public class ExecResolver
extends ProcedureContainerResolver {
    private void findCommandMetadata(Command command, TempMetadataStore discoveredMetadata, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Expression expr;
        StoredProcedureInfo storedProcedureInfo;
        StoredProcedure storedProcedureCommand;
        block36: {
            storedProcedureCommand = (StoredProcedure)command;
            storedProcedureInfo = null;
            try {
                storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(storedProcedureCommand.getProcedureName());
            }
            catch (QueryMetadataException e) {
                String[] parts = storedProcedureCommand.getProcedureName().split("\\.", 2);
                if (parts.length > 1 && parts[0].equalsIgnoreCase(metadata.getVirtualDatabaseName())) {
                    try {
                        storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(parts[1]);
                        storedProcedureCommand.setProcedureName(parts[1]);
                    }
                    catch (QueryMetadataException e1) {
                        // empty catch block
                    }
                }
                if (storedProcedureInfo != null) break block36;
                throw e;
            }
        }
        storedProcedureCommand.setUpdateCount(storedProcedureInfo.getUpdateCount());
        storedProcedureCommand.setModelID(storedProcedureInfo.getModelID());
        storedProcedureCommand.setProcedureID(storedProcedureInfo.getProcedureID());
        storedProcedureCommand.setProcedureCallableName(storedProcedureInfo.getProcedureCallableName());
        Collection<SPParameter> oldParams = storedProcedureCommand.getParameters();
        boolean namedParameters = storedProcedureCommand.displayNamedParameters();
        if (oldParams.size() == 0 || oldParams.size() == 1 && storedProcedureCommand.isCalledWithReturn()) {
            storedProcedureCommand.setDisplayNamedParameters(true);
            namedParameters = true;
        }
        TreeMap<Integer, Expression> positionalExpressions = new TreeMap<Integer, Expression>();
        TreeMap<String, Expression> namedExpressions = new TreeMap<String, Expression>(String.CASE_INSENSITIVE_ORDER);
        int adjustIndex = 0;
        for (SPParameter param : oldParams) {
            if (param.getExpression() == null) {
                if (param.getParameterType() != 5) continue;
                --adjustIndex;
                continue;
            }
            if (namedParameters && param.getParameterType() != 4) {
                if (namedExpressions.put(param.getParameterSymbol().getShortName(), param.getExpression()) == null) continue;
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30138, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30138, new Object[]{param.getName()}));
            }
            positionalExpressions.put(param.getIndex() + adjustIndex, param.getExpression());
        }
        storedProcedureCommand.clearParameters();
        int origInputs = positionalExpressions.size() + namedExpressions.size();
        List<SPParameter> metadataParams = storedProcedureInfo.getParameters();
        ArrayList<SPParameter> clonedMetadataParams = new ArrayList<SPParameter>(metadataParams.size());
        int inputParams = 0;
        int optionalParams = 0;
        int outParams = 0;
        boolean hasReturnValue = false;
        boolean optional = false;
        boolean varargs = false;
        for (int i = 0; i < metadataParams.size(); ++i) {
            SPParameter metadataParameter = metadataParams.get(i);
            if (metadataParameter.getParameterType() == 1 || metadataParameter.getParameterType() == 3) {
                if (ResolverUtil.hasDefault(metadataParameter.getMetadataID(), metadata) || metadataParameter.isVarArg()) {
                    optional = true;
                    ++optionalParams;
                } else {
                    ++inputParams;
                    if (optional) {
                        optional = false;
                        inputParams += optionalParams;
                        optionalParams = 0;
                    }
                }
                if (metadataParameter.isVarArg()) {
                    varargs = true;
                }
            } else if (metadataParameter.getParameterType() == 2) {
                ++outParams;
            } else if (metadataParameter.getParameterType() == 4) {
                hasReturnValue = true;
            }
            SPParameter clonedParam = (SPParameter)metadataParameter.clone();
            clonedMetadataParams.add(clonedParam);
            storedProcedureCommand.setParameter(clonedParam);
        }
        if (storedProcedureCommand.isCalledWithReturn() && !hasReturnValue) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30139, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30139, new Object[]{storedProcedureCommand.getGroup()}));
        }
        if (!namedParameters && inputParams > positionalExpressions.size()) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30140, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30140, new Object[]{inputParams, inputParams + optionalParams + (varargs ? "+" : ""), origInputs, storedProcedureCommand.getGroup()}));
        }
        int exprIndex = 1;
        HashSet<String> expected = new HashSet<String>();
        if (storedProcedureCommand.isCalledWithReturn() && hasReturnValue) {
            for (SPParameter param : clonedMetadataParams) {
                if (param.getParameterType() != 4) continue;
                expr = (Expression)positionalExpressions.remove(exprIndex++);
                param.setExpression(expr);
                break;
            }
        }
        for (SPParameter param : clonedMetadataParams) {
            if (param.getParameterType() == 5 || param.getParameterType() == 4) continue;
            if (namedParameters) {
                String nameKey = param.getParameterSymbol().getShortName();
                Expression expr2 = (Expression)namedExpressions.remove(nameKey);
                if (expr2 == null && param.getParameterType() != 2) {
                    param.setUsingDefault(true);
                    expected.add(nameKey);
                    if (!param.isVarArg()) {
                        expr2 = ResolverUtil.getDefault(param.getParameterSymbol(), metadata);
                    } else {
                        ArrayList<Expression> exprs = new ArrayList<Expression>(0);
                        Array array = new Array(exprs);
                        array.setImplicit(true);
                        array.setType(param.getClassType());
                        expr2 = array;
                    }
                }
                param.setExpression(expr2);
                continue;
            }
            expr = (Expression)positionalExpressions.remove(exprIndex++);
            if (param.getParameterType() == 2) {
                if (expr == null) continue;
                boolean isRef = expr instanceof Reference;
                if (!isRef || exprIndex <= inputParams + 1) {
                    positionalExpressions.put(--exprIndex, expr);
                    continue;
                }
                if (!isRef) continue;
                Reference ref = (Reference)expr;
                ref.setOptional(true);
                continue;
            }
            if (expr == null) {
                if (!param.isVarArg()) {
                    expr = ResolverUtil.getDefault(param.getParameterSymbol(), metadata);
                }
                param.setUsingDefault(true);
            }
            if (param.isVarArg()) {
                ArrayList<Expression> exprs = new ArrayList<Expression>(positionalExpressions.size() + 1);
                if (expr != null) {
                    exprs.add(expr);
                }
                exprs.addAll(positionalExpressions.values());
                positionalExpressions.clear();
                Array array = new Array(exprs);
                array.setImplicit(true);
                array.setType(param.getClassType());
                expr = array;
            }
            param.setExpression(expr);
        }
        if (!namedExpressions.isEmpty()) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30141, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30141, new Object[]{namedExpressions.keySet(), expected}));
        }
        if (!positionalExpressions.isEmpty()) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31113, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31113, new Object[]{positionalExpressions.size(), origInputs, storedProcedureCommand.getGroup().toString()}));
        }
        String procName = storedProcedureCommand.getProcedureName();
        List tempElements = storedProcedureCommand.getProjectedSymbols();
        boolean isVirtual = storedProcedureInfo.getQueryPlan() != null;
        discoveredMetadata.addTempGroup(procName, tempElements, isVirtual);
        GroupSymbol procGroup = new GroupSymbol(storedProcedureInfo.getProcedureCallableName());
        procGroup.setProcedure(true);
        TempMetadataID tid = discoveredMetadata.getTempGroupID(procName);
        tid.setOriginalMetadataID(storedProcedureCommand.getProcedureID());
        procGroup.setMetadataID(tid);
        storedProcedureCommand.setGroup(procGroup);
    }

    @Override
    public void resolveProceduralCommand(Command command, TempMetadataAdapter metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        this.findCommandMetadata(command, metadata.getMetadataStore(), metadata);
        StoredProcedure storedProcedureCommand = (StoredProcedure)command;
        GroupContext externalGroups = storedProcedureCommand.getExternalGroupContexts();
        for (SPParameter param : storedProcedureCommand.getParameters()) {
            Expression expr = param.getExpression();
            if (expr == null) continue;
            for (SubqueryContainer<?> container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr)) {
                QueryResolver.setChildMetadata(container.getCommand(), command);
                QueryResolver.resolveCommand(container.getCommand(), metadata.getMetadata());
            }
            try {
                ResolverVisitor.resolveLanguageObject(expr, null, externalGroups, metadata);
            }
            catch (QueryResolverException e) {
                if (this.checkForArray(param, expr)) continue;
                throw e;
            }
            Class<?> paramType = param.getClassType();
            ResolverUtil.setDesiredType(expr, paramType, storedProcedureCommand);
            Class<?> exprType = expr.getType();
            if (paramType == null || exprType == null) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30143, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30143, new Object[]{storedProcedureCommand.getProcedureName(), param.getName()}));
            }
            String tgtType = DataTypeManager.getDataTypeName(paramType);
            String srcType = DataTypeManager.getDataTypeName(exprType);
            Expression result = null;
            if (param.getParameterType() == 4 || param.getParameterType() == 2) {
                if (ResolverUtil.canImplicitlyConvert(tgtType, srcType)) continue;
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30144, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30144, new Object[]{param.getParameterSymbol(), tgtType, srcType}));
            }
            try {
                result = ResolverUtil.convertExpression(expr, tgtType, metadata);
            }
            catch (QueryResolverException e) {
                throw new QueryResolverException(QueryPlugin.Event.TEIID30145, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30145, new Object[]{param.getParameterSymbol(), srcType, tgtType}));
            }
            param.setExpression(result);
        }
    }

    private boolean checkForArray(SPParameter param, Expression expr) {
        Expression first;
        if (!param.isVarArg() || !(expr instanceof Array)) {
            return false;
        }
        Array array = (Array)expr;
        if (array.getExpressions().size() == 1 && (first = array.getExpressions().get(0)).getType() != null && first.getType() == array.getType()) {
            param.setExpression(first);
            return true;
        }
        return false;
    }

    @Override
    protected void resolveGroup(TempMetadataAdapter metadata, ProcedureContainer procCommand) throws TeiidComponentException, QueryResolverException {
    }

    @Override
    protected String getPlan(QueryMetadataInterface metadata, GroupSymbol group) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        StoredProcedureInfo storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(group.getName());
        QueryNode plan = storedProcedureInfo.getQueryPlan();
        if (plan.getQuery() == null) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30146, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30146, new Object[]{group}));
        }
        return plan.getQuery();
    }
}

